/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.common.ui.nodes;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.FQNSearch;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.ui.nodes.editors.TypeEditor;
import org.netbeans.modules.j2ee.common.ui.nodes.elements.ElementNode;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

import org.openide.explorer.propertysheet.*;
import org.openide.*;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.NbBundle;


/** 
 * Customizer for Method
 *
 * @author Petr Hamernik
 * @author Martin Adamek
 */
public class MethodCustomizer extends JPanel {
    
    public static final String OK_ENABLED = "ok_enabled"; //NOI18N
    
    private MethodNameListener methodNameListener;

    /** Predefined types in the type combo */
    private static final String[] COMMON_TYPES = TypeEditor.RVALUE_TYPES;
    
    /** In case that method is edited - this field holds
     * the reference to it. Otherwise (Constructor) this field
     * is <CODE>null</CODE>.
     */
    private Method method;
    
    boolean isOK = true;
    // see issue 69510, addPropertyChangeListener() and then isOK() was called before nameTextField was initialized
    private boolean isInitialized = false;
    private String methodName;
    private boolean waitingScanFinished = false;

    /** Create new MethodCustomizer component
     * @param element The method or constructor to be customized
     */
    public MethodCustomizer(Method element) {
        this.method = element;
        methodName = method.getName();
        initComponents();
        this.isInitialized = true;
        ResourceBundle bundle = NbBundle.getBundle(MethodCustomizer.class);

        Color c = UIManager.getColor("nb.errorForeground"); //NOI18N
        errorField.setForeground(c == null ? new Color(89, 79, 191) : c);

        // borders
        methodPanel.setBorder(new CompoundBorder(
                new TitledBorder(bundle.getString("CTL_MethodFrame")),
                new EmptyBorder(new java.awt.Insets(5, 5, 5, 5)))
                );

        // name
        nameTextField.setText(element.getName().toString());
        returnTypeComboBox.setSelectedItem(element.getType() == null ? returnTypeComboBox.getItemAt(0) : element.getType().getName());

        GridBagConstraints gridBagConstraints;
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 0);

        // parameters
        PropertyPanel paramsEditor = new PropertyPanel(
                ElementNode.createParametersProperty(element, true),
                PropertyPanel.PREF_CUSTOM_EDITOR
        );
        FeatureDescriptor fd = paramsEditor.getProperty();
        fd.setValue("mnemonic_Add", bundle.getString("CTL_Parameters_Mnemonic_Add")); // NOI18N
        fd.setValue("mnemonic_Remove", bundle.getString("CTL_Parameters_Mnemonic_Remove")); // NOI18N
        fd.setValue("mnemonic_Up", bundle.getString("CTL_Parameters_Mnemonic_Up")); // NOI18N
        fd.setValue("mnemonic_Down", bundle.getString("CTL_Parameters_Mnemonic_Down")); // NOI18N
        fd.setValue("mnemonic_Edit", bundle.getString("CTL_Parameters_Mnemonic_Edit")); // NOI18N
        paramsPanel.add(paramsEditor, gridBagConstraints);
        
        // exceptions
        PropertyPanel exceptionsEditor = new PropertyPanel(
                ElementNode.createExceptionsProperty(element, true),
                PropertyPanel.PREF_CUSTOM_EDITOR
        );
        fd = exceptionsEditor.getProperty();
        fd.setValue("mnemonic_Add", bundle.getString("CTL_Exceptions_Mnemonic_Add"));
        fd.setValue("mnemonic_Remove", bundle.getString("CTL_Exceptions_Mnemonic_Remove"));
        fd.setValue("mnemonic_Up", bundle.getString("CTL_Exceptions_Mnemonic_Up"));
        fd.setValue("mnemonic_Down", bundle.getString("CTL_Exceptions_Mnemonic_Down"));
        fd.setValue("mnemonic_Edit", bundle.getString("CTL_Exceptions_Mnemonic_Edit"));
        exceptionsPanel.add(exceptionsEditor, gridBagConstraints);

        // HelpCtx.setHelpIDString (this, "java.method.customizer"); // NOI18N
        //mnemonics
        jLabel1.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0)); // NOI18N
        returnLabel.setDisplayedMnemonic(bundle.getString("CTL_MethodType_Mnemonic").charAt(0));  // NOI18N

        ((JTextComponent)returnTypeComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                checkReturnType();
            }
            public void insertUpdate(DocumentEvent e) {
                checkReturnType();
            }
            public void removeUpdate(DocumentEvent e) {
                checkReturnType();
            }
        });
        
        initAccessibility();
    }
    
    public void setEjbQL(String ql) {
        ejbQlText.setText(ql);
    }
    
    public String getEjbQL() {
        return ejbQlText.getText();
    }
    
    public boolean publishToRemote() {
        return remoteCheckbox.isSelected();
    }
    
    public void setPublishToRemote(boolean publish) {
        remoteCheckbox.setSelected(publish);
    }
    
    public boolean publishToLocal() {
        return localCheckbox.isSelected();
    }
    
    public void setPublishToLocal(boolean publish) {
        localCheckbox.setSelected(publish);
    }
    
    public boolean finderReturnIsSingle() {
        return oneRadioButton.isSelected();
    }
    
    public void setFinderCardinality(boolean many) {
        if (many) {
            manyRadioButton.setSelected(true);
        } else {
            oneRadioButton.setSelected(true);
        }
    }
    
    void hideEJBQL() {
        ejbQlScrollBar.setVisible(false);
    }
    
    void hideExceptions() {
        exceptionAndParameterPanel.remove(exceptionsPanel);
    }
    
    void hideFinderReturn() {
        finderCardinalityPanel.setVisible(false);
    }
    
    void hideInterfaceSelection() {
        interfacePanel.setVisible(false);
    }
    
    void setAvailableInterface(boolean local, boolean remote) {
        remoteCheckbox.setEnabled(remote);
        remoteCheckbox.setSelected(remote);
        localCheckbox.setEnabled(local);
        localCheckbox.setSelected(local);
    }
    
    void setSelectedInterface(boolean local, boolean remote) {
        remoteCheckbox.setSelected(remote);
        localCheckbox.setSelected(local);
    }
    
    void hideReturn() {
        returnTypeComboBox.setVisible(false);
        browseFQNButton.setVisible(false);
        returnLabel.setVisible(false);
    }
    
    public void addNotify() {
        super.addNotify();
        
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                nameTextField.requestFocus();
            }
        });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        finderReturnGroup = new javax.swing.ButtonGroup();
        methodPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        returnLabel = new javax.swing.JLabel();
        browseFQNButton = new javax.swing.JButton();
        returnTypeComboBox = new JComboBox(COMMON_TYPES);
        exceptionAndParameterPanel = new javax.swing.JTabbedPane();
        paramsPanel = new javax.swing.JPanel();
        exceptionsPanel = new javax.swing.JPanel();
        interfacePanel = new javax.swing.JPanel();
        remoteCheckbox = new javax.swing.JCheckBox();
        localCheckbox = new javax.swing.JCheckBox();
        finderCardinalityPanel = new javax.swing.JPanel();
        oneRadioButton = new javax.swing.JRadioButton();
        manyRadioButton = new javax.swing.JRadioButton();
        ejbQlScrollBar = new javax.swing.JScrollPane();
        ejbQlText = new javax.swing.JTextArea();
        errorField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(6, 6, 6, 6));
        methodPanel.setLayout(new java.awt.GridBagLayout());

        jLabel1.setLabelFor(nameTextField);
        jLabel1.setText(NbBundle.getMessage(MethodCustomizer.class, "CTL_Name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 8, 8);
        methodPanel.add(jLabel1, gridBagConstraints);

        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                nameTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 8, 8);
        methodPanel.add(nameTextField, gridBagConstraints);

        returnLabel.setLabelFor(returnTypeComboBox);
        returnLabel.setText(NbBundle.getMessage(MethodCustomizer.class, "CTL_ReturnType"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 8);
        methodPanel.add(returnLabel, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(browseFQNButton, org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "LBL_Browse"));
        browseFQNButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseFQNButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 8);
        methodPanel.add(browseFQNButton, gridBagConstraints);

        returnTypeComboBox.setEditable(true);
        returnTypeComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                returnTypeComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 8);
        methodPanel.add(returnTypeComboBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(methodPanel, gridBagConstraints);

        paramsPanel.setLayout(new java.awt.GridBagLayout());

        exceptionAndParameterPanel.addTab(NbBundle.getMessage(MethodCustomizer.class, "CTL_Parameters"), paramsPanel);

        exceptionsPanel.setLayout(new java.awt.GridBagLayout());

        exceptionAndParameterPanel.addTab(NbBundle.getMessage(MethodCustomizer.class, "CTL_Exceptions"), exceptionsPanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 0);
        add(exceptionAndParameterPanel, gridBagConstraints);
        exceptionAndParameterPanel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "ACSN_Method_Declaration"));
        exceptionAndParameterPanel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "ACSD_Method_Declaration"));

        interfacePanel.setLayout(new java.awt.GridLayout(1, 2, 8, 8));

        interfacePanel.setBorder(javax.swing.BorderFactory.createTitledBorder(NbBundle.getMessage(MethodCustomizer.class, "CTL_UseInInterface")));
        remoteCheckbox.setMnemonic(NbBundle.getMessage(MethodCustomizer.class, "CTL_Remote_Mnemonic").charAt(0));
        remoteCheckbox.setText(NbBundle.getMessage(MethodCustomizer.class, "CTL_Remote"));
        remoteCheckbox.setToolTipText(org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "ACSD_REMOTE"));
        interfacePanel.add(remoteCheckbox);

        localCheckbox.setMnemonic(NbBundle.getMessage(MethodCustomizer.class, "CTL_Local_Mnemonic").charAt(0));
        localCheckbox.setText(NbBundle.getMessage(MethodCustomizer.class, "CTL_Local"));
        localCheckbox.setToolTipText(org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "ACSD_LOCAL"));
        interfacePanel.add(localCheckbox);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 8, 0);
        add(interfacePanel, gridBagConstraints);

        finderCardinalityPanel.setLayout(new java.awt.GridLayout(1, 0));

        finderCardinalityPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(NbBundle.getMessage(MethodCustomizer.class, "CTL_ReturnCardinality")));
        finderReturnGroup.add(oneRadioButton);
        oneRadioButton.setMnemonic(NbBundle.getMessage(MethodCustomizer.class, "CTL_One_Mnemonic").charAt(0));
        oneRadioButton.setText(NbBundle.getMessage(MethodCustomizer.class, "CTL_One"));
        finderCardinalityPanel.add(oneRadioButton);

        finderReturnGroup.add(manyRadioButton);
        manyRadioButton.setMnemonic(NbBundle.getMessage(MethodCustomizer.class, "CTL_Many_Mneumonic").charAt(0));
        manyRadioButton.setSelected(true);
        manyRadioButton.setText(NbBundle.getMessage(MethodCustomizer.class, "CTL_Many"));
        finderCardinalityPanel.add(manyRadioButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 8, 0);
        add(finderCardinalityPanel, gridBagConstraints);

        ejbQlScrollBar.setBorder(javax.swing.BorderFactory.createTitledBorder(NbBundle.getMessage(MethodCustomizer.class, "CTL_EJBQL")));
        ejbQlScrollBar.setMinimumSize(new java.awt.Dimension(32, 112));
        ejbQlScrollBar.setPreferredSize(new java.awt.Dimension(32, 112));
        ejbQlText.setRows(3);
        ejbQlText.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        ejbQlScrollBar.setViewportView(ejbQlText);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 8);
        add(ejbQlScrollBar, gridBagConstraints);

        errorField.setBackground(getBackground());
        errorField.setEditable(false);
        errorField.setBorder(null);
        errorField.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 0);
        add(errorField, gridBagConstraints);

        jLabel2.setLabelFor(exceptionAndParameterPanel);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/common/ui/nodes/Bundle").getString("LBL_TypesAndExceptions"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 3, 6, 0);
        add(jLabel2, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void returnTypeComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_returnTypeComboBoxActionPerformed
        if (method == null)
            return;
        
        Type oldValue = method.getType();
        boolean ok = false;
        String returnTypeText = ((JTextComponent)returnTypeComboBox.getEditor().getEditorComponent()).getText();
        if (returnTypeText!=null && !returnTypeText.equals("")) {
            try {
                final Type newValue = JMIUtils.resolveType(returnTypeText);
                if (oldValue == null || !oldValue.equals(newValue)) {
                    method.setType(newValue);
                    ok = true;
                } else
                    return;

            } catch (IllegalArgumentException e) {
                ErrorManager.getDefault().annotate(
                        e, ErrorManager.USER, null,
                        NbBundle.getMessage(MethodCustomizer.class, "MSG_Not_Valid_Type"),
                        null, null);
                ErrorManager.getDefault().notify(e);
            }
        }
        isOK = ok;
    }//GEN-LAST:event_returnTypeComboBoxActionPerformed

    private void browseFQNButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseFQNButtonActionPerformed
        SwingUtilities.invokeLater (new Runnable() {
            public void run() {
                FQNSearch.showFastOpen((JTextComponent) returnTypeComboBox.getEditor().getEditorComponent());
            }
        });
    }//GEN-LAST:event_browseFQNButtonActionPerformed
    
    private void nameTextFieldFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nameTextFieldFocusLost
       if ((evt != null && evt.isTemporary()) || (method == null))
           return;

       String newName = nameTextField.getText();
       boolean ok = false;
       if (Utilities.isJavaIdentifier(newName)) {
           if (!methodName.equals(newName)) {
               method.setName(newName);
               methodName = newName;
               ok = true;
           } else
               return;
       }
       isOK = ok;
    }//GEN-LAST:event_nameTextFieldFocusLost
                       
                       
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseFQNButton;
    private javax.swing.JScrollPane ejbQlScrollBar;
    private javax.swing.JTextArea ejbQlText;
    private javax.swing.JTextField errorField;
    private javax.swing.JTabbedPane exceptionAndParameterPanel;
    private javax.swing.JPanel exceptionsPanel;
    private javax.swing.JPanel finderCardinalityPanel;
    private javax.swing.ButtonGroup finderReturnGroup;
    private javax.swing.JPanel interfacePanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JCheckBox localCheckbox;
    private javax.swing.JRadioButton manyRadioButton;
    private javax.swing.JPanel methodPanel;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JRadioButton oneRadioButton;
    private javax.swing.JPanel paramsPanel;
    private javax.swing.JCheckBox remoteCheckbox;
    private javax.swing.JLabel returnLabel;
    private javax.swing.JComboBox returnTypeComboBox;
    // End of variables declaration//GEN-END:variables
    
    private void initAccessibility() {
        nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MethodCustomizer.class, "ACS_MethodNameTextField"));
        nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizer.class, "ACS_MethodNameTextField"));
        browseFQNButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizer.class, "ACSD_BrowseFQN"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_MethodCustomizerDialog");
    }
    
    public boolean isOK() {
        if (!isInitialized) {
            return false;
        }
        nameTextFieldFocusLost(null);
        returnTypeComboBoxActionPerformed(null);
	handleChangeAndNotify(nameTextField.getDocument());
        return isOK;
    }
    
    /** Finds property descriptor for a bean.
     * @param bean the bean
     * @param name name of the property to find
     * @return the descriptor
     * @exception IllegalArgumentException if the method is not found
     */
    private static PropertyDescriptor findInfo(Object bean, String name)
    throws IllegalArgumentException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] descr = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descr.length; i++) {
                if (descr[i].getName().equals(name)) {
                    return descr[i];
                }
            }
            throw new IllegalArgumentException(
                    "No property named " + name + " in class " + bean.getClass() // NOI18N
                    );
        } catch (IntrospectionException e) {
            IllegalArgumentException iae =  new IllegalArgumentException();
            iae.initCause(e);
            throw iae;
        }
    }

    // <editor-fold desc="Validation of customized method">
    
    /**
     * Enables regex-based validation for method name text field.
     * Also selects all letters after prefix.
     * @param prefix Prefix to be used for method name. If null then it is converted to empty String.
     * @param errorMessage Error message to display, if name of method doesn's match expression
     */
    public void enablePrefixForName(String prefix, String errorMessage) {
        if (methodNameListener == null) {
            methodNameListener = new MethodNameListener();
            nameTextField.getDocument().addDocumentListener(methodNameListener);
        }
        if (prefix == null) {
            prefix = "";
        }
        if (patternStr == null) {
            patternStr = ""; //NOI18N
        }
        patternStr = prefix.equals("") ? "\\w+" : prefix + "\\w*"; // at least one of [a-zA-Z_0-9]
        this.patternStr = patternStr;
        this.regexErrorMessage = errorMessage;
        nameTextField.setText(generateUniqueName(nameTextField.getText()));
        nameTextField.setCaretPosition(prefix.length());
        nameTextField.moveCaretPosition(nameTextField.getText().length());
    }
    
    /**
     * Enables validation of method signature to avoid inserting of already defined method.
     * @param existingMethods methods already defined in edited class
     * @param errorMessage error message to display if method already exists
     */
    public void enableCheckForSignature(Method[] existingMethods, String errorMessage) {
        ((MDRChangeSource) method).addListener(new MDRChangeListener() {
            public void change(org.netbeans.api.mdr.events.MDRChangeEvent e) {
                // TODO: listeners - is this handling OK?
                if (e instanceof AttributeEvent) {
                    if (((AttributeEvent) e).getAttributeName().equals("parameters")) {
                        handleChangeAndNotify(nameTextField.getDocument());
                    }
                }
            }
        });
        if (existingMethods == null) {
            existingMethods = new Method[0];
        }
        this.existingMethods = existingMethods;
        this.existingNameErrorMessage = errorMessage;
    }
    
    
    // private stuff ==========================================================
    
    private String patternStr;
    private String regexErrorMessage;
    private Method[] existingMethods;
    private String existingNameErrorMessage;

    private boolean checkReturnType() {
        String typeName = ((JTextComponent) returnTypeComboBox.getEditor().getEditorComponent()).getText();
        if (!isValidTypeName(typeName)) {
            firePropertyChange(OK_ENABLED, true, false);
            return false;
        } else {
            firePropertyChange(OK_ENABLED, false, true);
            return true;
        }
    }

    private static boolean isValidTypeName(String str) {
        while (str.endsWith("[]")) {
            str = str.substring(0, str.length() - 2);
        }
        String[] identifiers = str.split("\\.");
        for (int i = 0; i < identifiers.length; i++) {
            if (!isJavaIdentifier(identifiers[i])) {
                return false;
            }
        }
        return true;
    }
    
    private static final boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        if (id.equals("")) {
            return false;
        }
        if (!(java.lang.Character.isJavaIdentifierStart(id.charAt(0)))) {
            return false;
        }
        for (int i = 1; i < id.length(); i++) {
            if (!(java.lang.Character.isJavaIdentifierPart(id.charAt(i)))) {
                return false;
            }
        }
        return true;
    }

    /**
     * Simple regex compare
     * @param patternStr Pattern to match
     * @param input Input for validation
     * @return true if input matches regular expression, false otherwise
     */
    private static boolean matchesRegex(String patternStr, String input) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    /**
     * Generates new name, if method with same signature exists
     * @param name name of customized method, which will be checked
     * @return String appended with generated number (1..n)
     */
    private String generateUniqueName(String name) {
        int uniquifier = 1;
        String newName = name;
        while (!handleChange(newName) && Utilities.isJavaIdentifier(newName)) {
            newName = name + String.valueOf(uniquifier++);
        }
        return newName;
    }

    /**
     * Checks if method with same signature as customized one already exists
     * @param name name of customized method
     * @return true if such method exists, false otherwise
     */
    private boolean methodExists(String name) {
        if (existingMethods == null) {
            return false;
        }
        for (int i = 0; i < existingMethods.length; i++) {
            Method existingMethod = existingMethods[i];
            String existingName = existingMethod.getName();
            if (existingName.equals(name) && JMIUtils.signaturesEqual(existingMethod, method)) {
                return true;
            } 
        }
        return false;
    }
    
    /**
     * Checks if current state of customized method is valid (if method with such 
     * signature exists, if matches regex), sets error label appropriate to problem
     * @param editedName name of customized method
     * @return true if method can be added to class, false otherwise
     */
    private boolean handleChange(String editedName) {
        if (!Utilities.isJavaIdentifier(editedName)) {
            errorField.setText(NbBundle.getMessage(MethodCustomizer.class, "MSG_Not_Valid_Identifier"));
            return false;
        }
        boolean result = false;
        boolean matches = matchesRegex(patternStr, editedName);
        if (!matches) {
            errorField.setText(regexErrorMessage);
        } else {
            if (methodExists(editedName)) {
                errorField.setText(existingNameErrorMessage);
            } else {
                errorField.setText("");
                result = true;
            }
        }
        return result;
    }

    /**
     * Calls handle change and fires appropriate property change
     * @param document controlled document
     */
    private void handleChangeAndNotify(Document document) {
	if (waitingScanFinished) {
	    firePropertyChange(OK_ENABLED, true, false);
	    return;
	}
	if (JavaMetamodel.getManager().isScanInProgress()) {
	    waitingScanFinished = true;
	    RequestProcessor.getDefault().post(new Runnable() {
		public void run() {
		    JavaMetamodel.getManager().waitScanFinished();
		    waitingScanFinished = false;
		    handleChangeAndNotify(nameTextField.getDocument());
		}
	    });
	    firePropertyChange(OK_ENABLED, true, false);
	    if (errorField != null) {
		errorField.setText(NbBundle.getMessage(MethodCustomizer.class, "LBL_ScanningInProgress"));
		return;
	    }
	}
        try {
            if (!checkReturnType()) {
                return;
            }
            boolean isValid = handleChange(document.getText(0, document.getLength()));
            if (isValid) {
                firePropertyChange(OK_ENABLED, false, true);
            } else {
                firePropertyChange(OK_ENABLED, true, false);
            }
        } catch (BadLocationException ble) {
            assert false : ble.getMessage();
        }
    }
    
    private class MethodNameListener implements DocumentListener {

        public void insertUpdate(DocumentEvent e) {
            handleChangeAndNotify(e.getDocument());
        }
        
        public void removeUpdate(DocumentEvent e) {
            handleChangeAndNotify(e.getDocument());
        }
        
        public void changedUpdate(DocumentEvent e) {
            handleChangeAndNotify(e.getDocument());
        }
        
    }
    
    // </editor-fold>

    public JCheckBox getLocalCheckbox() {
        return localCheckbox;
    }

    public JCheckBox getRemoteCheckbox() {
        return remoteCheckbox;
    }

    public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        isOK();
    }

    public void addPropertyChangeListener(String propertyName, java.beans.PropertyChangeListener listener) {
        super.addPropertyChangeListener(propertyName, listener);
        isOK();
    }

}
