/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.common.ui.nodes;

import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.openide.nodes.Node;
import org.openide.nodes.Children;
import java.util.Collections;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.SwingUtilities;


public abstract class ComponentMethodModel extends Children.Keys implements MDRChangeListener {
    private Collection interfaces;
    private JavaClass implBean;
    
    public ComponentMethodModel(JavaClass implBean, Collection interfaces) {
        this.implBean = implBean;
        this.interfaces = interfaces;
    }
    
    public ComponentMethodModel(){}
        
    private void updateKeys() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                List keys = new ArrayList();
                Iterator iterator = getInterfaces().iterator();
                while(iterator.hasNext()){
                    JavaClass intf = (JavaClass)iterator.next();
                    if (intf != null) {
                        Method[] methods = JMIUtils.getMethods(intf);
                        for(int i = 0; i < methods.length; i++){
                            keys.add(methods[i]);
                        }
                    }
                }
                setKeys(keys);
            }
        });
    }
    
    protected void addNotify() {
        if(interfaces == null){
            interfaces = getInterfaces();
        }
        assert(interfaces != null);
        if(implBean == null){
            implBean = getImplBean();
        }
        super.addNotify();
        registerListeners();
        updateKeys();
    }
    
    private void registerListeners() {
        Iterator iterator = interfaces.iterator();
        while(iterator.hasNext()){
            JavaClass intf = (JavaClass)iterator.next();
            if (intf != null) {
                ((MDRChangeSource) intf).addListener(this);  
            }
        }
    }
    
    private void removeListeners() {
        if (interfaces == null)
            return;
        Iterator iterator = interfaces.iterator();
        while(iterator.hasNext()){
            JavaClass intf = (JavaClass)iterator.next();
            ((MDRChangeSource) intf).removeListener(this);  
        }
    }
    
    protected void removeNotify() {
        if (interfaces == null)
            return;
        setKeys(Collections.EMPTY_SET);
        removeListeners();
        super.removeNotify();
    }
    
    /*
     * Subclasses have to override this if no-arg constructor is used
     */
    protected Collection getInterfaces(){
        return null;
    }
    
    /*
     * Subclasses have to override this if no-arg constructor is used
     */
    protected JavaClass getImplBean(){
       return null; 
    }

    public void change(MDRChangeEvent evt) {
        // TODO: how to make following old code working?
//        if (ElementProperties.PROP_VALID.equals(evt.getPropertyName())) {
//            Object value = evt.getNewValue();
//            if ((value instanceof Boolean) && !((Boolean) value).booleanValue()) {
//                removeListeners();
//                interfaces = getInterfaces();
//                registerListeners();
//            }
//        }
        updateKeys();
    }
    
    public abstract ComponentMethodViewStrategy  createViewStrategy();
    
    protected Node[] createNodes(Object key) {
        if(key instanceof Method) {
            Method method = (Method)key;
            ComponentMethodViewStrategy cmvs = createViewStrategy();
            return new Node[] {new MethodNode(method, implBean, getInterfaces(), cmvs)};
        }
        return new Node[0];
    }

}
