/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.j2ee.common.ui.nodes.MethodCollectorFactory;
import org.netbeans.modules.j2ee.common.ui.nodes.MethodCustomizer;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 * Usefull methods for JMI operations related to Web Services
 *
 * @author Milan Kuchtiak
 */
public class WSUtils {
    
    /** Creates WS operation with a defaut name in WS operation dialog
     */ 
    public static Method addWsOperation(JavaClass javaClass) {
        return addWsOperation(javaClass, NbBundle.getMessage(WSUtils.class, "TXT_DefaultOperationName"));
    }
    /** Creates WS Operation with an operationName in WS operation dialog
     */
    public static Method addWsOperation(JavaClass javaClass, String operationName) {
        Method m=null;
        if ((javaClass != null) && (javaClass.isValid())) {
            JMIUtils.beginJmiTransaction();
            try {
                m = JMIUtils.createMethod(javaClass);
                m.setModifiers(Modifier.PUBLIC);
                m.setName(operationName); //NOI18N
                // sets 'String' as a default return value for method. 
                // method.setType(type) can't be used here since it would set 
                // return value to 'java.lang.String' (#61178)
                TypeReference tr = 
                        ((JavaModelPackage)javaClass.refImmediatePackage()).getMultipartId().createMultipartId("String", null, null); //NOI18N
                m.setTypeName(tr);
                
            } catch (JmiException e) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, e.toString());
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, e.getElementInError().toString());
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, e.getObjectInError().toString());
            } finally {
                JMIUtils.endJmiTransaction();
            }
            if (m == null) {
                return null;
            }

            MethodCustomizer mc = MethodCollectorFactory.operationCollector(m);
            final NotifyDescriptor nd = new NotifyDescriptor(mc, NbBundle.getMessage(WSUtils.class, "TTL_AddOperation"),
                    NotifyDescriptor.OK_CANCEL_OPTION,
                    NotifyDescriptor.PLAIN_MESSAGE,
                    null, null
                    );
            mc.addPropertyChangeListener(new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals(MethodCustomizer.OK_ENABLED)) {
                        Object newvalue = evt.getNewValue();
                        if ((newvalue != null) && (newvalue instanceof Boolean)) {
                            nd.setValid(((Boolean)newvalue).booleanValue());
                        }
                    }
                }
            });
            Object rv = DialogDisplayer.getDefault().notify(nd);
            mc.isOK(); // apply possible changes in dialog fields
            if (rv == NotifyDescriptor.OK_OPTION) {
                boolean rollback=true;
                JMIUtils.beginJmiTransaction(true);
                try {
                    m.setJavadocText(NbBundle.getMessage(WSUtils.class, "TXT_WSOperation"));
                    String body = NbBundle.getMessage(WSUtils.class, "TXT_VoidOperation");

                    Type returnType = m.getType();
                    boolean voidType = true;
                    if (!((returnType instanceof PrimitiveType) && ((PrimitiveType) returnType).getKind().equals(PrimitiveTypeKindEnum.VOID))) {
                        voidType=false;
                        String retString = getImplicitValue(m.getType());
                        if (retString != null) {
                            body += "return " + retString + ";"; //NOI18N
                        }
                    }

                    if (javaClass != null) {
                        javaClass.getContents().add(m);

                        // #61178
                        JMIUtils.fixImports(javaClass);
                        //JMIUtils.fixImports(seiClass);

                        m.setBodyText(body);

                        // add javax.jws.WebMethod annotation
                        m.getAnnotations().add(JMIGenerationUtil.createAnnotation(javaClass,"javax.jws.WebMethod",new ArrayList())); //NOI18N
                        if (voidType && m.getExceptionNames().size()==0) m.getAnnotations().add(JMIGenerationUtil.createAnnotation(javaClass,"javax.jws.Oneway",new ArrayList())); //NOI18N
                        List parameters = m.getParameters();
                        for (int i=0;i<parameters.size();i++) {
                            Parameter param = (Parameter)parameters.get(i);
                            String paramName = param.getName();
                            List attrValues = new ArrayList();
                            attrValues.add(JMIGenerationUtil.createAttributeValue(javaClass,"name",paramName));
                            param.getAnnotations().add(JMIGenerationUtil.createAnnotation(javaClass,"javax.jws.WebParam",attrValues)); //NOI18N
                        } 
                        rollback = false;
                    }
                } catch (Exception e) {
                    ErrorManager.getDefault().notify(e);
                } finally {
                    JMIUtils.endJmiTransaction(rollback);
                }
            } else {
                m.refDelete();
                m=null;
            }
        }
        return m;
    }
    
    private static String getImplicitValue(Type t) {
        // TODO - should enhance to enum types, annotation types
        String ret = "return "; //NOI18N
        
        if (t instanceof PrimitiveType) {
            
            if (((PrimitiveType)t).getKind().equals(PrimitiveTypeKindEnum.BOOLEAN)) {
                return "false"; //NOI18N
            }
            if (((PrimitiveType)t).getKind().equals(PrimitiveTypeKindEnum.CHAR)) {
                return "''"; //NOI18N
            }
            return "0"; //NOI18N
            
        } else if (t instanceof JavaClass) {
            return "null"; //NOI18N
            
        } else if (t instanceof Array) {
            return "new " + t.getName() + " { }"; //NOI18N
        }
        
        return null;
    }
}
