/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.common;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.ext.java.JavaFastOpen;
import org.netbeans.editor.ext.java.JavaSettingsNames;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
/**
 * This is customized NbJavaJMIFastOpen
 * @author Martin Adamek
 */
public class FQNSearch extends JavaFastOpen {
    
    private JTextComponent textComponent;
    private JavaClass parent;
    
    private FQNSearch(JTextComponent textComponent) {
        this.textComponent = textComponent;
    }
    
    private FQNSearch(JTextComponent textComponent, JavaClass parent) {
        this.textComponent = textComponent;
        this.parent = parent;
    }

    protected List findClasses(String exp, boolean caseSensitive, boolean includeInnerClasses, boolean includeLibraryClasses) {
        return findAllClasses(exp, true, caseSensitive, includeInnerClasses, includeLibraryClasses, parent);
    }

    public static void showFastOpen(JTextComponent textComponent) {
        String initSearchText = textComponent.getText();
        if (!org.openide.util.Utilities.isJavaIdentifier(initSearchText)) {
            initSearchText = null;
        }
        if (fastOpen == null) {
            fastOpen = new FQNSearch(textComponent);
        }
        if (initSearchText != null) {
            fastOpen.setSearchText(initSearchText);
        }
        fastOpen.setDialogVisible(true);
    }

    // this is too slow
//    public static void showFastOpen(JTextComponent textComponent, JavaClass parent) {
//        // set class or class fragment from current cursor position
//        // Issue#: 10639
//        Node[] arr = TopComponent.getRegistry ().getActivatedNodes ();
//        String initSearchText = null;
//        if (arr.length > 0) {
//            EditorCookie ec = (EditorCookie) arr[0].getCookie (EditorCookie.class);
//            if (ec != null) {
//                JEditorPane[] openedPanes = ec.getOpenedPanes ();
//                if (openedPanes != null) {
//                    initSearchText = Utilities.getSelectionOrIdentifier(openedPanes [0]);
//                    if (!org.openide.util.Utilities.isJavaIdentifier(initSearchText))
//                        initSearchText = null;
//                }
//            }
//        }
//        if (fastOpen == null) {
//            fastOpen = new FQNSearch(textComponent, parent);
//        }
//        if (initSearchText != null) {
//            fastOpen.setSearchText(initSearchText);
//        }
//        fastOpen.setDialogVisible(true);
//    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == getButtons()[0] || src == getPanel() ) { // Open
            setCaseSensitive(caseSensitive);
            setIncludeInnerClasses(includeInnerClasses);
            setIncludeLibraryClasses(includeLibraryClasses);
            setDialogVisible(false);
            final int selIndex = getResultList().getSelectedIndex();
            if (selIndex >= 0) {
                RequestProcessor.getDefault().post(new Runnable() {
                    public void run() {
                        Object item = getResultList().getModel().getElementAt(selIndex);
                        final JavaClass cls = item instanceof ResultItemImpl ? (JavaClass)((ResultItemImpl)item).getAssociatedObject() : null;
                        if (cls != null) {
                            // run in the AWT event dispatch thread
                            Mutex.EVENT.writeAccess(new Runnable() {
                                public void run() {
                                    textComponent.setText(cls.getName());
                                }
                            });
                        }
                    }
                });
            }
        } else {
            super.actionPerformed(evt);
        }
    }

    protected Class getKitClass() {
        return JavaKit.class;
    }

    protected void setCaseSensitive(boolean caseSensitive) {
        Class kitClass = getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions(kitClass);
            bop.setSettingValue(JavaSettingsNames.GOTO_CLASS_CASE_SENSITIVE, caseSensitive ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void setIncludeInnerClasses(boolean includeInnerClasses) {
        Class kitClass = getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions(kitClass);
            bop.setSettingValue(JavaSettingsNames.GOTO_CLASS_SHOW_INNER_CLASSES, includeInnerClasses ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void setIncludeLibraryClasses(boolean includeLibraryClasses) {
        Class kitClass = getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions(kitClass);
            bop.setSettingValue(JavaSettingsNames.GOTO_CLASS_SHOW_LIBRARY_CLASSES, includeLibraryClasses ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private static List findAllClasses(String exp, boolean createResultItems, boolean caseSensitive, boolean findInnerClasses, boolean findLibraryClasses, JavaClass parent) {
        List ret = new ArrayList();
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            List cpRoots = Arrays.asList(JavaMetamodel.getManager().getClassPath().getRoots());
            List classes = new ArrayList();
            for (Iterator it = cpRoots.iterator(); it.hasNext();) {
                FileObject cpRoot = (FileObject)it.next();
                if (findLibraryClasses || FileOwnerQuery.getOwner(cpRoot) != null) {
                    ClassIndex ci = ClassIndex.getIndex(JavaModel.getJavaExtent(cpRoot));
                    if (ci != null)
                        classes.addAll(ci.getClassesBySNPrefix(exp, caseSensitive));
                }
            }
            if (!createResultItems)
                return classes;
            for (Iterator it = classes.iterator(); it.hasNext();) {
                JavaClass cls = (JavaClass)it.next();
                if (findInnerClasses || !cls.isInner()) {
                    if (parent == null || (parent != null && cls.isSubTypeOf(parent))) {
                        ret.add(new ResultItemImpl(cls, true, false, false));
                    }
                }
            }
            Collections.sort(ret, JMIUtils.getNaturalMemberNameComparator());
        } finally {
            JavaModel.getJavaRepository().endTrans();
        }
        return ret;
    }

    protected Dialog createDialog() {
        String title = NbBundle.getMessage(FQNSearch.class, "LBL_FQN_Title");
        getButtons()[0].setText(NbBundle.getMessage(FQNSearch.class, "LBL_FQN_OK")); // NOI18N

        Dialog dialog = DialogSupport.createDialog(title,
            getPanel(), true, getButtons(), false, 0, 1, this);
        dialog.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                FQNSearch.this.setDialogVisible(false);
            }
            
            public void windowClosed(WindowEvent evt) {
            }
        });        

        return dialog;
    }

    private static class ResultItemImpl extends NbJMIResultItem.ClassResultItem {
        
        private JavaClass cls;
        
        public ResultItemImpl(JavaClass cls, boolean displayFQN, boolean addImport, boolean generateClassSkeleton){
            super(cls, displayFQN, addImport, generateClassSkeleton);
            this.cls = cls;
        }

        protected Object getAssociatedObject() {
            return cls;
        }
    }
    
}
