/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.wizard;

import org.netbeans.api.project.Project;
import org.netbeans.jellytools.NewFileNameLocationStepOperator;
import org.netbeans.jellytools.NewFileWizardOperator;
import org.netbeans.jellytools.NewProjectNameLocationStepOperator;
import org.netbeans.jellytools.NewProjectWizardOperator;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.operators.JComboBoxOperator;

/**
 *
 * @author jungi
 */
public class WizardUtils {
    
    public static final int MODULE_WAR = 0;
    public static final int MODULE_EJB = 1;
    public static final int MODULE_EAR = 2;
    public static final int MODULE_CAR = 3;
    
    public static final int VERSION_1_4 = 0;
    public static final int VERSION_5 = 1;
    
    /** Creates a new instance of WizardUtils */
    private WizardUtils() {
    }
    
    public static NewProjectWizardOperator createNewProject(String category,
            String project) {
        NewProjectWizardOperator npwo = NewProjectWizardOperator.invoke();
        npwo.selectCategory(category);
        npwo.selectProject(project);
        npwo.next();
        return npwo;
    }
    
    public static NewProjectNameLocationStepOperator setProjectNameLocation(
            String name, String location) {
        NewProjectNameLocationStepOperator op = new NewProjectNameLocationStepOperator();
        op.txtProjectName().setText(name);
        op.txtProjectLocation().setText(location);
        return op;
    }
    
    public static NewFileWizardOperator createNewFile(Project p,
            String category, String filetype) {
        NewFileWizardOperator nfwo = NewFileWizardOperator.invoke();
        new EventTool().waitNoEvent(500);
        nfwo.cboProject().selectItem(p.toString());
        nfwo.selectCategory(category);
        nfwo.selectFileType(filetype);
        nfwo.next();
        return nfwo;
    }
    
    public static NewFileNameLocationStepOperator setFileNameLocation(String name,
            String pkg, String srcRoot) {
        NewFileNameLocationStepOperator op = new NewFileNameLocationStepOperator();
        new EventTool().waitNoEvent(500);
        op.setObjectName(name);
        new EventTool().waitNoEvent(1000);
        JComboBoxOperator jcbo = null;
        if (srcRoot != null) {
            jcbo = new JComboBoxOperator(op, 0);
            jcbo.selectItem(srcRoot);
        }
        new EventTool().waitNoEvent(1000);
        jcbo = new JComboBoxOperator(op, 1);
        jcbo.clearText();
        jcbo.typeText(pkg);
        return op;
    }
    
    public static NewProjectNameLocationStepOperator setJ2eeSpecVersion(
            NewProjectNameLocationStepOperator op, int moduleType, String version) {
        JComboBoxOperator jcbo = null;
            switch (moduleType) {
                case MODULE_WAR: jcbo = new JComboBoxOperator(op, 3); break;
                case MODULE_EJB: jcbo = new JComboBoxOperator(op, 0); break;
                case MODULE_EAR: jcbo = new JComboBoxOperator(op, 1); break;
                case MODULE_CAR: jcbo = new JComboBoxOperator(op, 2); break;
                default: throw new IllegalArgumentException("Invalid module type");
            }
        boolean found = false;
        int i = 0;
        for (; i < jcbo.getItemCount(); i++) {
            Object o = jcbo.getItemAt(i);
            if (o.toString().indexOf(version) > 0) {
                found = true;
                break;
            }
        }
        if (found) {
            jcbo.selectItem(i);
        } else {
            throw new IllegalArgumentException("Version: '" + version + "' was not found.");
        }
        return op;
    }

}
