/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.wizard;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.netbeans.api.project.Project;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NewFileNameLocationStepOperator;
import org.netbeans.jellytools.NewFileWizardOperator;
import org.netbeans.jellytools.OutputOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.j2ee.lib.ContentComparator;
import org.netbeans.test.j2ee.lib.FilteringLineDiff;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.lib.Reporter;
import org.netbeans.test.j2ee.lib.Ejb;
import org.netbeans.test.j2ee.lib.Utils;
import org.netbeans.test.j2ee.lib.WebSvc;

/**
 * Test New File wizards in J2EE area. These tests are
 * part of J2EE Functional test suite.
 * In each test is checked if all classes are created
 * and if deployment descriptors are changed accordingly.
 *
 * @author jungi
 * @see <a href="http://qa.netbeans.org/j2ee/promo-f/testspec/j2ee-wizards-testspec.html">J2EE Wizards Test Specification</a>
 */
public class NewFileWizardsTest extends JellyTestCase {
    
    private static boolean CREATE_GOLDEN_FILES = Boolean.getBoolean("org.netbeans.test.j2ee.wizard.golden");
//    private static boolean CREATE_GOLDEN_FILES = true;
    
    private static final String DEF_EJB_MOD =
            "../../org.netbeans.test.j2ee.wizard.NewProjectWizardsTest/" +
            "testDefaultNewEJBModWizard/def EJB Mod";
    private static final String DEF_WEB_MOD =
            "../../org.netbeans.test.j2ee.wizard.NewProjectWizardsTest/" +
            "testDefaultNewWebModWizard/def Web app";
    private static final String BAD_EJB_MOD =
            "../../org.netbeans.test.j2ee.wizard.NewProjectWizardsTest/" +
            "testNewEJBModWizard/BadModule";
    public static final String MULTI_EJB = System.getProperty("xtest.tmpdir") +
            File.separator + "MultiSrcRootEjb";
    public static final String MULTI_WEB = System.getProperty("xtest.tmpdir") +
            File.separator + "MultiSrcRootWar";
    
    private Reporter reporter;
    private String version;
    
    public NewFileWizardsTest(String testName) {
        this(testName, "1.4");
    }
    
    public NewFileWizardsTest(String testName, String version) {
        super(testName);
        this.version = version;
    }
    
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new NbTestSuite(NewFileWizardsTest.class);
        return suite;
    }
    
    public void setUp() throws Exception {
        reporter = Reporter.getReporter((NbTestCase) this);
    }
    
    public void tearDown() throws Exception {
        reporter.close();
    }
    
    /**
     * Create new web service from scratch in EJB module.
     */
    public void testNewWebSvcWizardInEjb() throws Exception {
        webSvcTest(DEF_EJB_MOD + version, "DefaultWSinEjb", "websvc", null);
    }
    
    /**
     * Create new message handler from template in EJB module.
     */
    public void testMsgHandlerInEjb() throws Exception {
        msgHandlerTest(DEF_EJB_MOD + version, "MsgHandler", "handler", null);
    }
    
    /**
     * Create new web service from scratch in Web application.
     */
    public void testNewWebSvcWizardInWeb() throws Exception {
        webSvcTest(DEF_WEB_MOD + version, "DefaultWSinWeb", "websvc", null);
    }
    
    /**
     * Create new web service from scratch in JavaEE5 Web application.
     */
    public void testNewWebSvcWizardInWeb5() throws Exception {
        webSvcTest5(DEF_WEB_MOD + version, "DefaultWSinWeb5", "websvc", null);
    }
    
    /**
     * Create new web service from scratch in JavaEE5 Ejb Module.
     */
    public void testNewWebSvcWizardInEjb5() throws Exception {
        webSvcTest5(DEF_EJB_MOD + version, "DefaultWSinEjb5", "websvc", null);
    }
    
    /**
     * Create new message handler from template in Web application.
     */
    public void testMsgHandlerInWeb() throws Exception {
        msgHandlerTest(DEF_WEB_MOD + version, "MsgHandler", "handler", null);
    }
    
    /**
     * Create new stateless session bean with local interface.
     */
    public void testLocalSessionBean() throws Exception {
        ejbTest("Session Bean", DEF_EJB_MOD + version, "LocalSession",
                "ejbs.local", true, false, true, null);
    }
    
    /**
     * Create new stateless session bean with remote interface.
     */
    public void testRemoteSessionBean() throws Exception {
        ejbTest("Session Bean", DEF_EJB_MOD + version, "RemoteSession",
                "ejbs.remote", false, true, true, null);
    }
    
    /**
     * Create new stateless session bean with local and remote interfaces.
     */
    public void testLocalRemoteSessionBean() throws Exception {
        ejbTest("Session Bean", DEF_EJB_MOD + version, "LocalAndRemoteSession",
                "ejbs", true, true, true, null);
    }
    
    /**
     * Create new stateful session bean with local interface.
     */
    public void testLocalStatefulSessionBean() throws Exception {
        ejbTest("Session Bean", DEF_EJB_MOD + version, "LocalStatefulSession",
                "stateful.ejbs.local", true, false, false, null);
    }
    
    /**
     * Create new stateful session bean with remote interface.
     */
    public void testRemoteStatefulSessionBean() throws Exception {
        ejbTest("Session Bean", DEF_EJB_MOD + version, "RemoteStatefulSession",
                "stateful.ejbs.remote", false, true, false, null);
    }
    
    /**
     * Create new stateful session bean with local and remote interfaces.
     */
    public void testLocalRemoteStatefulSessionBean() throws Exception {
        ejbTest("Session Bean", DEF_EJB_MOD + version, "LocalAndRemoteStatefulSession",
                "stateful.ejbs", true, true, false, null);
    }
    
    /**
     * Create new CMP entity bean with local interface
     * and <code>String</code> as primary key class.
     */
    public void testLocalEntityBean() throws Exception {
        ejbTest("Entity Bean", DEF_EJB_MOD + version, "LocalEntity",
                "ejbs.entity.local", true, false, true, null);
    }
    
    /**
     * Create new CMP entity bean with remote interface
     * and <code>String</code> as primary key class.
     */
    public void testRemoteEntityBean() throws Exception {
        ejbTest("Entity Bean", DEF_EJB_MOD + version, "RemoteEntity",
                "ejbs.entity.remote", false, true, true, null);
    }
    
    /**
     * Create new CMP entity bean with local and remote interfaces
     * and <code>String</code> as primary key class.
     */
    public void testLocalRemoteEntityBean() throws Exception {
        ejbTest("Entity Bean", DEF_EJB_MOD + version, "LocalAndRemoteEntity",
                "ejbs.entity", true, true, true, null);
    }
    
    /**
     * Create new BMP entity bean with local interface
     * and <code>String</code> as primary key class.
     */
    public void testLocalBeanEntityBean() throws Exception {
        ejbTest("Entity Bean", BAD_EJB_MOD + version, "LocalBeanEntity",
                "ejbs.entity.bean.local", true, false, false, null);
    }
    
    /**
     * Create new BMP entity bean with remote interface
     * and <code>String</code> as primary key class.
     */
    public void testRemoteBeanEntityBean() throws Exception {
        ejbTest("Entity Bean", BAD_EJB_MOD + version, "RemoteBeanEntity",
                "ejbs.entity.bean.remote", false, true, false, null);
    }
    
    /**
     * Create new BMP entity bean with local and remote interfaces
     * and <code>String</code> as primary key class.
     */
    public void testLocalRemoteBeanEntityBean() throws Exception {
        ejbTest("Entity Bean", BAD_EJB_MOD + version, "LocalAndRemoteBeanEntity",
                "ejbs.entity.bean", true, true, false, null);
    }
    
    /**
     * Create new queue message-driven bean.
     */
    public void testQueueMdbBean() throws Exception {
        ejbTest("Message-Driven Bean", DEF_EJB_MOD + version, "QueueMdb",
                "ejbs.mdb", false, false, true, null);
    }
    
    /**
     * Create new topic message-driven bean.
     */
    public void testTopicMdbBean() throws Exception {
        ejbTest("Message-Driven Bean", DEF_EJB_MOD + version, "TopicMdb",
                "ejbs.mdb", false, false, false, null);
    }
    
    /**
     * Create new persistence unit in Ejb module.
     */
    public void testPersistenceUnitInEjb() throws Exception {
        puTest(DEF_EJB_MOD + version, "ejbPu");
    }
    
    /**
     * Create new persistence unit in Web module.
     */
    public void testPersistenceUnitInWeb() throws Exception {
        puTest(DEF_WEB_MOD + version, "webPu");
    }
    
    /**
     * Create new entity class in Ejb module.
     */
    public void testEntityClassInEjb() throws Exception {
        entityClassTest(DEF_EJB_MOD + version, "EjbEntity",
                "ejb.entity", null);
    }
    
    /**
     * Create new entity class in Web module.
     */
    public void testEntityClassInWeb() throws Exception {
        entityClassTest(DEF_WEB_MOD + version, "WebEntity",
                "web.entity", null);
    }
    
    /**
     * Create new service locator from template in EJB module.
     */
    public void testServiceLocatorInEjb() throws Exception {
        serviceLocatorTest(DEF_EJB_MOD + version, "ServiceLocator",
                "locator", false, null);
    }
    
    /**
     * Create new caching service locator from template in EJB module.
     */
    public void testCachingServiceLocatorInEjb() throws Exception {
        serviceLocatorTest(DEF_EJB_MOD + version, "CachingServiceLocator",
                "locator.cache", true, null);
    }
    
    /**
     * Create new service locator from template in Web application.
     */
    public void testServiceLocatorInWeb() throws Exception {
        serviceLocatorTest(DEF_WEB_MOD + version, "ServiceLocator",
                "locator", false, null);
    }
    
    /**
     * Create new service locator from template in Web application.
     */
    public void testCachingServiceLocatorInWeb() throws Exception {
        serviceLocatorTest(DEF_WEB_MOD + version, "CachingServiceLocator",
                "locator.cache", true, null);
    }
    
    /**
     * Create new WSDL file from template in Web application.
     */
    public void testWSDLinWeb() throws Exception {
        wsdlFileTest(DEF_WEB_MOD + version, "web_wsdl", "web/WEB-INF/wsdl", null);
    }
    
    /**
     * Create new WSDL file from template in EJB module.
     */
    public void testWSDLinEjb() throws Exception {
        wsdlFileTest(DEF_EJB_MOD + version, "ejb_wsdl", "src/conf/wsdl", null);
    }
    
    /**
     * Build EJB Module with created beans, web service
     * and other objects.
     */
    public void testBuildDefaultNewEJBMod() {
        tearDownProject("def EJB Mod" + version);
    }
    
    /**
     * Build Web application with  web service
     * and other objects.
     */
    public void testBuildDefaultNewWebMod() {
        tearDownProject("def Web app" + version);
    }
    
    /**
     * Build Web application with created beans, web service
     * and other objects.
     */
    public void testBuildDefaultNewJakartaWebMod() {
        tearDownProject("Jakarta Web App" + version);
    }
    
    /**
     * Go through New Web Service wizard.
     */
    private void webSvcTest(String prjRoot, String wsName, String wsPkg,
            String srcRoot) throws Exception {
        boolean hasMoreSrcRoots = (srcRoot != null);
        Project p = (hasMoreSrcRoots)
        ? J2eeProjectSupport.getProject(new File(prjRoot), ".")
        : J2eeProjectSupport.getProject(getWorkDir(), prjRoot);
        NewFileWizardOperator nfwo = WizardUtils.createNewFile(p,
                "Web Services", "Web Service");
        NewFileNameLocationStepOperator nop = WizardUtils.setFileNameLocation(
                wsName, wsPkg, srcRoot);
        nop.finish();
        //wait until webservices.xml is generated
        //new NbDialogOperator("Progress...").waitClosed();
        new EventTool().waitNoEvent(30000);
        WebSvc ws = (hasMoreSrcRoots)
        ? new WebSvc(wsPkg + "." + wsName, p, srcRoot)
        : new WebSvc(wsPkg + "." + wsName, p);
        String[] err = ws.checkExistingFiles();
        assertTrue(Arrays.asList(err).toString(),  err.length == 0);
        List/*File*/ files = new ArrayList();
        File prjDir = (hasMoreSrcRoots)
        ? new File(prjRoot).getCanonicalFile()
        : new File(getWorkDir(), prjRoot).getCanonicalFile();
        if (wsName.indexOf("Ejb") > 0) {
            files.add(new File(prjDir, "src/conf/ejb-jar.xml"));
            files.add(new File(prjDir, "src/conf/sun-ejb-jar.xml"));
            files.add(new File(prjDir, "src/conf/webservices.xml"));
        } else {
            files.add(new File(prjDir, "web/WEB-INF/web.xml"));
            files.add(new File(prjDir, "web/WEB-INF/sun-web.xml"));
            files.add(new File(prjDir, "web/WEB-INF/webservices.xml"));
        }
        if (!hasMoreSrcRoots) {
            files.addAll(Arrays.asList(
                    new File(prjDir, "src/java/" + wsPkg.replace('.', '/') + "/")
                    .listFiles(new Filter(wsName))));
        } else {
            files.addAll(Arrays.asList(
                    new File(prjDir, srcRoot + "/" + wsPkg.replace('.', '/') + "/")
                    .listFiles(new Filter(wsName))));
        }
        checkFiles(files);
    }
    
    /**
     * Go through New Web Service wizard.
     */
    private void webSvcTest5(String prjRoot, String wsName, String wsPkg,
            String srcRoot) throws Exception {
        Project p = J2eeProjectSupport.getProject(getWorkDir(), prjRoot);
        NewFileWizardOperator nfwo = WizardUtils.createNewFile(p,
                "Web Services", "Web Service");
        NewFileNameLocationStepOperator nop = WizardUtils.setFileNameLocation(
                wsName, wsPkg, srcRoot);
        nop.finish();
        new EventTool().waitNoEvent(30000);
        List/*File*/ files = new ArrayList();
        File prjDir = new File(getWorkDir(), prjRoot).getCanonicalFile();
        files.addAll(Arrays.asList(
                new File(prjDir, "src/java/" + wsPkg.replace('.', '/') + "/")
                .listFiles(new Filter(wsName))));
        checkFiles(files);
    }
    
    /**
     * Go through New Message Handler wizard.
     */
    private void msgHandlerTest(String prjRoot, String name, String pkg, String srcRoot)
    throws Exception {
        boolean hasMoreSrcRoots = (srcRoot != null);
        Project p = (hasMoreSrcRoots)
        ? J2eeProjectSupport.getProject(new File(prjRoot), ".")
        : J2eeProjectSupport.getProject(getWorkDir(), prjRoot);
        NewFileWizardOperator nfwo = WizardUtils.createNewFile(p,
                "Web Services", "Message Handler");
        NewFileNameLocationStepOperator nop = WizardUtils.setFileNameLocation(
                name, pkg, srcRoot);
        nop.finish();
        List/*File*/ files = new ArrayList(1);
        File prjDir = (hasMoreSrcRoots)
        ? new File(prjRoot).getCanonicalFile()
        : new File(getWorkDir(), prjRoot).getCanonicalFile();
        if (!hasMoreSrcRoots) {
            files.add(new File(prjDir, "src/java/" + pkg.replace('.', '/') + "/" + name + ".java"));
        } else {
            files.add(new File(prjDir, srcRoot + "/" + pkg.replace('.', '/') + "/" + name + ".java"));
        }
        checkFiles(files);
    }
    
    /**
     * Go through New Session/Entity/Message-Driven Bean wizard.
     *
     *@param stateless stateless/stateful option in case of session bean,
     *       container/bean in case of entity bean,
     *       queue/topic in case of mdb bean
     */
    private void ejbTest(String type, String prjRoot, String ejbName, String ejbPkg,
            boolean local, boolean remote, boolean stateless, String srcRoot) throws Exception {
        boolean hasMoreSrcRoots = (srcRoot != null);
        Project p = (hasMoreSrcRoots)
        ? J2eeProjectSupport.getProject(new File(prjRoot), ".")
        : J2eeProjectSupport.getProject(getWorkDir(), prjRoot);
        NewFileWizardOperator nfwo = WizardUtils.createNewFile(p,
                "Enterprise", type);
        NewFileNameLocationStepOperator nop = WizardUtils.setFileNameLocation(
                ejbName, ejbPkg, srcRoot);
        if (type.equals("Message-Driven Bean")) {
            if (!stateless) {
                new JRadioButtonOperator(nop, "Topic").setSelected(true);
            }
        } else {
            if (!stateless) {
                if (type.equals("Session Bean")) {
                    new JRadioButtonOperator(nop, "Stateful").setSelected(true);
                } else {
                    new JRadioButtonOperator(nop, "Bean").setSelected(true);
                }
            }
            new JCheckBoxOperator(nop, "Local").setSelected(local);
            new JCheckBoxOperator(nop, "Remote").setSelected(remote);
        }
        nop.finish();
        Ejb ejb = (hasMoreSrcRoots)
        ? new Ejb(ejbPkg + "." + ejbName, p, local, remote, srcRoot)
        : new Ejb(ejbPkg + "." + ejbName, p, local, remote);
        if ("1.4".equals(version)) {
            String[] err = ejb.checkExistingFiles();
            assertTrue(Arrays.asList(err).toString(),  err.length == 0);
        }
        List/*File*/ files = new ArrayList();
        File prjDir = (hasMoreSrcRoots)
        ? new File(prjRoot).getCanonicalFile()
        : new File(getWorkDir(), prjRoot).getCanonicalFile();
        if ("1.4".equals(version)) {
            files.add(new File(prjDir, "src/conf/ejb-jar.xml"));
            files.add(new File(prjDir, "src/conf/sun-ejb-jar.xml"));
        }
        if (!hasMoreSrcRoots) {
            files.addAll(Arrays.asList(
                    new File(prjDir, "src/java/" + ejbPkg.replace('.', '/') + "/")
                    .listFiles(new Filter(ejbName))));
        } else {
            files.addAll(Arrays.asList(
                    new File(prjDir, srcRoot + "/" + ejbPkg.replace('.', '/') + "/")
                    .listFiles(new Filter(ejbName))));
        }
        checkFiles(files);
    }
    
    /**
     * Go through New (Caching) Service Locator wizard.
     */
    private void serviceLocatorTest(String prjRoot, String name, String pkg,
            boolean caching, String srcRoot) throws Exception {
        boolean hasMoreSrcRoots = (srcRoot != null);
        Project p = (hasMoreSrcRoots)
        ? J2eeProjectSupport.getProject(new File(prjRoot), ".")
        : J2eeProjectSupport.getProject(getWorkDir(), prjRoot);
        String type = (caching) ? "Caching Service Locator" : "Service Locator";
        NewFileWizardOperator nfwo = WizardUtils.createNewFile(p,
                "Enterprise", type);
        NewFileNameLocationStepOperator nop = WizardUtils.setFileNameLocation(
                name, pkg, srcRoot);
        nop.finish();
        List/*File*/ files = new ArrayList(1);
        File prjDir = (hasMoreSrcRoots)
        ? new File(prjRoot).getCanonicalFile()
        : new File(getWorkDir(), prjRoot).getCanonicalFile();
        if (!hasMoreSrcRoots) {
            files.add(new File(prjDir, "src/java/" + pkg.replace('.', '/') + "/" + name + ".java"));
        } else {
            files.add(new File(prjDir, srcRoot + "/" + pkg.replace('.', '/') + "/" + name + ".java"));
        }
        checkFiles(files);
    }
    
    /**
     * Go through New WSDL File wizard.
     */
    private void wsdlFileTest(String prjRoot, String name, String dir, String srcRoot)
    throws Exception {
        Project p = (srcRoot != null)
        ? J2eeProjectSupport.getProject(new File(prjRoot), ".")
        : J2eeProjectSupport.getProject(getWorkDir(), prjRoot);
        NewFileWizardOperator nfwo = WizardUtils.createNewFile(p,
                "Web Services", "WSDL");
        NewFileNameLocationStepOperator op = new NewFileNameLocationStepOperator();
        new EventTool().waitNoEvent(500);
        op.setObjectName(name);
        new EventTool().waitNoEvent(1000);
        JTextFieldOperator jtfo = new JTextFieldOperator(op, 2);
        jtfo.clearText();
        jtfo.typeText(dir);
        op.finish();
        List/*File*/ files = new ArrayList(1);
        File prjDir = (srcRoot != null)
        ? new File(prjRoot).getCanonicalFile()
        : new File(getWorkDir(), prjRoot).getCanonicalFile();
        files.add(new File(prjDir, dir + "/" + name + ".wsdl"));
        checkFiles(files);
    }
    
    private void puTest(String prjRoot, String name) throws Exception {
        Project p = J2eeProjectSupport.getProject(getWorkDir(), prjRoot);
        NewFileWizardOperator nfwo = WizardUtils.createNewFile(p,
                "Persistence", "Persistence Unit");
        JTextFieldOperator jtfo = new JTextFieldOperator(nfwo, 0);
        jtfo.clearText();
        jtfo.typeText(name);
        JComboBoxOperator jcbo = new JComboBoxOperator(nfwo, 1);
        jcbo.selectItem("sample");
        nfwo.finish();
        List/*File*/ files = new ArrayList();
        File prjDir = new File(getWorkDir(), prjRoot).getCanonicalFile();
        files.add(new File(prjDir, "src/conf/persistence.xml"));
        checkFiles(files);
    }
    
    private void entityClassTest(String prjRoot, String name, String pkg, String srcRoot)
            throws Exception {
        boolean hasMoreSrcRoots = (srcRoot != null);
        Project p = (hasMoreSrcRoots)
        ? J2eeProjectSupport.getProject(new File(prjRoot), ".")
        : J2eeProjectSupport.getProject(getWorkDir(), prjRoot);
        NewFileWizardOperator nfwo = WizardUtils.createNewFile(p,
                "Persistence", "Entity Class");
        NewFileNameLocationStepOperator nop = WizardUtils.setFileNameLocation(
                name, pkg, srcRoot);
        nop.finish();
        List/*File*/ files = new ArrayList();
        File prjDir = (hasMoreSrcRoots)
        ? new File(prjRoot).getCanonicalFile()
        : new File(getWorkDir(), prjRoot).getCanonicalFile();
        if (!hasMoreSrcRoots) {
            files.addAll(Arrays.asList(
                    new File(prjDir, "src/java/" + pkg.replace('.', '/') + "/")
                    .listFiles(new Filter(name))));
        } else {
            files.addAll(Arrays.asList(
                    new File(prjDir, srcRoot + "/" + pkg.replace('.', '/') + "/")
                    .listFiles(new Filter(name))));
        }
        checkFiles(files);
    }
    
    
    /**
     * Check files against golden files.
     *
     *@param newFiles files to check
     */
    private void checkFiles(List newFiles) {
        try {
            //have to wait till files are saved
            Thread.currentThread().sleep(12500);
        } catch (InterruptedException ie) {
            //ignore
        }
        if (!CREATE_GOLDEN_FILES) {
            List l = new ArrayList(newFiles.size() / 2);
            for (Iterator i = newFiles.iterator(); i.hasNext();) {
                File newFile = (File) i.next();
                File goldenFile = null;
                try {
                    goldenFile = getGoldenFile(getName() + "_" + version + "/" + newFile.getName() + ".pass");
                    if (newFile.getName().endsWith(".xml") && !newFile.getName().startsWith("sun-") && !newFile.getName().startsWith("webservices.xml")) {
                        assertTrue(ContentComparator.equalsXML(goldenFile, newFile));
                    } else {
                        assertFile(newFile, goldenFile,
                                new File(getWorkDirPath(), newFile.getName() + ".diff"),
                                new FilteringLineDiff());
                    }
                } catch (Throwable t) {
                    goldenFile = getGoldenFile(getName() + "_" + version + "/" + newFile.getName() + ".pass");
                    Utils.copyFile(newFile, new File(getWorkDirPath(), newFile.getName() + ".bad"));
                    Utils.copyFile(goldenFile,
                            new File(getWorkDirPath(), newFile.getName() + ".gf"));
                    l.add(newFile.getName());
                }
            }
            assertTrue("File(s) " + l.toString() + " differ(s) from golden files.", l.isEmpty());
        } else {
            createGoldenFiles(newFiles);
        }
    }
    
    private void createGoldenFiles(List/*File*/ from) {
        File f = getDataDir();;
        List names = new ArrayList();
        names.add("goldenfiles");
        while (!f.getName().equals("test")) {
            if (!f.getName().equals("sys") && !f.getName().equals("work") &&!f.getName().equals("tests")) {
                names.add(f.getName());
            }
            f=f.getParentFile();
        }
        for (int i=names.size()-1;i > -1;i--) {
            f=new File(f,(String)(names.get(i)));
        }
        f = new File(f, getClass().getName().replace('.', File.separatorChar));
        File destDir = new File(f, getName() + "_" + version);
        destDir.mkdirs();
        for (Iterator i = from.iterator(); i.hasNext();) {
            File src = (File) i.next();
            Utils.copyFile(src, new File(destDir, src.getName() + ".pass"));
        }
        assertTrue("Golden files generated.", false);
    }
    
    /**
     * Build project.
     * @paramprjName project to build
     * @param projectNameInStatus true if project name is displayed in IDE's status bar
     */
    private void tearDownProject(String prjName) {
        Utils.buildProject(prjName);
        assertTrue("Project " + prjName + " was not built.",
                new OutputOperator().getText().indexOf("BUILD SUCCESSFUL (total time:") > -1);
    }
    
    
//----------------------------------------------------- multi src roots projects
    
    /**
     * Open EJB Module project with multiple source roots.
     */
    public void testOpenEjbMultiRootProject() {
        assertNotNull(J2eeProjectSupport.openProject(MULTI_EJB));
        new ProjectsTabOperator().getProjectRootNode("MultiSrcRootEjb").expand();
    }
    
    /**
     * Open Web application project with multiple source roots.
     */
    public void testOpenWebMultiRootProject() {
        assertNotNull(J2eeProjectSupport.openProject(MULTI_WEB));
        new ProjectsTabOperator().getProjectRootNode("MultiSrcRootWar").expand();
    }
    
    /**
     * Create new web service from scratch in EJB module
     * with multiple source roots.
     */
    public void testMultiNewWebSvcWizardInEjb() throws Exception {
        webSvcTest(MULTI_EJB, "DefaultWSinEjb", "multi.websvc", "src/beans");
    }
    
    /**
     * Create new message handler from template in EJB module
     * with multiple source roots.
     */
    public void testMultiMsgHandlerInEjb() throws Exception {
        msgHandlerTest(MULTI_EJB, "MsgHandler", "multi.handler", "src/beans");
    }
    
    /**
     * Create new web service from scratch in Web application
     * with multiple source roots.
     */
    public void testMultiNewWebSvcWizardInWeb() throws Exception {
        webSvcTest(MULTI_WEB, "DefaultWSinWeb", "multi.websvc", "src/webservices");
    }
    
    /**
     * Create new message handler from template in EJB module
     * with multiple source roots.
     */
    public void testMultiMsgHandlerInWeb() throws Exception {
        msgHandlerTest(MULTI_WEB, "MsgHandler", "multi.handler", "src/webservices");
    }
    
    /**
     * Create new stateless session bean with local interface
     * in project with multiple source roots.
     */
    public void testMultiLocalSessionBean() throws Exception {
        ejbTest("Session Bean", MULTI_EJB, "LocalSession",
                "multi.ejbs.local", true, false, true, "src/beans");
    }
    
    /**
     * Create new stateless session bean with remote interface
     * in project with multiple source roots.
     */
    public void testMultiRemoteSessionBean() throws Exception {
        ejbTest("Session Bean", MULTI_EJB, "RemoteSession",
                "multi.ejbs.remote", false, true, true, "src/beans");
    }
    
    /**
     * Create new stateless session bean with local and remote interfaces
     * in project with multiple source roots.
     */
    public void testMultiLocalRemoteSessionBean() throws Exception {
        ejbTest("Session Bean", MULTI_EJB, "LocalAndRemoteSession",
                "multi.ejbs", true, true, true, "src/beans");
    }
    
    /**
     * Create new stateful session bean with local interface
     * in project with multiple source roots.
     */
    public void testMultiLocalStatefulSessionBean() throws Exception {
        ejbTest("Session Bean", MULTI_EJB, "LocalStatefulSession",
                "multi.stateful.ejbs.local", true, false, false, "src/beans");
    }
    
    /**
     * Create new stateful session bean with remote interface
     * in project with multiple source roots.
     */
    public void testMultiRemoteStatefulSessionBean() throws Exception {
        ejbTest("Session Bean", MULTI_EJB, "RemoteStatefulSession",
                "multi.stateful.ejbs.remote", false, true, false, "src/beans");
    }
    
    /**
     * Create new stateful session bean with local and remote interfaces
     * in project with multiple source roots.
     */
    public void testMultiLocalRemoteStatefulSessionBean() throws Exception {
        ejbTest("Session Bean", MULTI_EJB, "LocalAndRemoteStatefulSession",
                "multi.stateful.ejbs", true, true, false, "src/beans");
    }
    
    /**
     * Create new CMP entity bean with local interface
     * and <code>String</code> as primary key class
     * in project with multiple source roots.
     */
    public void testMultiLocalEntityBean() throws Exception {
        ejbTest("Entity Bean", MULTI_EJB, "LocalEntity",
                "multi.ejbs.entity.local", true, false, true, "src/beans");
    }
    
    /**
     * Create new CMP entity bean with remote interface
     * and <code>String</code> as primary key class
     * in project with multiple source roots.
     */
    public void testMultiRemoteEntityBean() throws Exception {
        ejbTest("Entity Bean", MULTI_EJB, "RemoteEntity",
                "multi.ejbs.entity.remote", false, true, true, "src/beans");
    }
    
    /**
     * Create new CMP entity bean with local and remote interfaces
     * and <code>String</code> as primary key class
     * in project with multiple source roots.
     */
    public void testMultiLocalRemoteEntityBean() throws Exception {
        ejbTest("Entity Bean", MULTI_EJB, "LocalAndRemoteEntity",
                "multi.ejbs.entity", true, true, true, "src/beans");
    }
    
    /**
     * Create new queue message-driven bean
     * in project with multiple source roots.
     */
    public void testMultiQueueMdbBean() throws Exception {
        ejbTest("Message-Driven Bean", MULTI_EJB, "QueueMdb",
                "multi.ejbs.mdb", false, false, true, "src/beans");
    }
    
    /**
     * Create new topic message-driven bean
     * in project with multiple source roots.
     */
    public void testMultiTopicMdbBean() throws Exception {
        ejbTest("Message-Driven Bean", MULTI_EJB, "TopicMdb",
                "multi.ejbs.mdb", false, false, false, "src/beans");
    }
    
    /**
     * Create new service locator from template in EJB module
     * with multiple source roots.
     */
    public void testMultiServiceLocatorInEjb() throws Exception {
        serviceLocatorTest(MULTI_EJB, "ServiceLocator",
                "multi.locator", false, "src/beans");
    }
    
    /**
     * Create new caching service locator from template in EJB module
     * with multiple source roots.
     */
    public void testMultiCachingServiceLocatorInEjb() throws Exception {
        serviceLocatorTest(MULTI_EJB, "CachingServiceLocator",
                "multi.locator.cache", true, "src/beans");
    }
    
    /**
     * Create new service locator from template in Web application
     * with multiple source roots.
     */
    public void testMultiServiceLocatorInWeb() throws Exception {
        serviceLocatorTest(MULTI_WEB, "ServiceLocator",
                "multi.locator", false, "src/webservices");
    }
    
    /**
     * Create new caching service locator from template in Web application
     * with multiple source roots.
     */
    public void testMultiCachingServiceLocatorInWeb() throws Exception {
        serviceLocatorTest(MULTI_WEB, "CachingServiceLocator",
                "multi.locator.cache", true, "src/webservices");
    }
    
    /**
     * Create new WSDL file from template in Web application
     * with multiple source roots.
     */
    public void testMultiWSDLinWeb() throws Exception {
        wsdlFileTest(MULTI_WEB, "web_wsdl", "web/WEB-INF/wsdl", "");
    }
    
    /**
     * Create new WSDL file from template in EJB module
     * with multiple source roots.
     */
    public void testMultiWSDLinEjb() throws Exception {
        wsdlFileTest(MULTI_EJB, "ejb_wsdl", "src/conf/wsdl", "");
    }
    
    /**
     * Build EJB Module with created beans, web service
     * and other objects in other then default source root..
     */
    public void testBuildEjbMultiRootProject() {
        tearDownProject("MultiSrcRootEjb");
    }
    
    /**
     * Build Web application with created web service
     * and other objects in other then default source root..
     */
    public void testBuildWebMultiRootProject() {
        tearDownProject("MultiSrcRootWar");
    }

    private class Filter implements FilenameFilter {
        
        private String start;
        
        public Filter(String name) {
            start = name;
        }
        
        public boolean accept(File dir, String name) {
            return name.startsWith(start);
        }
    }
}
