/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.refactoring.usages;

import java.io.File;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.refactoring.WebAppConstants;

/**
 * Find Usages simple tests
 * @author  jungi
 */
public class WebAppTest extends WhereUsedTestCase implements WebAppConstants {
    
    private static boolean prjOpened = false;
    
    /** Creates a new instance of Signature1Test */
    public WebAppTest(String name) {
        super(name);
    }
    
    public static TestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new WebAppTest("testInterface"));
        suite.addTest(new WebAppTest("testInterfaceParams"));
        suite.addTest(new WebAppTest("testClass"));
        suite.addTest(new WebAppTest("testClassParams"));
        suite.addTest(new WebAppTest("testMsgHandler"));
        return suite;
    }
    
    public void testClass() {
        findClass(CLASS_NAME_1);
        findClass(CLASS_NAME_2);
        try {
            findClass("com.foo.bar.XY");
        } catch (IllegalStateException ise) {
            ref("");
            ref(ise.getMessage());
            ref("");
            return;
        }
        fail("Non existing class was found!");
    }
    
    public void testInterface() {
        findClass(IFACE_NAME_1);
        try {
            findClass("com.foo.bar.Jkkl");
        } catch (IllegalStateException ise) {
            ref("");
            ref(ise.getMessage());
            ref("");
            return;
        }
        fail("Non existing interface was found!");
    }
    
    public void testClassParams() {
        findClassParams(CLASS_NAME_1, CLASS_USAGES);
        findClassParams(CLASS_NAME_2, CLASS_USAGES);
        //findClassParams("java.lang.String", CLASS_USAGES);
        try {
            findClassParams("com.foo.bar.Pop", CLASS_USAGES);
        } catch (IllegalStateException ise) {
            ref("");
            ref(ise.getMessage());
            ref("");
            return;
        }
        fail("Non existing class was found!");
    }
    
    public void testInterfaceParams() {
        findClassParams(IFACE_NAME_1, CLASS_USAGES);
        try {
            findClassParams("com.foo.bar.Mno", CLASS_USAGES);
        } catch (IllegalStateException ise) {
            ref("");
            ref(ise.getMessage());
            ref("");
            return;
        }
        fail("Non existing interface was found!");
    }
    
    public void testMsgHandler() {
        findClass(HANDLER_NAME_1);
        findClassParams(HANDLER_NAME_2, CLASS_USAGES);
    }
    
    /**
     * Used for running test from inside the IDE by internal execution.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }

    public void prepareProject() {
        if (prjOpened) {
            return;
        }
        J2eeProjectSupport.openProject(new File(getDataDir(), "projects/LoggingWS"));
        classPathWorkDir = new File(getDataDir(), "projects.LoggingWS.src.java".replace('.', File.separatorChar));
        prjOpened = true;
    }
    
}
