/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.refactoring.rename;

import java.io.File;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.refactoring.EjbModConstants;

/**
 *
 * @author jungi
 */
public class EjbModTest extends RenameTestCase implements EjbModConstants {
    
    private static boolean prjOpened = false;

    //_name_Bean, _name_Local, _name_LocalHome, _name_Remote, _name_RemoteHome, MDB
    
    /** Creates a new instance of EjbModTest */
    public EjbModTest(String name) {
        super(name);
    }
    
    public static TestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new EjbModTest("testRenameCMPBean"));
        suite.addTest(new EjbModTest("testRenameCMPLocal"));
        suite.addTest(new EjbModTest("testRenameCMPLocalHome"));
        suite.addTest(new EjbModTest("testRenameSessionRemote"));
        suite.addTest(new EjbModTest("testRenameSessionRemoteHome"));
        suite.addTest(new EjbModTest("testRenameSessionBean"));
        suite.addTest(new EjbModTest("testRenameTopicMDB"));
        suite.addTest(new EjbModTest("testRenameQueueMDB"));
        suite.addTest(new EjbModTest("testRenameWsInterface"));
        suite.addTest(new EjbModTest("testRenameWsClass"));
        suite.addTest(new EjbModTest("testRenameUsedMsgHandler"));
        suite.addTest(new EjbModTest("testRenameUnusedMsgHandler"));
        suite.addTest(new EjbModTest("testRenameClass"));
        //suite.addTest(new EjbModTest("testRenameWsPackage"));
        //suite.addTest(new EjbModTest("testRenameEjbPackage"));
        return suite;
    }
    
    public void testRenameCMPBean() {
        renameClass(CLASS_CMP_ENTITY_1, "TeamRenamedBean", false, false);
    }
    
    public void testRenameCMPLocal() {
        renameClass(INTERFACE_CMP_ENTITY_LOCAL_3, "ResultRenamedLocal", false, false);
    }
    
    public void testRenameCMPLocalHome() {
        renameClass(INTERFACE_CMP_ENTITY_LOCAL_HOME_4, "MatchRenamedLocalHome", false, false);
    }
    
    public void testRenameSessionBean() {
        renameClass(CLASS_SESSION_1, "SessionRenamedBean", false, false);
    }
    
    public void testRenameSessionRemote() {
        renameClass(INTERFACE_SESSION_REMOTE_1, "SessionRenamed1Remote", false, false);
    }
    
    public void testRenameSessionRemoteHome() {
        renameClass(INTERFACE_SESSION_REMOTE_HOME_1, "SessionRenamed1RemoteHome", false, false);
    }
    
    public void testRenameClass() {
        renameClass(CLASS_JAVA_1, "CSLocatorRenamed", false, false);
    }
    
    public void testRenameWsInterface() {
        renameClass(INTERFACE_WS_1, "WsSEIRenamed", false, false);
    }
    
    public void testRenameWsClass() {
        renameClass(CLASS_WS_1, "LeagueWebServiceRenamedBean", false, false);
    }
    
    public void testRenameTopicMDB() {
        renameClass(MDB_TOPIC, "TopicMessageRenamedBean", false, false);
    }
    
    public void testRenameQueueMDB() {
        renameClass(MDB_QUEUE, "QueueMessageRenamedBean", false, false);
    }

    public void testRenameUsedMsgHandler() {
        renameClass(CLASS_HANDLER_1, "UsedHandlerRenamed", false, false);
    }
    
    public void testRenameUnusedMsgHandler() {
        renameClass(CLASS_HANDLER_2, "UnusedHandlerRenamed", false, false);
    }

    /*
    public void testRenameWsPackage() {
        renamePackage("league.ws", "league.websvc", "league.ws.UnusedHandlerRenamed", false);
    }
    
    public void testRenameEjbPackage() {
        renamePackage("league.ejb.entity", "league.beans", CLASS_JAVA_2, false);
    }
     */
    

    /**
     * Used for running test from inside the IDE by internal execution.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }

    public void prepareProject() {
        if (prjOpened) {
            return;
        }
        J2eeProjectSupport.openProject(new File(getDataDir(), "projects/League-util"));
        J2eeProjectSupport.openProject(new File(getDataDir(), "projects/League-ejb"));
        classPathWorkDir = new File(getDataDir(), "projects.League-ejb.src.java".replace('.', File.separatorChar));
        prjOpened = true;
    }

}
