/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.refactoring.move;

import java.io.File;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.refactoring.WebAppConstants;

/**
 * Find Usages simple tests
 * @author  jungi
 */
public class WebAppTest extends MoveTestCase implements WebAppConstants {
    
    private static boolean prjOpened = false;
    
    /** Creates a new instance of Signature1Test */
    public WebAppTest(String name) {
        super(name);
    }
    
    public static TestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new WebAppTest("testMoveWsSei"));
//        suite.addTest(new WebAppTest("testMoveWsImpl"));
//        suite.addTest(new WebAppTest("testMoveServlet"));
        suite.addTest(new WebAppTest("testMoveUsedHandler"));
        suite.addTest(new WebAppTest("testMoveUnusedHandler"));
        /*
        suite.addTest(new WebAppTest("testUndoMoveWsSei"));
        suite.addTest(new WebAppTest("testUndoMoveWsImpl"));
        suite.addTest(new WebAppTest("testUndoMoveServlet"));
        suite.addTest(new WebAppTest("testUndoMoveUsedHandler"));
        suite.addTest(new WebAppTest("testUndoMoveUnusedHandler"));
         */
        return suite;
    }
    
    public void testMoveWsSei() {
        moveClass(IFACE_NAME_1, DESTINATION_PACKAGE_1, false);
    }
    
    public void testMoveWsImpl() {
        moveClass(CLASS_NAME_1, DESTINATION_PACKAGE_2, false);
    }
    
    public void testMoveServlet() {
        moveClass(CLASS_NAME_2, DESTINATION_PACKAGE_1, false);
    }
    
    public void testMoveUsedHandler() {
        moveClass(HANDLER_NAME_1, DESTINATION_PACKAGE_2, false);
    }
    
    public void testMoveUnusedHandler() {
        moveClass(HANDLER_NAME_2, DESTINATION_PACKAGE_1, false);
    }
    
    //undo
    public void testUndoMoveWsSei() {
        moveClass(IFACE_NAME_1, DESTINATION_PACKAGE_2, true);
    }
    
    public void testUndoMoveWsImpl() {
        moveClass(CLASS_NAME_1, DESTINATION_PACKAGE_1, true);
    }
    
    public void testUndoMoveServlet() {
        moveClass(CLASS_NAME_2, DESTINATION_PACKAGE_2, true);
    }
    
    public void testUndoMoveUsedHandler() {
        assertTrue("See issue 59611.", false);
        moveClass(HANDLER_NAME_1, DESTINATION_PACKAGE_1, true);
    }
    
    public void testUndoMoveUnusedHandler() {
        moveClass(HANDLER_NAME_2, DESTINATION_PACKAGE_2, true);
    }
    
    /**
     * Used for running test from inside the IDE by internal execution.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
    public void prepareProject() {
        if (prjOpened) {
            return;
        }
        J2eeProjectSupport.openProject(new File(getDataDir(), "projects/LoggingWS"));
        classPathWorkDir = new File(getDataDir(), "projects.LoggingWS.src.java".replace('.', File.separatorChar));
        prjOpened = true;
    }
    
}
