/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.refactoring.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.test.j2ee.refactoring.RefactoringTestCase;
import org.netbeans.test.j2ee.refactoring.Utility;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/**
 *
 * @author  eh103527
 */
public class MoveTestCase extends RefactoringTestCase {

    protected static final String DESTINATION_PACKAGE_1 = "org.netbeans.test.examples.movetest";
    
    protected static final String DESTINATION_PACKAGE_2 = "org.netbeans.test.examples.movetest.subpkg";
    
    /** Creates a new instance of MoveTestCase */
    public MoveTestCase(String name) {
        super(name);
    }
    
    protected void moveClass(String name, String newPackage, boolean undo) {
        setJavaClass(name);
        ref("Move class "+name+" to "+newPackage);
        
        HashMap files=null;
        RefactoringSession result = RefactoringSession.create("Move Class");
        boolean finish=false;
        Utility.prepareTest();
        try {
            Resource resource = (Resource) jc.refImmediateComposite();
            FileObject classPathWorkDirFO = FileUtil.toFileObject(classPathWorkDir);
            Collection list = new ArrayList(1);
            list.add(resource);
            MoveClassRefactoring refactoring = new MoveClassRefactoring(list);
            if (refProblems( refactoring.preCheck() )) throw new Exception("Fatal problem");
            refactoring.setTargetClassPathRoot(classPathWorkDirFO);
            refactoring.setTargetPackageName(newPackage);
            if (refProblems(refactoring.checkParameters()))  throw new Exception("Fatal problem");
            if (refProblems(refactoring.prepare(result) )) throw new Exception("Fatal problem");
            files=getResources(result);
            if (refProblems( result.doRefactoring(true) )) throw new Exception("Fatal problem");
            finish=true;
        } catch (Throwable t) {
            if (t.getMessage() == null || !t.getMessage().equals("Fatal problem")) {
                t.printStackTrace(getLogStream());
                assertTrue(t.getMessage(), false);
            }
        } finally {
            Utility.finishTest();
        }
        if (finish) {
            try {
                Thread.sleep(5000);
                if (undo) {
                    JavaMetamodel.getUndoManager().undo();
                    Thread.sleep(10000);
                }
                compareResources(files, result, name, newPackage+"."+((name.indexOf('.') > -1) ? name.substring(name.lastIndexOf('.')+1):name));
            } catch (Exception ex) {
                ex.printStackTrace(getLogStream());
                assertTrue(ex.getMessage(), false);
            }
        }
    }
}
