/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.multiview;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;

/**
 *
 * @author blaha
 */
public class MultiViewTest extends JellyTestCase{
    
    public MultiViewTest(String testName) {
        super(testName);
    }
    
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    protected void tearDown() throws Exception {
    }
    
    public static Test suite() {
        NbTestSuite suite = new NbTestSuite();
        // Overview module panel
        suite.addTest(new EjbModuleTest("testOpenProject"));
        suite.addTest(new EjbModuleTest("testRenameDisplayName"));
        suite.addTest(new EjbModuleTest("testChangeDescription"));
        suite.addTest(new EjbModuleTest("testAddSmallIcon"));
        suite.addTest(new EjbModuleTest("testAddLargeIcon"));
        
        //Bean details and CMP panel
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testOpenProject"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testEBName"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testDescription"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testSmallIcon"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testLargeIcon"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testRevertChanges"));
        
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testExistingCMPFields"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testAddNewCMPField"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testChangeCMPFieldName"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testChangeCMPMethods"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testChangeCMPType"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testChangeCMPDescription"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testDeleteCMPField"));
         
        // Entity General Panel
        suite.addTest(new EBGeneralAndClassPanelTest("testOpenProject"));
        suite.addTest(new EBGeneralAndClassPanelTest("testEntityNodeName"));
        suite.addTest(new EBGeneralAndClassPanelTest("testEntityName"));
        suite.addTest(new EBGeneralAndClassPanelTest("testEntityPersistanceType"));
        suite.addTest(new EBGeneralAndClassPanelTest("testEntityAbstractName"));
        suite.addTest(new EBGeneralAndClassPanelTest("testEntityPKField"));
        suite.addTest(new EBGeneralAndClassPanelTest("testEntityPKClass"));
        suite.addTest(new EBGeneralAndClassPanelTest("testChangeReentrant"));
        suite.addTest(new EBGeneralAndClassPanelTest("testChangePKMultiple"));
        suite.addTest(new EBGeneralAndClassPanelTest("testChangePK"));
        
  
        // Interfaces and classes panel
        suite.addTest(new EBGeneralAndClassPanelTest("testBeanClassName"));
        suite.addTest(new EBGeneralAndClassPanelTest("testLocalInterfaceCheckBox"));
        suite.addTest(new EBGeneralAndClassPanelTest("testLocalHomeIName"));
        suite.addTest(new EBGeneralAndClassPanelTest("testLocalIName"));
        suite.addTest(new EBGeneralAndClassPanelTest("testRemoteHomeIName"));
        suite.addTest(new EBGeneralAndClassPanelTest("testRemoteIName"));
        suite.addTest(new EBGeneralAndClassPanelTest("testRemoteInterfaceCheckBox"));
        suite.addTest(new EBGeneralAndClassPanelTest("testEnableRemoteI"));
        suite.addTest(new EBGeneralAndClassPanelTest("testDisableRemoteI"));
        
        
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        TestRunner.run(suite());
    }
    
}
