/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.multiview;

import java.io.File;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.netbeans.api.project.Project;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarDetailsNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarDetailsPanel;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;




/**
 *
 * @author blaha
 */
public class EjbModuleTest extends JellyTestCase {
    public static final String EJB_PROJECT_NAME = "TestCMP";
    public static final String EJB_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EJB_PROJECT_NAME;
    
    private static Project project;
    private static EjbJarMultiViewDataObject ddObj;
    private static FileObject ddFo;
    private static Entity bean;
    private EjbJar ejbJar;
    
    public EjbModuleTest(String testName) {
        super(testName);
    }
    
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    protected void tearDown() throws Exception {
    }
    
    public static Test suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new EjbModuleTest("testOpenProject"));
        suite.addTest(new EjbModuleTest("testRenameDisplayName"));
        suite.addTest(new EjbModuleTest("testChangeDescription"));
        suite.addTest(new EjbModuleTest("testAddSmallIcon"));
        suite.addTest(new EjbModuleTest("testAddLargeIcon"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        TestRunner.run(suite());
    }
    
    /*
     * Method open project
     *
     */
    public void testOpenProject() throws Exception{
        File projectDir = new File(EJB_PROJECT_PATH);
        project = (Project)J2eeProjectSupport.openProject(projectDir);
        assertNotNull("Project is null.", project);
        Thread.sleep(1000);
        
        EjbJarProject ejbJarProject = (EjbJarProject)project;
        ddFo = ejbJarProject.getAPIEjbJar().getDeploymentDescriptor();  // deployment descriptor
        assertNotNull("ejb-jar.xml FileObject is null.", ddFo);
        
        ddObj = (EjbJarMultiViewDataObject)DataObject.find(ddFo); //MultiView Editor
        assertNotNull("MultiViewDO is null.",ddObj);
        
        EditCookie edit = (EditCookie)ddObj.getCookie(EditCookie.class);
        edit.edit();
        Thread.sleep(1000);
    }
    
    /*
     * Rename Display name from UI, test DD, text in editor and then check file
     */
    public void testRenameDisplayName() throws Exception {
        String displayName = "testDisplayName";
        assertNotNull("DDObject not found",ddObj);
        
        ddObj.showElement(ddObj.getEjbJar()); //open visual editor
        Utils.waitForAWTDispatchThread();
        getDetailPanel().getDisplayNameTextField().setText(displayName);
        // check DD beans
        assertEquals("DD bean isn't updated", displayName,DDProvider.getDefault().getDDRoot(ddFo).getDisplayName(null));
        Thread.sleep(4000);
        checkinXML("<display-name>" + displayName + "</display-name>");
        
        //save ejb-jar.xml editor
        SaveCookie saveCookie = (SaveCookie)ddObj.getCookie(SaveCookie.class);
        assertNotNull("Save cookie is null, Data object isn't changed!", saveCookie);
        if(saveCookie != null)
            saveCookie.save();
        //check file on disc
        assertFile(FileUtil.toFile(ddFo),getGoldenFile("testRenameDisplayName_ejb-jar.xml"), new File(getWorkDir(), "testRenameDisplayName.diff"));
    }
    
    public void testChangeDescription() throws Exception {
        String descriptionName = "test New description";
        getDetailPanel().getDescriptionTextArea().setText(descriptionName);
        // check DD beans
        assertEquals("DD bean isn't updated", descriptionName,DDProvider.getDefault().getDDRoot(ddFo).getDescription(null));
        
        checkinXML("<description>" + descriptionName + "</description>");
        
        //save ejb-jar.xml editor
        SaveCookie saveCookie = (SaveCookie)ddObj.getCookie(SaveCookie.class);
        assertNotNull("Save cookie is null, Data object isn't changed!", saveCookie);
        if(saveCookie != null)
            saveCookie.save();
        //check file on disc
        assertFile(FileUtil.toFile(ddFo),getGoldenFile("testChangeDescription_ejb-jar.xml"), new File(getWorkDir(), "testChangeDescription.diff"));
    }
    
    public void testAddSmallIcon() throws Exception {
        String smallIcon = "/tmp/test/small";
        getDetailPanel().getSmallIconTextField().setText(smallIcon);
        // check DD beans
        assertEquals("DD bean isn't updated", smallIcon,DDProvider.getDefault().getDDRoot(ddFo).getSmallIcon());
        
        checkinXML("<small-icon>" + smallIcon + "</small-icon>");
        
        //save ejb-jar.xml editor
        SaveCookie saveCookie = (SaveCookie)ddObj.getCookie(SaveCookie.class);
        assertNotNull("Save cookie is null, Data object isn't changed!", saveCookie);
        if(saveCookie != null)
            saveCookie.save();
        //check file on disc
        assertFile(FileUtil.toFile(ddFo),getGoldenFile("testAddSmallIcon_ejb-jar.xml"), new File(getWorkDir(), "testAddSmallIcon.diff"));
    }
    
    public void testAddLargeIcon() throws Exception {
        String largeIcon = "/tmp/test/large";
        getDetailPanel().getLargeIconTextField().setText(largeIcon);
        // check DD beans
        assertEquals("DD bean isn't updated", largeIcon,DDProvider.getDefault().getDDRoot(ddFo).getLargeIcon());
        
        checkinXML("<large-icon>" + largeIcon + "</large-icon>");
        
        //save ejb-jar.xml editor
        SaveCookie saveCookie = (SaveCookie)ddObj.getCookie(SaveCookie.class);
        assertNotNull("Save cookie is null, Data object isn't changed!", saveCookie);
        if(saveCookie != null)
            saveCookie.save();
        //check file on disc
        assertFile(FileUtil.toFile(ddFo),getGoldenFile("testAddLargeIcon_ejb-jar.xml"), new File(getWorkDir(), "testAddLargeIcon.diff"));
    }
    
    private void checkinXML(String findText)throws Exception{
        Thread.sleep(3000);
        //check editor in text node
        XmlMultiViewEditorSupport editor = (XmlMultiViewEditorSupport)ddObj.getCookie(EditorCookie.class);
        javax.swing.text.Document document = editor.getDocument();
        document.addDocumentListener(new TestDocumentListener(findText));
    }
    
    private EjbJarDetailsPanel getDetailPanel(){
        ToolBarMultiViewElement toolBar = ddObj.getActiveMVElement();
        assertNotNull("ToolBarMultiViewElement is null",toolBar);
        SectionNodeView sectionView = (SectionNodeView)toolBar.getSectionView();
        
        Children nodes = sectionView.getRootNode().getChildren();
        Node[] n = nodes.getNodes();
        if(n[0] instanceof EjbJarDetailsNode){
            EjbJarDetailsNode detailNode = (EjbJarDetailsNode)n[0];
            return (EjbJarDetailsPanel)detailNode.getSectionNodePanel().getInnerPanel();
        }
        return null;
    }
    
}