/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.multiview;

import java.io.File;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.netbeans.api.project.Project;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.RelationshipRoleSource;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpRelationShipsNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpRelationshipsDialogHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpRelationshipsTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarDetailsNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarDetailsPanel;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.InnerTablePanel;
import org.netbeans.modules.j2ee.ddloaders.multiview.RelationshipHelper;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;




/**
 *
 * @author jhorvath
 */
public class CMPRelationshipsTest extends DDTestCase {
    public static final String EJB_PROJECT_NAME = "TestCMPRelationships";
    public static final String EJB_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EJB_PROJECT_NAME;

    
    public CMPRelationshipsTest(String testName) {
        super(testName);
    }
    
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    protected void tearDown() throws Exception {
    }
    
    public static Test suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new CMPRelationshipsTest("testOpenProject"));
        suite.addTest(new CMPRelationshipsTest("testAddRelationship"));
        suite.addTest(new CMPRelationshipsTest("testModifyRelationship"));
        suite.addTest(new CMPRelationshipsTest("testRemoveRelationship"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        TestRunner.run(suite());
    }
    
    /*
     * Method open project
     *
     */
    public void testOpenProject() throws Exception{
        File projectDir = new File(EJB_PROJECT_PATH);
        project = (Project)J2eeProjectSupport.openProject(projectDir);
        assertNotNull("Project is null.", project);
        Thread.sleep(1000);
        
        EjbJarProject ejbJarProject = (EjbJarProject)project;
        ddFo = ejbJarProject.getAPIEjbJar().getDeploymentDescriptor();  // deployment descriptor
        assertNotNull("ejb-jar.xml FileObject is null.", ddFo);
        
        ddObj = (EjbJarMultiViewDataObject)DataObject.find(ddFo); //MultiView Editor
        assertNotNull("MultiViewDO is null.",ddObj);
        
        EditCookie edit = (EditCookie)ddObj.getCookie(EditCookie.class);
        edit.edit();
        Thread.sleep(1000);
    }
    
    /*
     * Add CMP Relationship
     */
    public void testAddRelationship() throws Exception {
        String displayName = "testAddRelationship";
        assertNotNull("DDObject not found",ddObj);
        EjbJar ejbJar=ddObj.getEjbJar();
        Relationships relationships=ejbJar.getSingleRelationships();
        if (relationships==null) relationships=ddObj.getEjbJar().newRelationships();
        ejbJar.setRelationships(relationships);
        ddObj.showElement(relationships); //open visual editor
        Utils.waitForAWTDispatchThread();
        
        CmpRelationshipsTableModel tableModel=(CmpRelationshipsTableModel) getDetailPanel().getTable().getModel();
        
        RelationshipHelper relationshipHelper=new RelationshipHelper(relationships);
        
        relationshipHelper.setRelationName("test");
        relationshipHelper.setDescription("test description");
        relationshipHelper.roleA.setRoleName("role A");
        relationshipHelper.roleA.setEjbName("EntityABean");
        relationshipHelper.roleA.setMultiple(false);
        relationshipHelper.roleA.setCascadeDelete(false);
        relationshipHelper.roleB.setRoleName("role B");
        relationshipHelper.roleB.setEjbName("EntityBBean");
        relationshipHelper.roleB.setMultiple(false);
        relationshipHelper.roleB.setCascadeDelete(false);
        ddObj.getModelSynchronizer().requestUpdateData();
        
        Thread.sleep(4000);
        Utils.waitForAWTDispatchThread();
        
        //save ejb-jar.xml editor
        SaveCookie saveCookie = (SaveCookie)ddObj.getCookie(SaveCookie.class);
        assertNotNull("Save cookie is null, Data object isn't changed!", saveCookie);
        if(saveCookie != null)
            saveCookie.save();
        //check file on disc
        assertFile("ejb-jar.xml");
    }
    
    /*
     * Modify CMP Relationship
     */
    public void testModifyRelationship() throws Exception {
        String displayName = "testModifyRelationship";
        assertNotNull("DDObject not found",ddObj);
        EjbJar ejbJar=ddObj.getEjbJar();
        Relationships relationships=ejbJar.getSingleRelationships();
        if (relationships==null) fail("Relationships == null");
        ddObj.showElement(relationships); //open visual editor
        Utils.waitForAWTDispatchThread();
        
        CmpRelationshipsTableModel tableModel=(CmpRelationshipsTableModel) getDetailPanel().getTable().getModel();
       
        EjbRelation ejbRelation = ejbJar.getSingleRelationships().getEjbRelation(0);
        RelationshipHelper relationshipHelper=new RelationshipHelper(ejbRelation);
        
        relationshipHelper.roleA.setMultiple(true);
        relationshipHelper.roleA.setCascadeDelete(false);
        relationshipHelper.roleB.setMultiple(true);
        relationshipHelper.roleB.setCascadeDelete(false);
        ddObj.getModelSynchronizer().requestUpdateData();
        
        Thread.sleep(4000);
        Utils.waitForAWTDispatchThread();
        //save ejb-jar.xml editor
        SaveCookie saveCookie = (SaveCookie)ddObj.getCookie(SaveCookie.class);
        assertNotNull("Save cookie is null, Data object isn't changed!", saveCookie);
        if(saveCookie != null)
            saveCookie.save();
        //check file on disc
        //assertFile(FileUtil.toFile(ddFo),getGoldenFile("testModifyRelationship_ejb-jar.xml"), new File(getWorkDir(), "testModifyRelationship_ejb-jar.diff"));
        assertFile("ejb-jar.xml");
    }
    
    /*
     * Remove CMP Relationship
     */
    public void testRemoveRelationship() throws Exception {
        String displayName = "testRemoveRelationship";
        assertNotNull("DDObject not found",ddObj);
        EjbJar ejbJar=ddObj.getEjbJar();
        Relationships relationships=ejbJar.getSingleRelationships();
        if (relationships==null) fail("Relationships == null");
        ddObj.showElement(relationships); //open visual editor
        Utils.waitForAWTDispatchThread();
        
        relationships.removeEjbRelation(relationships.getEjbRelation(0));
        ejbJar.setRelationships(null);
        ddObj.getModelSynchronizer().requestUpdateData();
        
        Thread.sleep(4000);
        Utils.waitForAWTDispatchThread();
        
        //save ejb-jar.xml editor
        SaveCookie saveCookie = (SaveCookie)ddObj.getCookie(SaveCookie.class);
        assertNotNull("Save cookie is null, Data object isn't changed!", saveCookie);
        if(saveCookie != null)
            saveCookie.save();
        //check file on disc
        assertFile("ejb-jar.xml");
    }
    

    
   
    
}