/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.EditorWindowOperator;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.OutputTabOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.ProjectRootNode;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.junit.NbTestCase;

/**
 *
 * @author lm97939
 */
public class Utils {
    
    private NbTestCase nbtestcase;
    private static final String LIBRARY_BUNDLE = "org.netbeans.modules.project.libraries.ui.Bundle";
    
    public Utils(NbTestCase nbtestcase) {
        this.nbtestcase = nbtestcase;
    }
    
    public static String getTimeIndex() {
        return new SimpleDateFormat("HHmmssS",Locale.US).format(new Date());
    }
    
    public static void addAppServer() {
        String path = System.getProperty("j2ee.appserver.path");
        if (path == null) {
            throw new RuntimeException("Cannot setup appserver, property j2ee.appserver.path is not set.");
        }
        String username = System.getProperty("j2ee.appserver.username","admin");
        String password = System.getProperty("j2ee.appserver.password","adminadmin");
        
        Node node = new Node(new RuntimeTabOperator().getRootNode(),Bundle.getStringTrimmed("org.netbeans.modules.j2ee.deployment.impl.ui.Bundle", "SERVER_REGISTRY_NODE"));
        node.performPopupActionNoBlock(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.deployment.impl.ui.actions.Bundle", "LBL_Add_Server_Instance"));
        NbDialogOperator dialog = new NbDialogOperator(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.deployment.impl.ui.wizard.Bundle", "LBL_ASIW_Title"));
        new JComboBoxOperator(dialog).selectItem("Sun Java System Application Server");
        new JButtonOperator(dialog,Bundle.getStringTrimmed("org.openide.Bundle", "CTL_NEXT")).push();
        
        //"Enter the Application Server location" or "Define Application Server Instance Properties"
        if (new JLabelOperator(dialog,1).getText().equalsIgnoreCase(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Bundle", "TITLE_AddServerLocationPanel"))) {
            new JTextFieldOperator(dialog).setText("");
            new JTextFieldOperator(dialog).typeText(path);
            new JButtonOperator(dialog,Bundle.getStringTrimmed("org.openide.Bundle", "CTL_NEXT")).push();
        }
        new JTextFieldOperator(dialog,0).setText("");
        new JTextFieldOperator(dialog,1).setText("");
        new JTextFieldOperator(dialog,0).typeText(username);
        new JTextFieldOperator(dialog,1).typeText(password);
        new JButtonOperator(dialog,Bundle.getStringTrimmed("org.openide.Bundle", "CTL_FINISH")).push();
        new ProjectsTabOperator();
    }
    
    /**
     * Starts or Stops AppServer
     * @param start if true, starts appserver, if false stops appserver.
     */
    public static void startStopServer(boolean start) {
        RuntimeTabOperator runtimeTab = RuntimeTabOperator.invoke();
        Node serverNode = new Node(runtimeTab.getRootNode(), Bundle.getStringTrimmed("org.netbeans.modules.j2ee.deployment.impl.ui.Bundle", "SERVER_REGISTRY_NODE")
        +"|Application Server");
        new org.netbeans.jemmy.EventTool().waitNoEvent(10000);
        if (start)
            serverNode.performPopupAction("Start");
        else
            serverNode.performPopupAction("Stop");
        new org.netbeans.jemmy.EventTool().waitNoEvent(5000);
        ProgressSupport.waitFinished((start?"Starting":"Stopping") + " Sun Java System Application Server", 500000);
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
    }
    
    public static void prepareDatabase() {
        		
        new Action("Tools|"+Bundle.getStringTrimmed("org.netbeans.modules.derby.Bundle", "LBL_DerbyDatabase")+
                "|"+Bundle.getStringTrimmed("org.netbeans.modules.derby.Bundle", "LBL_StartAction"), null).performMenu();
        OutputTabOperator outputOper = new OutputTabOperator(Bundle.getStringTrimmed("org.netbeans.modules.derby.Bundle", "LBL_outputtab"));
        outputOper.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 120000);
        outputOper.waitText("Server is ready to accept connections on port 1527.");
        new Node(new RuntimeTabOperator().getRootNode(), "Databases|/sample").performPopupActionNoBlock("Connect");
        try {
            NbDialogOperator dialog = new NbDialogOperator("Connect");
            new JTextFieldOperator(dialog,0).typeText("app");
            dialog.ok();
        } catch (TimeoutExpiredException e) {}
    }
    
    public void assertFiles(File dir, String fileNames[], String goldenFilePrefix) throws IOException {
        AssertionFailedError firstExc = null;
        for (int i=0; i<fileNames.length; i++) {
            File file = new File(dir, fileNames[i]);            
            try {
                File goldenFile = nbtestcase.getGoldenFile(goldenFilePrefix + fileNames[i]);                
                nbtestcase.assertFile("File "+file.getAbsolutePath()+" is different than golden file "+goldenFile.getAbsolutePath()+".",
                        file,
                        goldenFile,
                        new File(nbtestcase.getWorkDir(), fileNames[i]+".diff"),
                        new TrimmingLineDiff()); 
            } catch (AssertionFailedError e) {
                if (firstExc == null){
                    firstExc = e;
                } 
                File copy = new File(nbtestcase.getWorkDirPath(), goldenFilePrefix+fileNames[i]);
                copyFile(file,copy);
            }
        }
        if (firstExc != null)
            throw firstExc;
    }
    
    /**
     * Copy file in to out
     * @param in File
     * @param out File
     * @throws Exception
     */
    public static void copyFile(File in, File out) {
        try {
            out.createNewFile();
            FileChannel srcChannel = new FileInputStream(in).getChannel();
            FileChannel dstChannel = new FileOutputStream(out).getChannel();
            dstChannel.transferFrom(srcChannel, 0, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
        } catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }
    
    /**
     * Loads page specified by URL
     * @param url_string URL
     * @throws java.io.IOException
     * @return downloaded page
     */
    public static String loadFromURL(String url_string) throws IOException {
        URL url = new URL(url_string);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        StringBuffer sb = new StringBuffer();
        String line;
        while ((line = reader.readLine()) != null) {
            if (sb.length() > 0)
                sb.append("\n");
            sb.append(line);
        }
        reader.close();
        return sb.toString();
    }
    
    /**
     * Deploys Application
     *
     * @return downloaded page, null if url parameter was null
     * @param projectName Name of Project to deploy
     * @param url URL of page that should be downloaded, can be null.
     * @throws java.io.IOException
     */
    public static String deploy(String projectName, String url, boolean projectNameInStatus) throws IOException {
        JTreeOperator tree = ProjectsTabOperator.invoke().tree();
        tree.setComparator(new Operator.DefaultStringComparator(true, true));
        Node node = new ProjectRootNode(tree, projectName);
        node.performPopupAction(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.earproject.ui.Bundle", "LBL_DeployAction_Name"));
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 600000);
        MainWindowOperator.getDefault().waitStatusText(Bundle.getString("org.apache.tools.ant.module.run.Bundle", "FMT_finished_target_status", new String[] {(projectNameInStatus?projectName:"build.xml")+" (run-deploy)"}));
        if (url != null)
            return Utils.loadFromURL(url);
        return null;
    }
    
    public static String deploy(String projectnName, String url)  throws IOException {
        return deploy(projectnName, url, false);
    }
    
    /** Undeploys Application. Verifies that application node in runtime disappears.
     * @param app Name of application to undeploy
     */
    
    public static void undeploy(String category, String app) {
        RuntimeTabOperator runtimeTab = RuntimeTabOperator.invoke();
        Node rootNode = new Node(runtimeTab.getRootNode(), Bundle.getStringTrimmed("org.netbeans.modules.j2ee.deployment.impl.ui.Bundle", "SERVER_REGISTRY_NODE")
        +"|Application Server|"
                + Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle", "LBL_Applications") + "|"
                + category);
        rootNode.performPopupAction("Refresh");
        Node node = new Node(rootNode, app);
        node.performPopupAction(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle", "LBL_Undeploy"));
        node.waitNotPresent();
    }
    
    public static void undeploy(String app) {
        undeploy(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle", "LBL_AppModules"), app);
    }
    
    /** Checks whether firstText in on firstLine and secondText in on secondLine. If deleteLine is true,
     *  deletes insertLine and inserts there insertText.
     */
    public void checkAndModify(String file, int firstLine, String firstText,
            int secondLine, String secondText, int insertLine, boolean deleteLine, String insertText) {
        EditorOperator editor = new EditorWindowOperator().getEditor(file);
        if (firstText != null) {
            if (!(editor.getText(firstLine).indexOf(firstText)>=0))
                nbtestcase.fail("I expect text '"+firstText+"' on line "+firstLine+" in "+file+"."+
                        "There is text: '"+editor.getText(firstLine)+"'.");
        }
        if (secondText != null) {
            if (!(editor.getText(secondLine).indexOf(secondText)>=0))
                nbtestcase.fail("I expect text '"+secondText+"' on line "+secondLine+" in "+file+"."+
                        "There is text: '"+editor.getText(secondLine)+"'.");
        }
        if (deleteLine)
            editor.deleteLine(insertLine);
        if (insertText != null)
            editor.insert(insertText, insertLine, 1);
        editor.save();
    }
    
    public static void buildProject(String projectName) {
        Node node = new ProjectsTabOperator().getProjectRootNode(projectName);
        node.performPopupAction(Bundle.getStringTrimmed(
                "org.netbeans.modules.j2ee.earproject.ui.Bundle", "LBL_BuildAction_Name"));
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 300000);
        MainWindowOperator.getDefault().waitStatusText(Bundle.getString(
                "org.apache.tools.ant.module.run.Bundle", "FMT_finished_target_status",
                new String[] {projectName.replace(' ', '_') + " (dist)"}));
        new EventTool().waitNoEvent(2500);
    }
    
    public static void cleanProject(String projectName) {
        Node node = new ProjectsTabOperator().getProjectRootNode(projectName);
        node.performPopupAction(Bundle.getStringTrimmed(
                "org.netbeans.modules.j2ee.earproject.ui.Bundle", "LBL_CleanAction_Name"));
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 300000);
        MainWindowOperator.getDefault().waitStatusText(Bundle.getString(
                "org.apache.tools.ant.module.run.Bundle", "FMT_finished_target_status",
                new String[] {projectName.replace(' ', '_') + " (clean)"}));
        new EventTool().waitNoEvent(2500);
    }
    
    public static void createLibrary(String name, String[] jars, String[] srcs, String[] javadocs) {
        if ((name == null) || (name.indexOf(" ") > -1)) {
            throw new IllegalArgumentException("Name cannot be null nor contain spaces");
        }
        if (jars == null) {
            jars = new String[0];
        }
        if (srcs == null) {
            srcs = new String[0];
        }
        if (javadocs == null) {
            javadocs = new String[0];
        }
        new ActionNoBlock("Tools|Library Manager", null).performMenu();
        NbDialogOperator ndo = new NbDialogOperator(Bundle.getStringTrimmed(
                LIBRARY_BUNDLE, "CTL_LibrariesManager"));
        new JButtonOperator(ndo, Bundle.getStringTrimmed(
                LIBRARY_BUNDLE, "CTL_NewLibrary")).push();
        NbDialogOperator ndo2 = new NbDialogOperator(Bundle.getStringTrimmed(
                LIBRARY_BUNDLE, "CTL_CreateLibrary"));
        JTextFieldOperator jtfo = new JTextFieldOperator(ndo2, 0);
        jtfo.clearText();
        jtfo.typeText(name);
        ndo2.ok();
        JTabbedPaneOperator jtpo = new JTabbedPaneOperator(ndo, "Classpath");
        for (int i = 0; i < jars.length; i++) {
            new JButtonOperator(jtpo, "Add JAR/Folder...").push();
            ndo2 = new NbDialogOperator("Browse JAR/Folder");
            jtfo = new JTextFieldOperator(ndo2, 0);
            jtfo.clearText();
            jtfo.typeText(jars[i]);
            new JButtonOperator(ndo2, "Add JAR/Folder").push();
        }
        jtpo.selectPage("Sources");
        for (int i = 0; i < srcs.length; i++) {
            new JButtonOperator(jtpo, "Add JAR/Folder...").push();
            ndo2 = new NbDialogOperator("Browse JAR/Folder");
            jtfo = new JTextFieldOperator(ndo2, 0);
            jtfo.clearText();
            jtfo.typeText(srcs[i]);
            new JButtonOperator(ndo2, "Add JAR/Folder").push();
        }
        jtpo.selectPage("Javadoc");
        for (int i = 0; i < javadocs.length; i++) {
            new JButtonOperator(jtpo, "Add ZIP/Folder...").push();
            ndo2 = new NbDialogOperator("Browse ZIP/Folder");
            jtfo = new JTextFieldOperator(ndo2, 0);
            jtfo.clearText();
            jtfo.typeText(javadocs[i]);
            new JButtonOperator(ndo2, "Add ZIP/Folder").push();
        }
        ndo.ok();
    }
    
    public static void openOutputTab() {
        new ActionNoBlock("Window|Output", null).performMenu();
    }
}
