/*
The contents of this file are subject to the terms of the Common Development
and Distribution License (the License). You may not use this file except in
compliance with the License.

You can obtain a copy of the License at http://www.netbeans.org/cddl.html
or http://www.netbeans.org/cddl.txt.

When distributing Covered Code, include this CDDL Header Notice in each file
and include the License file at http://www.netbeans.org/cddl.txt.
If applicable, add the following below the CDDL Header, with the fields
enclosed by brackets [] replaced by your own identifying information:
"Portions Copyrighted [year] [name of copyright owner]"

The Original Software is NetBeans. The Initial Developer of the Original
Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
Microsystems, Inc. All Rights Reserved.
 */
/*
 * RequiredFiles.java
 *
 * Created on May 10, 2005, 11:23 AM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package org.netbeans.test.j2ee.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/**
 *
 * @author jungi
 */
public class RequiredFiles {
    
    private Set/*<String>*/ files;
    
    /** 
     *   Creates a new instance of RequiredFiles from given <code>File</code>.
     *   @param f file containg the list of required files
     *   @throws IOException if some exception during reading <code>File f</code>
     *  occurs
     */
    public RequiredFiles(File f) throws IOException {
        init(f);
    }
    
    private void init(File f) throws IOException {
        files = new HashSet();
        BufferedReader r = new BufferedReader(new FileReader(f));
        String s = null;
        while ((s = r.readLine()) != null) {
            if (s.startsWith("#")) {
                //skip comments
                continue;
            }
            files.add(s.replace('/',  File.separatorChar));
        }
    }
    
    /*
     *   Returns sorted list of required files (as String)
     */
    public Set/*<String>*/ getRequiredFiles() {
        return new HashSet(files);
    }
}
