/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Micro//Systems, Inc. Portions Copyright 1997-2006 Sun
 * Micro//Systems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.hints;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.text.StyledDocument;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.actions.SaveAllAction;
import org.netbeans.junit.diff.LineDiff;
import org.netbeans.modules.j2ee.verification.HintsManager;
import org.netbeans.modules.j2ee.verification.JEEVerificationHint;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

/**
 *
 * @author js201828
 */
public class HintsUtils extends JellyTestCase {
    public static boolean CREATE_GOLDENFILES = false;// Boolean.getBoolean("create.goldenfiles");
    
    public HintsUtils(String s)    {
        super(s);
    }
    
    protected File refFile;
    File logFile;
    
    protected PrintStream log = null;
    protected PrintStream ref = null;
    protected PrintStream golden = null;
    
    protected void setUp() {
        prepareProject();
        try {
            //logs and refs
            refFile = new File(getWorkDir(), getName() + ".ref");
            logFile = new File(getWorkDir(), getName() + ".log");
            ref = new PrintStream(new BufferedOutputStream(new FileOutputStream(refFile)));
            log = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFile)));
            if (CREATE_GOLDENFILES) { //generates golden files
                File f;
                //generate goldenfile name
                f=getDataDir();
                ArrayList names=new ArrayList();
                names.add("goldenfiles");
                while (!f.getName().equals("test")) {
                    if (!f.getName().equals("sys") && !f.getName().equals("work") &&!f.getName().equals("tests")) {
                        names.add(f.getName());
                    }
                    f=f.getParentFile();
                }
                for (int i=names.size()-1;i > -1;i--) {
                    f=new File(f,(String)(names.get(i)));
                }
                f=new File(f, getClass().getName().replace('.', File.separatorChar));
                f=new File(f, getName()+".pass");
                if (!f.getParentFile().exists()) {
                    f.getParentFile().mkdirs();
                }
                golden=new PrintStream(new BufferedOutputStream(new FileOutputStream(f)));
                log("Passive mode: generate golden file into "+f.getAbsolutePath());
            }
        } catch (Exception e) {
            e.printStackTrace();
            assertTrue(e.toString(), false);
        }
    }
    
    public void prepareProject() {
    }
    
    protected void tearDown() {
	EditorOperator.closeDiscardAll();
	ref.close();
        log.close();
        if (logFile.length()==0) logFile.delete();
        if (CREATE_GOLDENFILES && golden != null) {
            golden.close();
            assertTrue("Passive mode", false);
        }
        if(!CREATE_GOLDENFILES) {
            try {
                assertFile("Golden file differs ", refFile, getGoldenFile(), getWorkDir(), new LineDiff(false, true));
            } catch (Exception ex) {
                ex.printStackTrace(log);
                assertTrue(ex.toString(), false);
            }
        }
    }
    
    protected String hintTest(File testedFile, int number, final String str){//retuns changed file; number gives a position of choosen hint
        String result = new String();           // b - true => wait for a dialog; b-false => doesn't wait for dialog
        try{
            FileObject fileToTest = FileUtil.toFileObject(testedFile);
            DataObject dataToTest;
            dataToTest = DataObject.find(fileToTest);
            EditorCookie editorCookie = (EditorCookie) dataToTest.getCookie(EditorCookie.class);
            final StyledDocument doc = (StyledDocument)editorCookie.openDocument();
            editorCookie.open();
            // 1s for inicialization of editor 
            Thread.currentThread().sleep(1000);
            final int num = number;
            RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){
                public void run() {
                    Collection<JEEVerificationProblemMark> problems = (Collection<JEEVerificationProblemMark>) doc.getProperty("jee.problem_scaning.result");
                    if (problems != null){
                        synchronized(problems){
                            for (JEEVerificationProblemMark problem : problems){
                                JEEVerificationHint hints[] = HintsManager.getHintsForProblem(problem);
                                JEEVerificationHint pom=null;
                                if (hints.length>num) pom=hints[num];
                                else if (hints.length>0) pom= hints[hints.length-1];
                                if (hints.length>0){
                                    final JEEVerificationHint hint= pom;
                                    new Thread(new Runnable(){
                                        public void run(){
                                            hint.implement();
                                            try {
                                                Thread.currentThread().sleep(200);
                                            } catch (InterruptedException ex) {ex.printStackTrace();}
                                        }
                                    }).start();
                                    
                                    if (str.length()!=0) new NbDialogOperator(str).ok();
                                    try {
                                        Thread.currentThread().sleep(1000);
                                    } catch (InterruptedException ex) {
                                        ex.printStackTrace(log);
                                    }
                                }
                            }
                        }
                    }else{
                        assertTrue("failedgetRef(). to read 'jee.problem_scaning.result' document property", false);
                    }
                }
            });
            task.schedule(10000);
            task.waitFinished();
            result=doc.getText(0, doc.getLength());
        }catch(Exception e){
            e.printStackTrace(log);
        }
        return result;
    }
    
    
    public void EntityTest(File testedFile, File modifiedFile, int number, String str){// number gives a position of choosen hint
        try{
            FileObject modifiedObject = FileUtil.toFileObject(modifiedFile);
            DataObject modifiedData = DataObject.find(modifiedObject);
            EditorCookie modifiedEditorCookie = (EditorCookie) modifiedData.getCookie(EditorCookie.class);
            StyledDocument doc = (StyledDocument)modifiedEditorCookie.openDocument();
	    modifiedEditorCookie.open();
	    String result = hintTest(testedFile, number, str);
            if (CREATE_GOLDENFILES){
                golden.println(result);
                golden.println(doc.getText(0,doc.getLength()));
            }
            ref.println(result);
            ref.println(doc.getText(0,doc.getLength()));
        }catch(Exception e){
            e.printStackTrace(log);
        }
    }
    
    public void WebServiceTest(File testedFile, String str){
        String result = hintTest(testedFile, 0, str);
        if (CREATE_GOLDENFILES) golden.println(result);
        ref.println(result);
    }
    
    
}

