/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.cmp;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;
import javax.swing.JComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.SchemaElementUtil;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.earproject.ui.LogicalViewProvider;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaTableProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.JavaPersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableProvider;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.multiview.Utils;
import org.netbeans.test.j2ee.multiview.DDTestCase;
import org.openide.actions.SaveAllAction;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;

/**
 *
 * @author jhorvath
 */
public class GenerateEntityClassesTest extends DDTestCase {
    public static final String EJB_PROJECT_NAME = "TestGenerateEntity";
    public static final String EJB_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EJB_PROJECT_NAME;


    
    /** Creates a new instance of GenerateEntityClassesTest */
    public GenerateEntityClassesTest(String testName) {
        super(testName);
    }
    
    
    
    
    protected void setUp() throws Exception {
        super.setUp();
        System.out.println("########  "+getName()+"  #######");
    }
    
    protected void tearDown() throws Exception {
    }
    
    public static Test suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new GenerateEntityClassesTest("testOpenProject"));
        suite.addTest(new GenerateEntityClassesTest("testGenerateBeans"));
        
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        TestRunner.run(suite());
    }
    
    /*
     * Method open project
     *
     */
    public void testOpenProject() throws Exception{
        File projectDir = new File(EJB_PROJECT_PATH);
        project = (Project)J2eeProjectSupport.openProject(projectDir);
        assertNotNull("Project is null.", project);
        Thread.sleep(1000);
       /* 
        EjbJarProject ejbJarProject = (EjbJarProject)project;
        ddFo = ejbJarProject.getAPIEjbJar().getDeploymentDescriptor();  // deployment descriptor
        assertNotNull("ejb-jar.xml FileObject is null.", ddFo);
        
        ejbJar = DDProvider.getDefault().getDDRoot(ddFo);
        
        ddObj = (EjbJarMultiViewDataObject)DataObject.find(ddFo); //MultiView Editor
        assertNotNull("MultiViewDO is null.",ddObj);
        
        EditCookie edit = (EditCookie)ddObj.getCookie(EditCookie.class);
        edit.edit();
        Thread.sleep(1000);
        Utils.waitForAWTDispatchThread();
        **/
    }
    
    public void testGenerateBeans() throws Exception{
        ProgressPanel progressPanel;
        Thread.sleep(4000);
        PersistenceGenerator generator = new JavaPersistenceGenerator();
        FileObject config=project.getProjectDirectory().getFileObject("/src/conf/");
        
        RelatedCMPHelper relatedCMPHelper=new RelatedCMPHelper(project, config, generator);
        FileObject schemaFo=project.getProjectDirectory().getFileObject("/src/conf/testSchema.dbschema");        
        SchemaElement se=SchemaElementUtil.forName(schemaFo);
        
        relatedCMPHelper.setTableSource(se, schemaFo);
        relatedCMPHelper.setPackageName("test");
        
        TableProvider tableProvider = new DBSchemaTableProvider(se, generator);    
        TableClosure tableClosure = new TableClosure(tableProvider);
        tableClosure.setClosureEnabled(false);
        tableClosure.addAllTables();
        Set selected = tableClosure.getSelectedTables();
        System.err.println("*** selected "+selected.size());

        Set available = tableClosure.getAvailableTables();
        System.err.println("*** available "+available.size());
        relatedCMPHelper.setTableClosure(tableClosure);
        
        SourceGroup sourceGroup = ProjectUtils.getSources(project).getSourceGroups("java")[0];
        relatedCMPHelper.setLocation(sourceGroup);
        SelectedTables selectedTables=new SelectedTables(generator, tableClosure, sourceGroup, "test");
        relatedCMPHelper.setSelectedTables(selectedTables);
        
        ProgressHandle handle = ProgressHandleFactory.createHandle("test");
        progressPanel = new ProgressPanel();
        handle.start();
        relatedCMPHelper.buildBeans();
        generator.generateBeans(progressPanel, relatedCMPHelper, schemaFo, handle, false);
        Set created = generator.createdObjects();
        System.err.println("*** created size: "+created.size());
            
        
        handle.finish();
        Thread.sleep(4000);
        
        // save all created files
        SaveAllAction a = (SaveAllAction)SaveAllAction.get(SaveAllAction.class);
        a.performAction();
        
     
        org.netbeans.test.j2ee.lib.Utils utils = new org.netbeans.test.j2ee.lib.Utils(this);
        
        File dbBeansDir = new File(EJB_PROJECT_PATH + File.separator + "src" + File.separator + "java" + File.separator + "test");
        String beanFiles[] = dbBeansDir.list(new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        });
        //if (beanFiles.length != 12)
        //    fail("12 generated db bean files are expected in "+dbBeansDir);
        utils.assertFiles(dbBeansDir, beanFiles, getName()+"_");
        
    }
    
    protected Node getEjbNode(JavaClass beanClass, String ejbName) {
        Project[] allProjects = org.netbeans.modules.j2ee.ejbcore.Utils.getCallableEjbProjects(project);
        for (int i = 0; i < allProjects.length; i++) {
            LogicalViewProvider lvp =
                    (LogicalViewProvider) allProjects[i].getLookup().lookup(LogicalViewProvider.class);
            Node projectView = lvp.createLogicalView();
            Node [] nodes = projectView.getChildren().getNodes();
            for (int j = 0; j < nodes.length; j++) {
                if ("EJBS".equals(nodes[j].getName())) {
                    Node [] ejbs = nodes[j].getChildren().getNodes();
                    for (int k = 0; k < ejbs.length; k++) {
                        System.out.println("*** "+ejbs[k].getName());
                        if (ejbName.equals(ejbs[k].getName())) return ejbs[k];
                    }
                }
            }
        }
        return null;
    }
    
    
    
}
