/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.addmethod;

import java.io.File;
import java.io.IOException;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.*;
import org.netbeans.jemmy.util.PNGEncoder;
import org.netbeans.test.j2ee.*;

/**
 *
 * @author lm97939
 */
public class UseDatabaseTest extends AddMethodBase {
    
    private String name;
    
    /** Creates a new instance of AddMethodTest */
    public UseDatabaseTest(String name) {
        super(name);
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        junit.textui.TestRunner.run(new SendMessageTest("testUseDatabase1InSB"));
    }

    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
    }
    
    public void testUseDatabase1InSB()  throws IOException{
        beanName = "TestingSession";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.Bundle", "LBL_EnterpriseActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.Bundle", "LBL_UseDbAction");
        name = "myTestingDatabase";
        toSearchInEditor = "getMyTestingDatabase";
        isDDModified = true;
        saveFile = true;
        addMethod();
        Node resources = new Node(new ProjectsTabOperator().getProjectRootNode(EJBValidation.EJB_PROJECT_NAME),
                 Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_Node_ResourceNode"));
        new Node(resources,"derby_netPool.sun-resource");
        new Node(resources,"jdbc_"+name+".sun-resource");
    }

    protected void addMethod() throws IOException {
        EditorOperator editor = new EditorWindowOperator().getEditor(beanName+"Bean.java");
        editor.select(11);

        // invoke Add Business Method dialog
        new ActionNoBlock(null,editorPopup).perform(editor);
        NbDialogOperator dialog = new NbDialogOperator(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.Bundle", "LBL_ChooseDatabase"));
        if (name != null) {
            new JTextFieldOperator(dialog).setText(name);
        }
        new JComboBoxOperator(dialog).selectItem("/sample");
        new JCheckBoxOperator(dialog).setSelected(true);
        dialog.ok();
        
        if (saveFile) 
            editor.save();
        
        waitForEditorText(editor, toSearchInEditor);
        
        compareFiles();
    }
    
}
