/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.addmethod;

import java.io.File;
import java.io.IOException;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.*;
import org.netbeans.test.j2ee.*;

/**
 *
 * @author lm97939
 */
public class AddMethodTest extends AddMethodBase {
    
    protected String methodName;
    protected String returnType;
    protected String parameters[][];
    protected String exceptions[];
    protected Boolean remote;
    protected Boolean local;
    
    /** Creates a new instance of AddMethodTest */
    public AddMethodTest(String name) {
        super(name);
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        junit.textui.TestRunner.run(new AddMethodTest("testAddBusinessMethodInSB"));
    }
    
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
    }

    public void testAddBusinessMethod1InSB()  throws IOException{
        beanName = "TestingSession";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddBusinessMethodAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddBusinessMethodAction");
        methodName = "testBusinessMethod1";
        returnType = "String";
        parameters = null;
        exceptions = null;
        remote = Boolean.TRUE;
        local = Boolean.TRUE;
        saveFile = true;
        addMethod();
    }

    public void testAddBusinessMethod2InSB()  throws IOException{
        beanName = "TestingSession";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddBusinessMethodAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddBusinessMethodAction");
        methodName = "testBusinessMethod2";
        returnType = "String";
        parameters = new String[][] {{"String", "a"}, {"int", "b"}};
        exceptions = new String[] { "Exception" };
        remote = Boolean.TRUE;
        local = Boolean.FALSE;
        saveFile = true;
        addMethod();
    }
    
    public void testAddBusinessMethod1InEB()  throws IOException{
        beanName = "TestingEntity";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddBusinessMethodAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddBusinessMethodAction");
        methodName = "testBusinessMethod1";
        returnType = "String";
        parameters = null;
        exceptions = null;
        remote = Boolean.TRUE;
        local = Boolean.TRUE;
        saveFile = true;
        addMethod();
    }

    public void testAddBusinessMethod2InEB()  throws IOException{
        beanName = "TestingEntity";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddBusinessMethodAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddBusinessMethodAction");
        methodName = "testBusinessMethod2";
        returnType = "String";
        parameters = new String[][] {{"String", "a"}, {"boolean", "b"}};
        exceptions = new String[] { "Exception" };
        remote = Boolean.FALSE;
        local = Boolean.TRUE;
        saveFile = true;
        addMethod();
    }
  
   public void testAddCreateMethod1InEB() throws IOException {
        beanName = "TestingEntity";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddCreateMethodAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddCreateMethodAction");
        methodName = "createTest1";
        // Create Method has no return type!!!
        returnType = null;
        parameters = null;
        exceptions = null;
        remote = Boolean.FALSE;
        local = Boolean.TRUE;
        toSearchInEditor = "public String ejbCreateTest1() throws CreateException";
        saveFile = true;
        addMethod();
    }
   
    public void testAddCreateMethod2InEB() throws IOException {
        beanName = "TestingEntity";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddCreateMethodAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddCreateMethodAction");
        methodName = "createTest2";
        // Create Method has no return type!!!
        returnType = null;
        parameters = new String[][] {{"java.lang.String", "a"}, {"int", "b"}};
        exceptions = new String[] { "java.io.IOException" };
        remote = Boolean.TRUE;
        local = Boolean.TRUE;
        toSearchInEditor = "public String ejbCreateTest2(String a, int b) throws CreateException, IOException";
        saveFile = true;                                          
        addMethod();
    }
    
    public void testAddHomeMethod1InEB()  throws IOException{
        beanName = "TestingEntity";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddHomeMethodAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddHomeMethodAction");
        methodName = "homeTestMethod1";
        returnType = "String";
        parameters = null;
        exceptions = null;
        remote = Boolean.TRUE;
        local = Boolean.TRUE;
        toSearchInEditor =  "public String ejbHomeHomeTestMethod1()" ;
        saveFile = true;
        addMethod();
    }

    public void testAddHomeMethod2InEB()  throws IOException{
        beanName = "TestingEntity";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddHomeMethodAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddHomeMethodAction");
        methodName = "homeTestMethod2";
        returnType = "String";
        parameters = new String[][] {{"java.lang.String", "a"}, {"int", "b"}};
        exceptions = new String[] { "java.lang.Exception" };
        remote = Boolean.FALSE;
        local = Boolean.TRUE;
        toSearchInEditor = "public String ejbHomeHomeTestMethod2(String a, int b) throws Exception";
        saveFile = true;
        addMethod();
    }
    
    
    protected void addMethod() throws IOException {
        EditorOperator editor = new EditorWindowOperator().getEditor(beanName+"Bean.java");
        editor.select(11);

        // invoke Add Business Method dialog
        new ActionNoBlock(null,editorPopup).perform(editor);
        NbDialogOperator dialog = new NbDialogOperator(dialogTitle);
        
        new JTextFieldOperator(dialog).setText(methodName);
        if (returnType != null) {
            new JTextFieldOperator(dialog,1).setText(returnType);        
        }
        fillParameters(dialog);
        fillExceptions(dialog);
        
        setRemoteLocalCheckBox(dialog);
        
        dialog.ok();
        if (saveFile) {
            editor.save();
        }
        if (toSearchInEditor == null) {
            toSearchInEditor = computeSeachString();
        }
        waitForEditorText(editor, toSearchInEditor);

        compareFiles();
    }
    
    private String computeSeachString() {
        StringBuffer text = new StringBuffer();
        text.append("public "); 
        if (returnType == null)
            text.append("void");
        else
            text.append(returnType); 
        text.append(" "); text.append(methodName); 
        text.append("(");
        if (parameters != null) {
            for (int i=0; i<parameters.length; i++) {
                if (i>0)
                    text.append(", ");
                text.append(parameters[i][0]); text.append(" "); text.append(parameters[i][1]);
            }
        }
        text.append(")");
        return text.toString();
    }
    
    protected void fillParameters(NbDialogOperator dialog) {
        if (parameters != null) {
            new JTabbedPaneOperator(dialog).selectPage("Parameters");
            for (int i=0; i<parameters.length; i++) {
                new JButtonOperator(dialog,"Add").push();
                NbDialogOperator parameterDialog = new NbDialogOperator("Enter Method Parameter");
                new JTextFieldOperator(parameterDialog,1).setText(parameters[i][0]);
                new JTextFieldOperator(parameterDialog,0).setText(parameters[i][1]);
                parameterDialog.ok();
            }
        }
    }
    
    protected void fillExceptions(NbDialogOperator dialog) {
        if (exceptions != null) {
            new JTabbedPaneOperator(dialog).selectPage("Exceptions");
            for (int i=0; i<exceptions.length; i++) {
                new JButtonOperator(dialog,"Add").push();
                NbDialogOperator exceptionDialog = new NbDialogOperator("Enter Exception");
                new JTextFieldOperator(exceptionDialog).setText(exceptions[i]);
                exceptionDialog.ok();
            }
        }
    }
    
    protected void setRemoteLocalCheckBox(NbDialogOperator dialog) {
        if (remote != null) {
            new JCheckBoxOperator(dialog, "Remote").setSelected(remote.booleanValue());
        }
        if (local != null) {
            new JCheckBoxOperator(dialog, "Local").setSelected(local.booleanValue());
        }
    }
    
}
