/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.addmethod;

import java.io.File;
import java.io.IOException;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.test.j2ee.*;
import org.netbeans.test.j2ee.lib.Utils;

/**
 *
 * @author lm97939
 */
public abstract class AddMethodBase extends JellyTestCase {
    
    protected String beanName;
    protected String editorPopup;
    protected String dialogTitle;
    protected boolean isDDModified = false;
    protected String toSearchInEditor;
    protected boolean saveFile = false;
    
    /** Creates a new instance of AddMethodTest */
    public AddMethodBase(String name) {
        super(name);
    }
    
    protected void waitForEditorText(final EditorOperator editor, final String toSearchInEditor) {
        try {
            new Waiter(new Waitable() {
                    public Object actionProduced(Object obj) {
                        return editor.contains(toSearchInEditor)?Boolean.TRUE:null; 
                    }
                    public String getDescription() {
                        return("Editor contains "+ toSearchInEditor); // NOI18N
                    }
                }).waitAction(null);
        } catch (InterruptedException ie) {
            throw new JemmyException("Interrupted.", ie);
        }
    }
    
    protected void compareFiles() throws IOException {
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        Utils utils = new Utils(this);
        String beanNames[] = { beanName+"Bean.java", 
                               beanName+"Local.java", 
                               beanName+"LocalBusiness.java",
                               beanName+"LocalHome.java", 
                               beanName+"Remote.java", 
                               beanName+"RemoteBusiness.java",
                               beanName+"RemoteHome.java",                      
        };
        utils.assertFiles(new File(EJBValidation.EJB_PROJECT_PATH + File.separator + "src" + File.separator + "java" + File.separator + "test"), beanNames, getName()+"_");
        String ddNames[] = { "ejb-jar.xml", 
                             "sun-ejb-jar.xml"
        };
        utils.assertFiles(new File(EJBValidation.EJB_PROJECT_PATH + File.separator + "src" + File.separator + "conf"), ddNames, isDDModified?getName()+"_":"");

    }
}
