/*
The contents of this file are subject to the terms of the Common Development
and Distribution License (the License). You may not use this file except in
compliance with the License.

You can obtain a copy of the License at http://www.netbeans.org/cddl.html
or http://www.netbeans.org/cddl.txt.

When distributing Covered Code, include this CDDL Header Notice in each file
and include the License file at http://www.netbeans.org/cddl.txt.
If applicable, add the following below the CDDL Header, with the fields
enclosed by brackets [] replaced by your own identifying information:
"Portions Copyrighted [year] [name of copyright owner]"

The Original Software is NetBeans. The Initial Developer of the Original
Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee;

import java.io.File;
import java.io.IOException;
import junit.textui.TestRunner;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.EditorWindowOperator;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author blaha
 */
public class GenerateDTOTest extends JellyTestCase {
    private static String beanName = "TestingEntity";
    private static String dtoName = beanName + "DTO";
    
    //
    public static File getFile(String fileName) {
        String result = EJBValidation.EJB_PROJECT_PATH + File.separator + "src" + File.separator + "java" + File.separator
                + "test" + File.separator + fileName;
        return new File(result);
    }
    
    /** Creates a new instance of GenerateDTOTest */
    public GenerateDTOTest(String name) {
        super(name);
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        TestRunner.run(new GenerateDTOTest("testGenerateDTO"));
        TestRunner.run(new GenerateDTOTest("testDeleteDTO"));
    }
    
    public void testGenerateDTO() throws FileStateInvalidException, IOException {
        Node node = new Node(new ProjectsTabOperator().getProjectRootNode(EJBValidation.EJB_PROJECT_NAME),
                Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node")
                +"|"+beanName);
        node.performPopupAction(org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_GenerateDTOAction"));
        deleteDateAndAuthor(); // delete date and author line
        
        assertFile(getFile(dtoName + ".java"), getGoldenFile(), new File(getWorkDir(),"testGenerateDTO.diff"));
    }
    
    
    public void testDeleteDTO(){
        new org.netbeans.jemmy.EventTool().waitNoEvent(5000);
        Node node = new Node(new ProjectsTabOperator().getProjectRootNode(EJBValidation.EJB_PROJECT_NAME),
                Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjarproject.Bundle", "NAME_src.dir") +
                "|" + "test" + "|" + dtoName + ".java");
        node.performPopupAction(Bundle.getStringTrimmed("org.openide.actions.Bundle", "Delete"));
        new NbDialogOperator(Bundle.getStringTrimmed("org.openide.explorer.Bundle", "MSG_ConfirmDeleteObjectTitle")).yes();
        try{ // check node
            node = new Node(new ProjectsTabOperator().getProjectRootNode(EJBValidation.EJB_PROJECT_PATH),
                    Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjarproject.Bundle", "NAME_src.dir") +
                    "|" + "test" + "|" + dtoName + ".java");
            fail("Node wasn't deleted.");
        }catch(TimeoutExpiredException ex){
            // It's OK.
        }       
        assertFalse("File " + dtoName + ".java isn't deleted.", getFile(dtoName + ".java").exists()); //check file
    }
    
    private void deleteDateAndAuthor(){
        final EditorOperator editor = new EditorWindowOperator().getEditor(dtoName);
        new org.netbeans.jemmy.EventTool().waitNoEvent(3000);
        editor.deleteLine(11); //author
        editor.deleteLine(10); //date
        editor.save();
        editor.close();
    }
    
}
