/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Micro//Systems, Inc. Portions Copyright 1997-2006 Sun
 * Micro//Systems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee;

import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;

public class AppServerTest extends JellyTestCase {
    private static final String SERVERS = Bundle.getString(
            "org.netbeans.modules.j2ee.deployment.impl.ui.Bundle",
            "SERVER_REGISTRY_NODE");
     
    public AppServerTest(String s)    {
        super(s);
    }
    
    /**
     * Checks if Sun Application Server is registered in IDE.
     */
    public void testWaitAppServerInstall() {
        RuntimeTabOperator runtime = new RuntimeTabOperator();
        runtime.getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", 90000);
        new Node(runtime.getRootNode(), SERVERS).expand();
        assertTrue("Didn't find an instance of appserver",
                J2eeProjectSupport.waitForAppServerInstall());
    }
    
    protected void setUp() throws Exception    {
        super.setUp();
    }
    
    protected void tearDown() throws Exception    {
        super.tearDown();
    }
}
