/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui.action;

import gui.LoggingURLDisplayer;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.modules.j2ee.nodes.J2eeServerNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.ProjectRootNode;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.performance.test.utilities.PerformanceTestCase;


/**
 *
 * @author mschovanek@netbeans.org
 */
public class WarmStartup extends PerformanceTestCase {
    private J2eeServerNode serverNode;
    private String projectNodeName;
    private ProjectRootNode projectNode;
    private String appNodePath;
    private long lastOpenTime;    
    /**
     * Creates a new instance of StartServer class
     * @param testName the name of the test
     * @param serverName the server node display name
     */
    public WarmStartup(String testName) {
        super(testName);
        expectedTime = 60000;
        WAIT_AFTER_OPEN=120000;
    }
    
    /**
     * Creates a new instance of StartServer class
     * @param testName the name of the test
     * @param performanceDataName measured values will be saved under this name
     * @param serverName the server node display name
     */
    public WarmStartup(String testName, String perfDataName) {
        super(testName, perfDataName);
        expectedTime = 60000;
        WAIT_AFTER_OPEN=40000;
    }
    
    public void setUp() {
        super.setUp();
        System.out.println("########  "+getName()+"  #######");
    }
    
    // test methods impl
    
    public void testWarmSartupGf() {
        serverNode = J2eeServerNode.invoke("Sun Java System Application Server");
        JTreeOperator tree = ProjectsTabOperator.invoke().tree();
        tree.setComparator(new Operator.DefaultStringComparator(true, true));
        projectNode = new ProjectRootNode(tree, "WarDeployTest");
        String bundle = "org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle";
        appNodePath = Bundle.getStringTrimmed(bundle, "LBL_Applications")+"|"
                +Bundle.getStringTrimmed(bundle, "LBL_WebModules")+"|"
                +projectNode.getText();
        measureTime();
    }
    
    public void testWarmSartupTomcat() {
        serverNode = J2eeServerNode.invoke("Bundled Tomcat");
        JTreeOperator tree = ProjectsTabOperator.invoke().tree();
        tree.setComparator(new Operator.DefaultStringComparator(true, true));
        projectNode = new ProjectRootNode(tree, "WarDeployTomcatTest");
        appNodePath = "Web Applications|"+projectNode.getText();
        measureTime();
    }
    
    // PerformanceTestCase methods implementation
    public void initialize(){
        RuntimeTabOperator.invoke();
        serverNode.start();
        ProjectsTabOperator.invoke();
        projectNode.performPopupAction("Build Project");
        MainWindowOperator mainWindow = MainWindowOperator.getDefault();
        mainWindow.getTimeouts().setTimeout("Waiter.WaitingTime", 120000);
        mainWindow.waitStatusText(
                "Finished building "+projectNode.getText()+" (dist)");
        LoggingURLDisplayer.install(true);
    }

    protected void shutdown() {
        stopServerIfRunning();
    }

    public void prepare() {
        stopServerIfRunning();
        ProjectsTabOperator.invoke();
    }

    public ComponentOperator open() {
        long currentTime = System.currentTimeMillis();
        if (lastOpenTime == 0) {
            lastOpenTime = currentTime;
        } else {
            System.out.println("Last measurement time: "+
                    (currentTime-lastOpenTime)/1000+" s.");
        }
        projectNode.performPopupAction("Run Project");
        return null;
    }
    
    public void close() {
        RuntimeTabOperator.invoke();
        Node appNode = null;
        try {
            appNode = new Node(serverNode, appNodePath);
        } catch (JemmyException e) {
            // log server node info
            String[] childrens = serverNode.getChildren();
            for (Object s : childrens) {
                System.out.println(">> "+s);
            }
            org.openide.nodes.Node ideNode = (org.openide.nodes.Node) serverNode.getOpenideNode();
            org.openide.nodes.Node[] nodes = ideNode.getChildren().getNodes();
            for (Object n : nodes) {
                System.out.println(":: "+n);
            }
            try {
                Thread.currentThread().sleep(10000);
            } catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            throw e;
        }
        appNode.performPopupAction("Undeploy");
        appNode.waitNotPresent();
        serverNode.stop();
        stopServerIfRunning();
    }

    private void stopServerIfRunning() {
        RuntimeTabOperator.invoke();
        serverNode.waitFinished();
        if (!serverNode.isStopped()) {
            serverNode.stop();
        }
    }
}
