/*
 * StartServer.java
 *
 * Created on October 11, 2006, 4:03 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gui.action;

import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.modules.j2ee.actions.RestartAction;
import org.netbeans.jellytools.modules.j2ee.actions.StartAction;
import org.netbeans.jellytools.modules.j2ee.actions.StartDebugAction;
import org.netbeans.jellytools.modules.j2ee.nodes.J2eeServerNode;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.performance.test.utilities.PerformanceTestCase;


/**
 *
 * @author ms113234
 */
public class RestartServer extends PerformanceTestCase {
    private String serverNodeName;
    private Action action;
    private J2eeServerNode serverNode;
    
    /**
     * Creates a new instance of StartServer class
     * @param testName the name of the test
     * @param serverName the server node display name
     */
    public RestartServer(String testName, String serverName) {
        super(testName);
        serverNodeName = serverName;
        expectedTime = 60000;
        WAIT_AFTER_OPEN=240000;
    }
    
    /**
     * Creates a new instance of StartServer class
     * @param testName the name of the test
     * @param performanceDataName measured values will be saved under this name
     * @param serverName the server node display name
     */
    public RestartServer(String testName, String serverName, String performanceDataName) {
        super(testName, performanceDataName);
        serverNodeName = serverName;
        expectedTime = 60000;
        WAIT_AFTER_OPEN=240000;
    }
    
    public void setUp() {
        super.setUp();
        System.out.println("########  "+getName()+"  #######");
    }
    
    // test methods impl
    
    public void testRestartServer() {
        action = new RestartAction();
        measureTime();
    }
    
    // PerformanceTestCase methods implementation
    public void initialize(){
        serverNode = new J2eeServerNode(serverNodeName);
        startServerIfStopped();
    }

    public void prepare() {
    }

    public ComponentOperator open() {
	action.perform(serverNode);
        return null;    
    }
    
    public void close() {
        startServerIfStopped();
    }

    private void startServerIfStopped() {
        serverNode.waitFinished();
        if (!serverNode.isRunning()) {
            serverNode.start();
        }
    }
}
