/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui.action;

import java.util.Calendar;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.actions.EditAction;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.modules.j2ee.nodes.J2eeServerNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.ProjectRootNode;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.performance.test.utilities.PerformanceTestCase;


/**
 *
 * @author mschovanek@netbeans.org
 */
public class RedeployTest extends PerformanceTestCase {
    private J2eeServerNode serverNode;
    private String projectNodeName;
    private ProjectRootNode projectNode;
    private String appNodePath;
    private Modifier modifer;
    
    /**
     * Creates a new instance of RedeployTest class
     * @param testName the name of the test
     * @param serverName the server node display name
     */
    public RedeployTest(String testName) {
        super(testName);
        expectedTime = 60000;
        WAIT_AFTER_OPEN=120000;
    }
    
    /**
     * Creates a new instance of RedeployTest class
     * @param testName the name of the test
     * @param performanceDataName measured values will be saved under this name
     * @param serverName the server node display name
     */
    public RedeployTest(String testName, String perfDataName) {
        super(testName, perfDataName);
        expectedTime = 60000;
        WAIT_AFTER_OPEN=40000;
    }
    
    public void setUp() {
        super.setUp();
        System.out.println("########  "+getName()+"  #######");
    }
    
    ////// test methods //////
    
    public void testRedeployHTMLGf() {
        setupGf();
        modifer = htmlModifier;
        measureTime();
    }
    
    public void testRedeployJSPGf() {
        setupGf();
        modifer = jspModifier;
        measureTime();
    }
    
    public void testRedeployServletGf() {
        setupGf();
        modifer = servletModifier;
        measureTime();
    }
    
    public void testRedeployWebXMLGf() {
        setupGf();
        modifer = webXMLModifier;
        measureTime();
    }
    
    public void testRedeployHTMLTomcat() {
        setupTomcat();
        modifer = htmlModifier;
        measureTime();
    }
    
    public void testRedeployJSPTomcat() {
        setupTomcat();
        modifer = jspModifier;
        measureTime();
    }
    
    public void testRedeployServletTomcat() {
        setupTomcat();
        modifer = servletModifier;
        measureTime();
    }
    
    public void testRedeployWebXMLTomcat() {
        setupTomcat();
        modifer = webXMLModifier;
        measureTime();
    }
    
    private void setupGf() {
        serverNode = J2eeServerNode.invoke("Sun Java System Application Server");
        JTreeOperator tree = ProjectsTabOperator.invoke().tree();
        tree.setComparator(new Operator.DefaultStringComparator(true, true));
        projectNode = new ProjectRootNode(tree, "RedeployGfTest");
        String bundle = "org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle";
        appNodePath = Bundle.getStringTrimmed(bundle, "LBL_Applications")+"|"
                +Bundle.getStringTrimmed(bundle, "LBL_WebModules")+"|"
                +projectNode.getText();
    }
    
    private void setupTomcat() {
        serverNode = J2eeServerNode.invoke("Bundled Tomcat");
        JTreeOperator tree = ProjectsTabOperator.invoke().tree();
        tree.setComparator(new Operator.DefaultStringComparator(true, true));
        projectNode = new ProjectRootNode(tree, "RedeployTomcatTest");
        appNodePath = "Web Applications|"+projectNode.getText();
    }
    
    private Modifier htmlModifier = new Modifier() {
        public void modify() {
            Node idxNode = new Node(projectNode, "Web Pages|index.html");
            new OpenAction().perform(idxNode);
            EditorOperator editor = new EditorOperator("index.html");
            editor.setCaretPosition("#modify", true);
            int line = editor.getLineNumber();
            editor.deleteLine(line);
            editor.setCaretPositionToLine(line);
            editor.insert("<h3>Page modified at: "+getCurTime()+
                    "</h3> <!-- #modify -->\n");
            editor.close(true);
        }
    };
    
    private Modifier jspModifier = new Modifier() {
        public void modify() {
            Node idxNode = new Node(projectNode, "Web Pages|index.jsp");
            new OpenAction().perform(idxNode);
            EditorOperator editor = new EditorOperator("index.jsp");
            editor.setCaretPosition("#modify", true);
            int line = editor.getLineNumber();
            editor.deleteLine(line);
            editor.setCaretPositionToLine(line);
            editor.insert("<h3>Page modified at: "+getCurTime()+
                    "</h3> <!-- #modify -->\n");
            editor.close(true);
        }
    };
    
    private Modifier servletModifier = new Modifier() {
        public void modify() {
            Node servletNode = new Node(projectNode, "Source Packages|test|"+
                    "RedeployServlet.java");
            new OpenAction().perform(servletNode);
            EditorOperator editor = new EditorOperator("RedeployServlet.java");
            editor.setCaretPosition("#modify", true);
            int line = editor.getLineNumber();
            editor.deleteLine(line);
            editor.setCaretPositionToLine(line);
            editor.insert("        out.println(\"<h3>Servlet modified at: "+
                    getCurTime()+"</h3>\"); // #modify\n");
            editor.close(true);
        }
    };
    
    private Modifier webXMLModifier = new Modifier() {
        public void modify() {
            Node webXMLNode = new Node(projectNode, "Web Pages|WEB-INF|web.xml");
            new EditAction().perform(webXMLNode);
            EditorOperator editor = new EditorOperator("web.xml");
            editor.setCaretPosition("#modify", true);
            int line = editor.getLineNumber();
            editor.deleteLine(line);
            editor.setCaretPositionToLine(line);
            editor.insert("            <param-value>"+getCurTime()+
                    "</param-value> <!-- #modify -->\n");
            editor.saveDocument();
            editor.close();
        }
    };
    
    
    ////// PerformanceTestCase methods //////
    
    public void initialize(){
        RuntimeTabOperator.invoke();
        serverNode.start();
        ProjectsTabOperator.invoke();
        projectNode.performPopupAction("Deploy Project");
        MainWindowOperator mainWindow = MainWindowOperator.getDefault();
        mainWindow.getTimeouts().setTimeout("Waiter.WaitingTime", 120000);
        mainWindow.waitStatusText(
                "Finished building "+projectNode.getText()+" (run-deploy)");
    }
    
    public void prepare() {
        modifer.modify();
        ProjectsTabOperator.invoke();
    }
    
    public ComponentOperator open() {
        projectNode.performPopupAction("Deploy Project");
        return null;
    }
    
    public void close() {
    }
    
    public void shutdown() {
        RuntimeTabOperator.invoke();
        Node appNode = new Node(serverNode, appNodePath);
        appNode.performPopupAction("Undeploy");
        appNode.waitNotPresent();
        serverNode.stop();
    }
    
    ////// helper methods //////
    
    private void stopServerIfRunning() {
        RuntimeTabOperator.invoke();
        serverNode.waitFinished();
        if (!serverNode.isStopped()) {
            serverNode.stop();
        }
    }
    
    private String getCurTime() {
        return Calendar.getInstance().getTime().toString();
    }
    
    interface Modifier {
        public void modify();
    }
}
