/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui.action;

import gui.Utils;
import java.io.InputStream;
import java.net.URL;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.modules.j2ee.nodes.J2eeServerNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.ProjectRootNode;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.performance.test.utilities.PerformanceTestCase;


/**
 * Test create projects
 *
 * @author  lmartinek@netbeans.org
 */
public class DeployWebAppGf extends PerformanceTestCase {
    private String projectNodeName = "WarDeployTest";
    private ProjectRootNode projectNode;
    private String serverNodeName = "Sun Java System Application Server";
    private J2eeServerNode serverNode;
    
    /**
     * Creates a new instance of CreateJ2EEProject
     * @param testName the name of the test
     */
    public DeployWebAppGf(String testName) {
        super(testName);
        expectedTime = 60000;
        WAIT_AFTER_OPEN=180000;
    }
    
    /**
     * Creates a new instance of CreateJ2EEProject
     * @param testName the name of the test
     * @param performanceDataName measured values will be saved under this name
     */
    public DeployWebAppGf(String testName, String performanceDataName) {
        super(testName, performanceDataName);
        expectedTime = 60000;
        WAIT_AFTER_OPEN=180000;
    }
    
    public void setUp() {
        super.setUp();
        System.out.println("########  "+getName()+"  #######");
    }

    public void testDeploy() {
        measureTime();
    }
    
    public void initialize() {
        serverNode = J2eeServerNode.invoke(serverNodeName);
        serverNode.start();
        
        JTreeOperator tree = ProjectsTabOperator.invoke().tree();
        tree.setComparator(new Operator.DefaultStringComparator(true, true));
        projectNode = new ProjectRootNode(tree, projectNodeName);
        projectNode.performPopupAction("Build Project");
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 120000);
        MainWindowOperator.getDefault().waitStatusText("Finished building WarDeployTest (dist)");
    }
    
    public void shutdown() {
        String bundle = "org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle";
        RuntimeTabOperator.invoke();
        Node appNode = new Node(serverNode, Bundle.getStringTrimmed(bundle, "LBL_Applications")+"|"
                + Bundle.getStringTrimmed(bundle, "LBL_WebModules")+"|"+projectNodeName);
        appNode.performPopupAction(Bundle.getStringTrimmed(bundle, "LBL_Undeploy"));
        appNode.waitNotPresent();
        
        serverNode.stop();
    }
    
    public void prepare(){
        
    }
    
    public ComponentOperator open(){
        projectNode.performPopupAction("Deploy Project");
        return null;
    }
    
    public void close() {
        MainWindowOperator.getDefault().waitStatusText("Finished building WarDeployTest (run-deploy)");
    }
    
    
}
