/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui;

import gui.action.Deploy;
import gui.action.DeployWebAppGf;
import gui.action.RestartServer;
import gui.action.StartServer;
import org.netbeans.junit.NbTestSuite;

/**
 *
 * @author Martin.Schovanek@sun.com
 */
public class MeasureServerActions {
    
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        String GLASSFISH_NAME = "Sun Java System Application Server";
        String TOMCAT_NAME = "Bundled Tomcat";
        // GlassFish tests
        suite.addTest(new Deploy("testDeploy", "Deploy Enterprise Application"));
        suite.addTest(new DeployWebAppGf("testDeploy", "Deploy Web Application on GlassFish"));
        suite.addTest(new StartServer("testStartServer",GLASSFISH_NAME,
                "Start GlassFish"));
        suite.addTest(new StartServer("testStartServerInDebugMode",GLASSFISH_NAME,
                "Start GlassFish in Debug Mode"));
        suite.addTest(new RestartServer("testRestartServer",GLASSFISH_NAME,
                "Restart GlassFish"));
        // Tomcat tests
        suite.addTest(new StartServer("testStartServer",TOMCAT_NAME,
                "Start Tomcat"));
        suite.addTest(new StartServer("testStartServerInDebugMode",TOMCAT_NAME,
                "Start Tomcat in Debug Mode"));
        suite.addTest(new RestartServer("testRestartServer",TOMCAT_NAME,
                "Restart Tomcat"));
        return suite;
    }
    
}
