/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.netbeans.jemmy.JemmyException;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Lookup;
import org.openide.windows.IOProvider;

/**
 * Designed to replace default URLDisplayer to better serve automated tests
 * requirements.
 *
 * @author Martin.Schovanek@sun.com
 */
public final class LoggingURLDisplayer extends HtmlBrowser.URLDisplayer {
    private static boolean onlySummary = false;
    
    public synchronized void showURL(final URL url) {
        new Thread () {
            public void run() {
                try {
                    URLConnection con = url.openConnection();
                    InputStream is = new BufferedInputStream(con.getInputStream());
                    byte[] buf = new byte[4096];
                    int streamLenght = 0;
                    int x;
                    if (onlySummary) {
                        do {
                            x = is.read(buf);
                            streamLenght += x;
                        } while (x > 0);
                        is.close();
                        String resp = "LoggingURLDisplayer: ("+streamLenght
                                +") bytes received from: "+url;
                        IOProvider.getDefault().getStdOut().println(resp);
                    } else {
                        throw new IllegalStateException("Not implemented yet.");
                    }
                } catch (IOException ex) {
                    System.err.println("Cannot read URL: "+url);
                    ex.printStackTrace();
                }
            }
        }.start();
    }
    
    public static void install(boolean logOnlySummary) {
        onlySummary = logOnlySummary;
        try {
            File file1 = new File(System.getProperty("xtest.workdir")+"/sys/tests/qa-functional/classes"); 
            System.out.println("%%"+file1.list());
            new File(file1, "META-INF/services").mkdirs();
            
            File file = new File(System.getProperty("xtest.workdir")+"/sys/tests/qa-functional/classes" +
                    "/META-INF/services/org.openide.awt.HtmlBrowser$URLDisplayer");
            file.createNewFile();
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(file));
            dout.writeBytes(
                    "#-org.netbeans.core.NbTopManager$NbURLDisplayer\n"+
                    "gui.LoggingURLDisplayer\n");
            dout.close();
        } catch (IOException ex) {
            throw new JemmyException("Cannot register URL displayer.", ex);
        }
        Object displayer = Lookup.getDefault().lookup(HtmlBrowser.URLDisplayer.class);
        if (!displayer.getClass().equals(LoggingURLDisplayer.class)) {
            throw new JemmyException("URL displayer registration failed");
        }
    }
}
