package league.ws;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import league.ejb.entity.PlayerLocal;
import league.ejb.entity.RoundLocal;
import league.util.League;
import league.util.Match;
import league.util.Player;
import league.util.Round;



/**
 * This is the bean class for the LeagueWebService enterprise bean.
 * Created Jun 4, 2005 12:37:36 AM
 * @author jungi
 */
public class LeagueWebServiceBean implements javax.ejb.SessionBean {
    private javax.ejb.SessionContext context;
    
    // <editor-fold defaultstate="collapsed" desc="EJB infrastructure methods. Click the + sign on the left to edit the code.">
    // TODO Add code to acquire and use other enterprise resources (DataSource, JMS, enterprise bean, Web services)
    // TODO Add business methods or web service operations
    /**
     * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
     */
    public void setSessionContext(javax.ejb.SessionContext aContext) {
        context = aContext;
    }
    
    /**
     * @see javax.ejb.SessionBean#ejbActivate()
     */
    public void ejbActivate() {
        
    }
    
    /**
     * @see javax.ejb.SessionBean#ejbPassivate()
     */
    public void ejbPassivate() {
        
    }
    
    /**
     * @see javax.ejb.SessionBean#ejbRemove()
     */
    public void ejbRemove() {
        
    }
    // </editor-fold>
    
    /**
     * See section 7.10.3 of the EJB 2.0 specification
     * See section 7.11.3 of the EJB 2.1 specification
     */
    public void ejbCreate() {
        // TODO implement ejbCreate if necessary, acquire resources
        // This method has access to the JNDI context so resource aquisition
        // spanning all methods can be performed here such as home interfaces
        // and data sources.
    }
    
    
    
    // Add business logic below. (Right-click in editor and choose
    // "EJB Methods > Add Business Method" or "Web Service > Add Operation")

    private league.ejb.session.LeagueFacadeRemote lookupLeagueFacadeBean() {
        try {
            return ((league.ejb.session.LeagueFacadeRemoteHome) league.ejb.CachingServiceLocator.getInstance().getRemoteHome("java:comp/env/ejb/LeagueFacadeBean",league.ejb.session.LeagueFacadeRemoteHome.class)).create();
        } catch(javax.naming.NamingException ne) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ne);
            throw new RuntimeException(ne);
        } catch(javax.ejb.CreateException ce) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ce);
            throw new RuntimeException(ce);
        } catch(java.rmi.RemoteException re) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,re);
            throw new RuntimeException(re);
        }
    }

    /**
     * Web service operation
     */
    public void addTeamToLastPlace(Integer roundId, Integer teamId) {
        // TODO implement operation
        try {
            lookupLeagueFacadeBean().addTeamToLastPlace(roundId, teamId);
        } catch (RemoteException re) {
            
        }
    }

    /**
     * Web service operation
     */
    public String testGroups() {
        // TODO implement operation 
        try {
            return lookupLeagueFacadeBean().testGroups();
        } catch (RemoteException re) {
        }
        return null;
    }

    /**
     * Web service operation
     */
    public void updateMatch(Match m) {
        // TODO implement operation 
        try {
            lookupLeagueFacadeBean().updateMatch(m);
        } catch (RemoteException re) {
        }
    }

    /**
     * Web service operation
     */
    public Integer createMatch(Integer roundId, Hashtable results) {
        try {
            return lookupLeagueFacadeBean().createMatch(roundId, results);
        } catch (RemoteException re) {
        }
        return null;
    }

    /**
     * Web service operation
     */
    public Round getActiveRound(Integer leagueId) {
        try {
            return lookupLeagueFacadeBean().getActiveRound(leagueId);
        } catch (RemoteException re) {
        }
        return null;
    }

    /**
     * Web service operation
     */
    public League createLeague(java.lang.String name, Date startDate, Date endDate, java.lang.String note) {
        try {
            return lookupLeagueFacadeBean().createLeague(name, startDate, endDate, note);
        } catch (RemoteException re) {
        }
        return null;
    }

    /**
     * Web service operation
     */
    public void createRound(Integer leagueId, java.lang.String name, Date startDate) {
        try {
            lookupLeagueFacadeBean().createRound(leagueId, name, startDate);
        } catch (RemoteException re) {
        }
    }

    /**
     * Web service operation
     */
    public Collection getPlayersInRound(RoundLocal rl) {
        try {
            return lookupLeagueFacadeBean().getPlayersInRound(rl);
        } catch (RemoteException re) {
        }
        return null;
    }

    /**
     * Web service operation
     */
    public void setTeamStartPoints(Integer teamId, Integer groupId, Integer startPoints) {
        try {
            lookupLeagueFacadeBean().setTeamStartPoints(teamId, groupId, startPoints);
        } catch (RemoteException re) {
        }
    }

    /**
     * Web service operation
     */
    public Integer createPlayer(java.lang.String name, java.lang.String note, java.lang.String userId) {
        try {
            return lookupLeagueFacadeBean().createPlayer(name, note, userId);
        } catch (RemoteException re) {
        }
        return null;
    }

    /**
     * Web service operation
     */
    public Player getPlayer(PlayerLocal player) {
        return null;
    }
    
    
}
