/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.test;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.*;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.refactoring.*;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.xml.sax.SAXException;
import org.netbeans.modules.j2ee.refactoring.EntityAssociationResolver;

/**
 * Tests for <code>EntityAssociationResolver</code>.
 * @author Erno Mononen
 */
public class EntityAssociationResolverTest extends NbTestCase {
    
    private static final String CUSTOMER_ENTITY_NAME = "Customer.java";
    private static final String ORDER_ENTITY_NAME = "Order.java";
    private static final String DEPARTMENT_ENTITY_NAME = "Department.java";
    private static final String EMPLOYEE_ENTITY_NAME = "Employee.java";
    private static final String USER_ENTITY_NAME = "User.java";
    private static final String GROUP_ENTITY_NAME = "Group.java";
    
    private JavaClass customer;
    private JavaClass order;
    private JavaClass department;
    private JavaClass employee;
    private JavaClass user;
    private JavaClass group;
    
    private List<JavaClass> allEntities;
    
    public EntityAssociationResolverTest(String name){
        super(name);
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite(EntityAssociationResolverTest.class);
        return suite;
    }
    
    protected void setUp() throws Exception {
        super.setUp();
        JMIUtils.beginJmiTransaction(true);
        this.customer = getJavaClass(CUSTOMER_ENTITY_NAME);
        this.order = getJavaClass(ORDER_ENTITY_NAME);
        this.employee = getJavaClass(EMPLOYEE_ENTITY_NAME);
        this.department = getJavaClass(DEPARTMENT_ENTITY_NAME);
        this.user = getJavaClass(USER_ENTITY_NAME);
        this.group = getJavaClass(GROUP_ENTITY_NAME);
        this.allEntities = Arrays.asList(new JavaClass[]{customer, order, employee, department, user, group});
    }
    
    protected void tearDown()throws Exception {
        super.tearDown();
        JMIUtils.endJmiTransaction();
    }
    
    private JavaClass getJavaClass(String name){
        String path = getDataDir().getAbsoluteFile() + "/entities/" + name;
        FileObject fo = FileUtil.toFileObject(new File(path));
        return (JavaClass) JavaModel.getResource(fo).getClassifiers().get(0);
    }
    
    /**
     * Tests that 'mappedBy' references are found when using property based access. 
     */
    public void testGetMappedByReferencesPropertyAccess(){

        EntityAssociationResolver resolver = new EntityAssociationResolver(order, allEntities);
        List<EntityAnnotationReference> refs = resolver.getMappedByReferences(order.getMethod("getCustomer", Collections.EMPTY_LIST, false));
        
        assertEquals(1, refs.size());
        
        EntityAnnotationReference association = refs.get(0);
        
        assertEquals("OneToMany", association.getAnnotation().getTypeName().getName());
        assertEquals("Customer", association.getReferring().getName());
        assertEquals("mappedBy", association.getAttributeValue().getName());
        StringLiteral literal = (StringLiteral) association.getAttributeValue().getValue();
        assertEquals("customer", literal.getValue());
    }
    
    /**
     * Tests that 'mappedBy' references are found when using field based access. 
     */
    public void testGetMappedReferencesFieldAccess(){

        EntityAssociationResolver resolver = new EntityAssociationResolver(user, allEntities);
        List<EntityAnnotationReference> refs = resolver.getMappedByReferences(user.getField("groups", false));
        
        assertEquals(1, refs.size());
        
        EntityAnnotationReference association = refs.get(0);
        
        assertEquals("ManyToMany", association.getAnnotation().getTypeName().getName());
        assertEquals("Group", association.getReferring().getName());
        assertEquals("mappedBy", association.getAttributeValue().getName());
        StringLiteral literal = (StringLiteral) association.getAttributeValue().getValue();
        assertEquals("groups", literal.getValue());
    }
    
    public void testGetMappedByReferencesNotFound(){
        EntityAssociationResolver resolver = new EntityAssociationResolver(order, allEntities);
        List<EntityAnnotationReference> refs = resolver.getMappedByReferences(order.getMethod("getId", Collections.EMPTY_LIST, false));
        assertTrue(refs.isEmpty());
    }
    
    public void testChangeAttributeValue(){
        EntityAssociationResolver resolver = new EntityAssociationResolver(order, allEntities);
        List<EntityAnnotationReference> refs = resolver.getMappedByReferences(order.getMethod("getCustomer", Collections.EMPTY_LIST, false));
        
        assertEquals(1, refs.size());
        
        EntityAnnotationReference association = refs.get(0);
        StringLiteral literal = (StringLiteral) association.getAttributeValue().getValue();
        assertEquals("customer", literal.getValue());
        
        literal.setValue("newValue");
        assertEquals("newValue", literal.getValue());
    }
    
}
