/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.whereused;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponentHandler;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.schema2beans.QName;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.spi.webservices.WebServicesConstants;
import org.netbeans.modules.websvc.wsdl.config.api.Configuration;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public final class WebservicesXmlWhereUsedRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.whereused");   // NOI18N

    /* stores collection of interface refactorings to be invoked */
    ArrayList otherRefactors = new ArrayList();

    public WebservicesXmlWhereUsedRefactoring() { }
    
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, RefactoringElementsBag refactoringElements) {
            
        Problem problem = null;
        if (refObject instanceof JavaClass) {
            
            JavaClass jClass = (JavaClass)refObject;
            err.log("jClass: " + jClass);
            
            String name = jClass.getName();
            err.log("name: " + name);
            Resource res = jClass.getResource();
            err.log("res: " + res);
            
            FileObject fo = JavaModel.getFileObject(res);
            err.log("fo: " + fo);
            Collection wsmodules = Utility.getRelevantWSModules(fo);
            Iterator wsIter = null;

            if (wsmodules != null) {
                wsIter = wsmodules.iterator();
            }
            if (wsIter != null) {
                while (wsIter.hasNext()) {
                    WebServicesSupport wsm = (WebServicesSupport)wsIter.next();
                    if (wsm != null) {              // the class is in a module with web services support

                        FileObject webservicesXmlFO = wsm.getWebservicesDD();
                        Webservices webservicesXmlDD = null;
                        try {
                            webservicesXmlDD = org.netbeans.modules.j2ee.dd.api.webservices.DDProvider.getDefault().getDDRoot(webservicesXmlFO);
                        } catch (IOException ioe) {
                            //ignore
                        }

                        if ((webservicesXmlDD != null) && (webservicesXmlDD.getStatus()!=Webservices.STATE_INVALID_UNPARSABLE)) { 
                            WebserviceDescription[] wservices = webservicesXmlDD.getWebserviceDescription();
                            err.log("Web Services: " + wservices);
                            if ((wservices != null) && (wservices.length > 0)) {
                                for (int w=0; w < wservices.length; w++) {
                                    WebserviceDescription webService = wservices[w];
                                    err.log("Web Service: " + webService);

                                    /* And update the actual web service reference direct in webservices.xml */
                                    PortComponent[] ports = webService.getPortComponent();
                                    err.log("Ports: " + ports);
                                    if ((ports != null) && (ports.length > 0)) for (int p = 0; p < ports.length; p++) {

                                        /* First check for presence in webservices.xml port */
                                        PortComponent portComponent = ports[p];
                                        err.log("Port Component: " + portComponent);
                                        String serviceEndpointInterface = portComponent.getServiceEndpointInterface();
                                        err.log("serviceEndpointInterface: " + serviceEndpointInterface);
                                        if ((serviceEndpointInterface != null) &&
                                                (serviceEndpointInterface.equals(name))) {
                                            RefactoringElementImplementation elem =
                                                    new WebservicesSEIWhereUsedRefactoringElement(webservicesXmlDD,
                                                            name, webservicesXmlFO);
                                            refactoringElements.add(refactoring, elem);
                                        }

                                        // wsdl-port is generated from sei class name as well
                                        QName wsdlPort = portComponent.getWsdlPort();
                                        if (wsdlPort != null) {
                                            String localPart = wsdlPort.getLocalPart();
                                            if (jClass.getSimpleName().concat("Port").equals(localPart)) { //NOI18N
                                                RefactoringElementImplementation elem =
                                                        new WebservicesWsdlPortWhereUsedRefactoringElement(
                                                                webservicesXmlDD, wsdlPort.getPrefix() + ":" + localPart, webservicesXmlFO); //NOI18N
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }

                                        // handlers
                                        PortComponentHandler[] handlers = portComponent.getHandler();
                                        for (int i = 0; i < handlers.length; i++) {
                                            if (name.equals(handlers[i].getHandlerName())) {
                                                RefactoringElementImplementation elem =
                                                        new WebservicesHandlerNameWhereUsedRefactoringElement(
                                                                webservicesXmlDD, name, webservicesXmlFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            if (name.equals(handlers[i].getHandlerClass())) {
                                                RefactoringElementImplementation elem =
                                                        new WebservicesHandlerClassWhereUsedRefactoringElement(
                                                                webservicesXmlDD, name, webservicesXmlFO);
                                                refactoringElements.add(refactoring, elem);
                                            }

                                        }


                                        /* try to locate the local wscompile config file:
                                        *   get project for webservices.xml, get name of the webservice and try to find properties of the type
                                        *   $propertyname-config.name - if found, get the property valu and the path and locate the descriptor,
                                        *   then get the dd api descriptor object
                                        */
                                        String portName = portComponent.getPortComponentName();
                                        Project project = FileOwnerQuery.getOwner(webservicesXmlFO);
                                        Map properties = wsm.getAntProjectHelper().getStandardPropertyEvaluator()
                                                .getProperties();
                                        String propertyName = portName + WebServicesConstants.CONFIG_PROP_SUFFIX;
                                        String propertyValue = (String) properties.get(propertyName);
                                        if (propertyValue != null) { // there's such property in the project
                                            FileObject wsConfigXmlFO;

                                            File f = new File(propertyValue);
                                            if (f.isAbsolute()) {
                                                wsConfigXmlFO = FileUtil.toFileObject(f);
                                            } else {
                                                wsConfigXmlFO =
                                                        project.getProjectDirectory().getFileObject(propertyValue);
                                            }
                                            if (wsConfigXmlFO != null) {
                                                Configuration wsConfigXmlDD;
                                                try {
                                                    wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api
                                                            .DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                                                    org.netbeans.modules.websvc.wsdl.config.api.Service service =
                                                            wsConfigXmlDD.getService();
                                                    if (service != null) {
                                                        org.netbeans.modules.websvc.wsdl.config.api.Interface[] interfaces =
                                                                service.getInterface();
                                                        if ((interfaces != null) && (interfaces.length > 0)) {
                                                            for (int ii = 0; ii < interfaces.length; ii++) {
                                                                org.netbeans.modules.websvc.wsdl.config.api.Interface iface =
                                                                        interfaces[ii];
                                                                String servant = iface.getServantName();
                                                                String iname = iface.getName();
                                                                if ((servant != null) && (servant.equals(name))) {
                                                                    RefactoringElementImplementation elem =
                                                                            new WebservicesConfigXmlServantWhereUsedRefactoringElement(
                                                                                    wsConfigXmlDD, name, wsConfigXmlFO);
                                                                    refactoringElements.add(refactoring, elem);
                                                                }
                                                                if ((iname != null) && (iname.equals(name))) {
                                                                    RefactoringElementImplementation elem =
                                                                            new WebservicesConfigXmlInterfaceWhereUsedRefactoringElement(
                                                                                    wsConfigXmlDD, name, wsConfigXmlFO);
                                                                    refactoringElements.add(refactoring, elem);
                                                                }
                                                            }
                                                        }
                                                    }
                                                } catch (IOException ioe) {
                                                    // ignore
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        } else if (webservicesXmlDD != null) {
                            Problem newProblem = new Problem(false, NbBundle.getMessage(WebservicesXmlWhereUsedRefactoring.class, "TXT_WebservicesXmlWhereUsedInvalidProblem"));
                            problem = Utility.addProblemsToEnd(problem, newProblem);
                        }

                    } // find usages in websvc.xml & wscompile config xml
                }
            }
        } // javaclass
        
        if (refObject instanceof Method) {
            
            Method method = (Method)refObject;
            Resource res = method.getResource();
            FileObject fo = JavaModel.getFileObject(res);
            Collection wsmodules = Utility.getRelevantWSModules(fo);
            Iterator wsIter = wsmodules.iterator();
            String methodName = method.getName();
            ClassDefinition classDef = method.getDeclaringClass(); // get affected class
            
            if ((wsmodules != null) && (wsmodules.size() > 0)) { // there are web/ejb modules that can be affected by the change
                while (wsIter.hasNext()) {
                    WebServicesSupport ws = (WebServicesSupport)wsIter.next();
                    if (ws != null) {
                        FileObject webservicesXmlFO = ws.getWebservicesDD();
                        Webservices webservicesXmlDD = null;
                        try {
                            webservicesXmlDD = org.netbeans.modules.j2ee.dd.api.webservices.DDProvider.getDefault().getDDRoot(webservicesXmlFO);
                        } catch (IOException ioe) {
                            //ignore
                        }

                        if ((webservicesXmlDD != null) && (webservicesXmlDD.getStatus()!=Webservices.STATE_INVALID_UNPARSABLE)) {
                            WebserviceDescription[] wservices = webservicesXmlDD.getWebserviceDescription();
                            err.log("Web Services: " + wservices);
                            if ((wservices != null) && (wservices.length > 0)) {
                                for (int w=0; w < wservices.length; w++) {
                                    WebserviceDescription webService = wservices[w];
                                    err.log("Web Service: " + webService);

                                    PortComponent[] ports = webService.getPortComponent();
                                    err.log("Ports: " + ports);
                                    if ((ports != null) && (ports.length > 0)) {
                                        for (int p=0; p < ports.length; p++) {

                                            /* First check for presence in webservices.xml port */
                                            PortComponent portComponent = ports[p];
                                            err.log("Port Component: " + portComponent);

                                            /* try to locate the local wscompile config file:
                                             *   get project for webservices.xml, get name of the webservice and try to find properties of the type
                                             *   $propertyname-config.name - if found, get the property valu and the path and locate the descriptor,
                                             *   then get the dd api descriptor object
                                             */
                                            String portName = portComponent.getPortComponentName();
                                            Project project = FileOwnerQuery.getOwner(webservicesXmlFO);
                                            Map properties = ws.getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                                            String propertyName = portName + WebServicesConstants.CONFIG_PROP_SUFFIX;
                                            String propertyValue = (String)properties.get(propertyName);

                                            if (propertyValue != null) { // there's such property in the project
                                                FileObject wsConfigXmlFO;

                                                File f = new File(propertyValue);
                                                if (f.isAbsolute()) {
                                                    wsConfigXmlFO = FileUtil.toFileObject(f);
                                                } else {
                                                    wsConfigXmlFO = project.getProjectDirectory().getFileObject(propertyValue);
                                                }
                                                if (wsConfigXmlFO != null) {
                                                    Configuration wsConfigXmlDD = null;
                                                    try {
                                                        wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api.DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                                                    } catch (IOException ioe) {
                                                        //ignore
                                                    }
                                                    if (wsConfigXmlDD != null) {
                                                        org.netbeans.modules.websvc.wsdl.config.api.Service service = wsConfigXmlDD.getService();
                                                        if (service != null) {
                                                            org.netbeans.modules.websvc.wsdl.config.api.Interface[] interfaces = service.getInterface();
                                                            if ((interfaces != null) && (interfaces.length > 0)) {
                                                                for (int ii=0; ii < interfaces.length; ii++) {
                                                                    org.netbeans.modules.websvc.wsdl.config.api.Interface iface = interfaces[ii];
                                                                    String servant = iface.getServantName();
                                                                    String iname = iface.getName();

                                                                    if (classDef.getName().equals(iname)) {
                                                                        JavaClass jcl = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(servant);
                                                                        Method beanMethod = null;
                                                                        if (!(jcl instanceof UnresolvedClass)) {
                                                                            beanMethod = jcl.getMethod(methodName, Utility.getTypedParams(method.getParameters()), false); //NOI18N
                                                                            err.log("beanmethod: " + beanMethod);
                                                                        }
                                                                        WhereUsedQuery whereBeanMethod = new WhereUsedQuery(beanMethod);
                                                                        Problem prob = whereBeanMethod.preCheck();
                                                                        problem = Utility.addProblemsToEnd(problem, prob);
                                                                        otherRefactors.add(whereBeanMethod);

                                                                    } else if (classDef.getName().equals(servant)) {
                                                                        JavaClass jcl = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(iname);
                                                                        Method iMethod = null;
                                                                        if (!(jcl instanceof UnresolvedClass)) {
                                                                            iMethod = jcl.getMethod(methodName, Utility.getTypedParams(method.getParameters()), false); //NOI18N
                                                                            err.log("ifacemethod: " + iMethod);
                                                                        }
                                                                        WhereUsedQuery whereIfaceMethod = new WhereUsedQuery(iMethod);
                                                                        Problem prob = whereIfaceMethod.preCheck();
                                                                        problem = Utility.addProblemsToEnd(problem, prob);
                                                                        otherRefactors.add(whereIfaceMethod);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    } else {
                                                        Problem newProblem = new Problem(false, NbBundle.getMessage(WebservicesXmlWhereUsedRefactoring.class, "TXT_WebservicesXmlWhereUsedInvalidProblem"));
                                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                                        return problem;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } //while
            }
        } // method        
        
        return problem;
    }
    
    public final class WebservicesHandlerClassWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected Webservices webservicesXmlDD;

        public WebservicesHandlerClassWhereUsedRefactoringElement(Webservices webservicesXmlDD, String name, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            return NbBundle.getMessage(WebservicesXmlWhereUsedRefactoring.class,
                    "TXT_WebservicesXmlHandlerClassWhereUsed", name); //NOI18N
        }
    }    

    public final class WebservicesHandlerNameWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected Webservices webservicesXmlDD;

        public WebservicesHandlerNameWhereUsedRefactoringElement(Webservices webservicesXmlDD, String name, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            return NbBundle.getMessage(WebservicesXmlWhereUsedRefactoring.class,
                    "TXT_WebservicesXmlHandlerNameWhereUsed", name); //NOI18N
        }
    }

    public final class WebservicesWsdlPortWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected Webservices webservicesXmlDD;

        public WebservicesWsdlPortWhereUsedRefactoringElement(Webservices webservicesXmlDD, String name, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            return NbBundle.getMessage(WebservicesXmlWhereUsedRefactoring.class,
                    "TXT_WebservicesXmlWsdlPortWhereUsed", name); //NOI18N
        }
    }

    public final class WebservicesSEIWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected Webservices webservicesXmlDD;

        /** Creates a new instance of WebservicesSEIWhereUsedRefactoringElement */
        public WebservicesSEIWhereUsedRefactoringElement(Webservices webservicesXmlDD, String name, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlWhereUsedRefactoring.class, "TXT_WebservicesXmlSEIWhereUsed"), args); //NOI18N
        }
    }

    public final class WebservicesConfigXmlServantWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected Configuration wsConfigXmlDD;

        /** Creates a new instance of WebservicesConfigXmlServantWhereUsedRefactoringElement */
        public WebservicesConfigXmlServantWhereUsedRefactoringElement(Configuration wsConfigXmlDD, String name, FileObject parentFile) { 
            this.wsConfigXmlDD = wsConfigXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlWhereUsedRefactoring.class, "TXT_WebservicesConfigXmlServantWhereUsed"), args); //NOI18N
        }
    }    

    public final class WebservicesConfigXmlInterfaceWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected Configuration wsConfigXmlDD;

        /** Creates a new instance of WebservicesConfigXmlInterfaceWhereUsedRefactoringElement */
        public WebservicesConfigXmlInterfaceWhereUsedRefactoringElement(Configuration wsConfigXmlDD, String name, FileObject parentFile) { 
            this.wsConfigXmlDD = wsConfigXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlWhereUsedRefactoring.class, "TXT_WebservicesConfigXmlInterfaceWhereUsed"), args); //NOI18N
        }
    }
    
}
