/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.whereused;

import java.text.MessageFormat;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringSupport;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class collects usages of classes from jax-ws.xml file.
 * <i>Currently only usages of classes that are implementation classes of 
 * web service from wsdl are collected.</i>. 
 *
 * @author Erno Mononen
 */
public class JaxWsXmlWhereUsedRefactoring extends JaxWsXmlRefactoringSupport {
    
    /**
     * Creates a new instance of JaxWsXmlWhereUsedRefactoring
     */
    public JaxWsXmlWhereUsedRefactoring() {
    }
    
    /**
     * Collects usages of given java class from jax-ws.xml.
     */
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, RefactoringElementsBag refactoringElements) {
        
        if (!(refObject instanceof JavaClass) || !isWebSvcFromWsdl((JavaClass) refObject)){
            return null;
        }
        
        JavaClass javaClass = (JavaClass) refObject;
        
        JaxWsModel model = getModel(javaClass);
        if (model != null && model.findServiceByImplementationClass(javaClass.getName()) != null){
            RefactoringElementImplementation elem = new JaxWsXmlWhereUsedElement(javaClass.getName(), model.getJaxWsFile());
            refactoringElements.add(refactoring, elem);
        }
        
        return null;
        
        
    }
    
    private static class JaxWsXmlWhereUsedElement extends AbstractWhereUsedRefactoringElement {
        
        public JaxWsXmlWhereUsedElement(String name, FileObject parentFile) {
            this.name = name;
            this.parentFile = parentFile;
        }
        
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(JaxWsXmlWhereUsedRefactoring.class, "TXT_JaxWsXmlImplementationClassWhereUsed"), args);
        }
        
    }
}