/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.whereused;

import java.text.MessageFormat;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.refactoring.EntityAssociationResolver;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringSupport;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class collects 'mappedBy' annotation references to classes.
 *
 * @author Erno Mononen
 */
public class EntityWhereUsedRefactoring extends JaxWsXmlRefactoringSupport {
    
    /**
     * Creates a new instance of EntityWhereUsedRefactoring
     */
    public EntityWhereUsedRefactoring() {
    }
    
    /**
     * Collects 'mappedBy' annotations references to the given property.
     */
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, RefactoringElementsBag refactoringElements) {
        
        if (!(refObject instanceof Method || refObject instanceof Field)){
            return null;
        }
        
        Feature property = (Feature) refObject;
        JavaClass javaClass = (JavaClass) property.getDeclaringClass();
        if (!PersistenceRefactoringUtil.isEntity(javaClass)){
            return null;
        }
        EntityAssociationResolver resolver
                = new EntityAssociationResolver(javaClass, PersistenceRefactoringUtil.getEntitiesInProject(javaClass));
        
        for (EntityAnnotationReference reference : resolver.getMappedByReferences(property)) {
            Resource res = reference.getReferring().getResource();
            FileObject fo = JavaModel.getFileObject(res);
            RefactoringElementImplementation elem = new EntityWhereUsedElement(reference, fo);
            refactoringElements.add(refactoring, elem);
            
        }
        
        return null;
    }
    
    private static class EntityWhereUsedElement extends AbstractWhereUsedRefactoringElement {
        
        private EntityAnnotationReference reference;
        
        public EntityWhereUsedElement(EntityAnnotationReference reference, FileObject parentFile) {
            this.reference = reference;
            this.parentFile = parentFile;
        }
        
        public String getDisplayText() {
            Object[] args = new Object [] {reference.getAnnotation().getType().getName(), reference.getReferringProperty().getName()};
            return MessageFormat.format(NbBundle.getMessage(SunJaxWsXmlWhereUsedRefactoring.class, "TXT_EntityWhereUsed"), args);
        }
    }
}