/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.web.taglib.model.FunctionType;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.ValidatorType;
import org.openide.util.NbBundle;

import java.util.List;
import java.util.LinkedList;

/**
 * @author Martin Grebac
 */
public class TldClassSafeDeleteRefactoring extends BaseRefactoring {
    private final Taglib taglib;
    private JavaClass javaClass;

    public TldClassSafeDeleteRefactoring(TldHelper helper, Taglib taglib, JavaClass javaClass) {
        super(helper);
        this.taglib = taglib;
        this.javaClass = javaClass;
    }

    protected Problem preCheckThis() {
        return null;
    }

    protected Problem prepareThis(RefactoringElementsBag refactoringElementsBag) {
        String name = javaClass.getName();
        // tag element
        TagType[] tagTypes = taglib.getTag();
        if ((tagTypes != null) && (tagTypes.length > 0)) {
            for (int tt = 0; tt < tagTypes.length; tt++) {
                TagType tagT = tagTypes[tt];
                String tagClass = tagT.getTagClass();
                if ((tagClass != null) && (tagClass.equals(name))) {
                    helper.addRefactoringElement(refactoringElementsBag, new TaglibTagClassSafeDeleteRefactoringElement(taglib, tagT/*, tld*/));
                }
                String teiClass = tagT.getTeiClass();
                if ((teiClass != null) && (teiClass.equals(name))) {
//                    helper.addRefactoringElement(refactoringElementsBag, TaglibTeiClassSafeDeleteRefactoringElement(taglib, name, tagT, tld));
                }
            }
        }

        FunctionType[] functionTypes = taglib.getFunction();
        if ((functionTypes != null) && (functionTypes.length > 0)) {
            for (int tt = 0; tt < functionTypes.length; tt++) {
                FunctionType functionT = functionTypes[tt];
                String functionClass = functionT.getFunctionClass();
                if ((functionClass != null) && (functionClass.equals(name))) {
//                    helper.addRefactoringElement(refactoringElementsBag, TaglibFunctionClassSafeDeleteRefactoringElement(taglib, name, tagT/*, tld*/));
                }
            }
        }

        // validator element
        ValidatorType validatorType = taglib.getValidator();
        if (validatorType != null) {
            String validatorClass = validatorType.getValidatorClass();
            if ((validatorClass != null) && (validatorClass.equals(name))) {
//                helper.addRefactoringElement(refactoringElementsBag, TaglibValidatorClassSafeDeleteRefactoringElement(taglib, name, tagT/*, tld*/));
            }
        }

        // listener element
        org.netbeans.modules.web.taglib.model.ListenerType[] listenerTypes = taglib.getListener();
        if ((listenerTypes != null) && (listenerTypes.length > 0)) {
            for (int tt = 0; tt < listenerTypes.length; tt++) {
                org.netbeans.modules.web.taglib.model.ListenerType listenerT = listenerTypes[tt];
                String listenerClass = listenerT.getListenerClass();
                if ((listenerClass != null) && (listenerClass.equals(name))) {
//                    helper.addRefactoringElement(refactoringElementsBag, TaglibTagClassSafeDeleteRefactoringElement(taglib, name, tagT/*, tld*/));
                }
            }
        }
        return null;
    }

    public final class TaglibTagClassSafeDeleteRefactoringElement extends AbstractSafeDeleteRefactoringElement implements ExternalChange {

        private TagType tagType = null;

        public TaglibTagClassSafeDeleteRefactoringElement(Taglib taglib, TagType tagType) {
            super(helper.getFileObject());
            this.tagType = tagType;
        }

        /**
         * Returns text describing the refactoring formatted for display (using HTML tags).
         *
         * @return Formatted text.
         */
        public String getDisplayText() {
            return NbBundle.getMessage(TaglibTagClassSafeDeleteRefactoringElement.class, "TXT_TaglibTagClassSafeDelete", tagType.getName());
        }

        /**
         * Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            taglib.removeTag(tagType);
            helper.writeDD();
        }

        public void undoExternalChange() {
            taglib.addTag(tagType);
            helper.writeDD();
        }
    }
}
