/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.refactoring.EntityAssociationResolver;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.rename.AbstractRenameRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class provides support for safely deleting a property that
 * is referred by 'mappedBy' annotation attribute value from
 * other classes.
 *
 * @author Erno Mononen
 */
public class EntitySafeDeleteRefactoring implements J2EERefactoring{
    
    private JavaClass javaClass;
    private Feature property;
    private SafeDeleteRefactoring safeDeleteRefactoring;
    /**
     * Creates a new instance of EntitySafeDeleteRefactoring
     */
    public EntitySafeDeleteRefactoring(JavaClass javaClass, Feature property,
            SafeDeleteRefactoring safeDeleteRefactoring) {
        this.javaClass = javaClass;
        this.property = property;
        this.safeDeleteRefactoring = safeDeleteRefactoring;
    }
    
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        
        if (!PersistenceRefactoringUtil.isEntity(javaClass)){
            return null;
        }
        
        JMIUtils.beginJmiTransaction();
        boolean rollback = true;
        try{
            List allEntities = PersistenceRefactoringUtil.getEntitiesInProject(javaClass);
            EntityAssociationResolver resolver = new EntityAssociationResolver(javaClass, allEntities);
            List<EntityAnnotationReference> references = resolver.getMappedByReferences(property);
            
            for (EntityAnnotationReference elem : references) {
                Resource res = elem.getReferring().getResource();
                FileObject fo = JavaModel.getFileObject(res);
                
                RefactoringElementImplementation refactoringElem =
                        new EntitySafeDeleteRefactoringElement(elem,  fo);
                refactoringElementsBag.add(safeDeleteRefactoring, refactoringElem);
            }
            rollback = false;
        } finally {
            JMIUtils.endJmiTransaction(rollback);
        }
        
        return null;
    }
    
    public Problem preCheck() {
        return null;
    }
    
    public Problem checkParameters() {
        return null;
    }
    
    public Problem fastCheckParameters() {
        return null;
    }
    
    /**
     * Safe delete element for entity annotation.
     */
    private static class EntitySafeDeleteRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        private EntityAnnotationReference reference;
        
        public EntitySafeDeleteRefactoringElement(EntityAnnotationReference reference, FileObject parentFile) {
            this.parentFile = parentFile;
            this.reference = reference;
        }
        
          
        public String getDisplayText() {
            Object[] args = new Object [] {reference.getAnnotation().getType().getName(), reference.getReferringProperty().getName()};
            return MessageFormat.format(NbBundle.getMessage(EntitySafeDeleteRefactoring.class, "TXT_EntitySafeDeleteAnnotation"), args);
        }
        
        public void performExternalChange() {
        }
        
        
        public void undoExternalChange() {
        }
        
        public void performChange() {
            JMIUtils.beginJmiTransaction(true);
            boolean rollback = true;
            try{
                // removes the referencing annotation 
                reference.getReferringProperty().getAnnotations().remove(reference.getAnnotation());
                rollback = false;
            } finally {
                JMIUtils.endJmiTransaction(rollback);
            }
        }
        
        private String getStringValue(AttributeValue attributeValue){
            return ((StringLiteral) attributeValue.getValue()).getValue();
        }
    }
}