/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * BaseRefactoringHelper.java
 *
 * Created on 07 November 2005, 13:45
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;

/**
 *
 * @author Martin Grebac
 */
public abstract class BaseRefactoringHelper {

    private AbstractRefactoring refactoring = null;
    private FileObject fileObject = null;
    
    /** Creates a new instance of BaseRefactoringHelper */
    public BaseRefactoringHelper(AbstractRefactoring refactoring, FileObject fileObject) {
        this.setRefactoring(refactoring);
        this.setFileObject(fileObject);
    }

    public void addRefactoringElement(RefactoringElementsBag refactoringElementsBag, RefactoringElementImplementation refactoringElement) {
        refactoringElementsBag.add(getRefactoring(), refactoringElement);
    }


    public FileObject getFileObject() {
        return fileObject;
    }

    public AbstractRefactoring getRefactoring() {
        return refactoring;
    }

    public void setRefactoring(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public void setFileObject(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public abstract void writeDD();
    
}
