/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.openide.filesystems.FileObject;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Iterator;
import java.io.IOException;
import org.openide.loaders.DataObject;

/**
 * @author pfiala
 */
public class BaseRefactoring implements J2EERefactoring {
    final private Collection childRefactorings = new LinkedList();
    protected BaseRefactoringHelper helper;

    public BaseRefactoring(BaseRefactoringHelper helper) {
        this.helper = helper;
    }

    public void addChildRefactoring(AbstractRefactoring refactoring) {
        childRefactorings.add(refactoring);
    }

    public Problem preCheck() {
        Problem problem = preCheckThis();
        for (Iterator it = childRefactorings.iterator(); it.hasNext();) {
            AbstractRefactoring refactoring = (AbstractRefactoring) it.next();
            problem = Utility.addProblemsToEnd(problem, refactoring.preCheck());
        }
        return problem;
    }

    public Problem checkParameters() {
        Problem problem = checkParametersThis();
        for (Iterator it = childRefactorings.iterator(); it.hasNext();) {
            AbstractRefactoring refactoring = (AbstractRefactoring) it.next();
            problem = Utility.addProblemsToEnd(problem, refactoring.checkParameters());
        }
        return problem;
    }


    public Problem fastCheckParameters() {
        Problem problem = fastCheckParametersThis();
        for (Iterator it = childRefactorings.iterator(); it.hasNext();) {
            AbstractRefactoring refactoring = (AbstractRefactoring) it.next();
            problem = Utility.addProblemsToEnd(problem, refactoring.fastCheckParameters());
        }
        return problem;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Problem problem = prepareThis(refactoringElementsBag);
        final RefactoringSession session = refactoringElementsBag.getSession();
        for (Iterator it = childRefactorings.iterator(); it.hasNext();) {
            AbstractRefactoring refactoring = (AbstractRefactoring) it.next();
            problem = Utility.addProblemsToEnd(problem, refactoring.prepare(session));
        }
        return problem;
    }

    protected Problem preCheckThis() {
        return null;
    }

    protected Problem checkParametersThis() {
        return null;
    }

    protected Problem fastCheckParametersThis() {
        return null;
    }

    protected Problem prepareThis(RefactoringElementsBag refactoringElementsBag) {
        return null;
    }


    public static class EjbHelper extends BaseRefactoringHelper {
        private final EjbJar ejbJar;

        public EjbHelper(AbstractRefactoring refactoring, FileObject fileObject, EjbJar ejbJar) {
            super(refactoring, fileObject);
            this.ejbJar = ejbJar;
        }

        public void writeDD() {
            try {
                ejbJar.write(getFileObject());
            } catch (IOException e) {
                //todo
            }
        }

        public EjbJar getEjbJar() {
            return ejbJar;
        }

    }

    public static class TldHelper extends BaseRefactoringHelper {
        private final Taglib taglib;

        public TldHelper(AbstractRefactoring refactoring, FileObject fileObject, Taglib taglib) {
            super(refactoring, fileObject);
            this.taglib = taglib;
        }

        public void writeDD() {
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(getFileObject());
                if (tdo != null) {
                    tdo.write(taglib);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }

        public Taglib getTaglib() {
            return taglib;
        }
    }
    
}