/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.rename;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponentHandler;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.schema2beans.QName;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.spi.webservices.WebServicesConstants;
import org.netbeans.modules.websvc.wsdl.config.api.Configuration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public final class WebservicesXmlRenameRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");   // NOI18N
    
    /* stores collection of interface refactorings to be invoked */
    ArrayList otherRefactors = new ArrayList();
    
    public WebservicesXmlRenameRefactoring() { }
    
    public Problem preCheck(RefObject refObject) {
        
        Problem problem = null;
        if (refObject instanceof Method) {
            
            Method method = (Method)refObject;
            Resource res = method.getResource();
            FileObject fo = JavaModel.getFileObject(res);
            Collection wsmodules = Utility.getRelevantWSModules(fo);
            Iterator wsIter = wsmodules.iterator();
            String methodName = method.getName();
            ClassDefinition classDef = method.getDeclaringClass(); // get affected class
            
            if ((wsmodules != null) && (wsmodules.size() > 0)) { // there are web/ejb modules that can be affected by the change
                while (wsIter.hasNext()) {
                    WebServicesSupport ws = (WebServicesSupport)wsIter.next();
                    if (ws != null) {
                        FileObject webservicesXmlFO = ws.getWebservicesDD();
                        Webservices webservicesXmlDD = null;
                        try {
                            webservicesXmlDD = org.netbeans.modules.j2ee.dd.api.webservices.DDProvider.getDefault().getDDRoot(webservicesXmlFO);
                        } catch (IOException ioe) {
                            //ignore
                        }
                        
                        if ((webservicesXmlDD != null) && (webservicesXmlDD.getStatus()!=Webservices.STATE_INVALID_UNPARSABLE)) {
                            WebserviceDescription[] wservices = webservicesXmlDD.getWebserviceDescription();
                            err.log("Web Services: " + wservices); //NOI18N
                            if ((wservices != null) && (wservices.length > 0)) {
                                for (int w=0; w < wservices.length; w++) {
                                    WebserviceDescription webService = (WebserviceDescription)wservices[w];
                                    err.log("Web Service: " + webService); //NOI18N
                                    
                                    PortComponent[] ports = webService.getPortComponent();
                                    err.log("Ports: " + ports);
                                    if ((ports != null) && (ports.length > 0)) {
                                        for (int p=0; p < ports.length; p++) {
                                            
                                            /* First check for presence in webservices.xml port */
                                            PortComponent portComponent = (PortComponent)ports[p];
                                            err.log("Port Component: " + portComponent); //NOI18N
                                            
                                            /* try to locate the local wscompile config file:
                                             *   get project for webservices.xml, get name of the webservice and try to find properties of the type
                                             *   $propertyname-config.name - if found, get the property valu and the path and locate the descriptor,
                                             *   then get the dd api descriptor object
                                             */
                                            
                                            String portName = portComponent.getPortComponentName();
                                            Project project = FileOwnerQuery.getOwner(webservicesXmlFO);
                                            Map properties = ws.getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                                            String propertyName = portName + WebServicesConstants.CONFIG_PROP_SUFFIX;
                                            String propertyValue = (String)properties.get(propertyName);
                                            
                                            if (propertyValue != null) { // there's such property in the project
                                                FileObject wsConfigXmlFO = null;
                                                
                                                File f = new File(propertyValue);
                                                if (f.isAbsolute()) {
                                                    wsConfigXmlFO = FileUtil.toFileObject(f);
                                                } else {
                                                    wsConfigXmlFO = project.getProjectDirectory().getFileObject(propertyValue);
                                                }
                                                if (wsConfigXmlFO != null) {
                                                    Configuration wsConfigXmlDD = null;
                                                    try {
                                                        if (wsConfigXmlFO != null) {
                                                            wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api.DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                                                        }
                                                    } catch (IOException ioe) {
                                                        //ignore
                                                    }
                                                    if (wsConfigXmlDD != null) {
                                                        org.netbeans.modules.websvc.wsdl.config.api.Service service = wsConfigXmlDD.getService();
                                                        if (service != null) {
                                                            org.netbeans.modules.websvc.wsdl.config.api.Interface[] interfaces = service.getInterface();
                                                            if ((interfaces != null) && (interfaces.length > 0)) {
                                                                for (int ii=0; ii < interfaces.length; ii++) {
                                                                    org.netbeans.modules.websvc.wsdl.config.api.Interface iface = interfaces[ii];
                                                                    String servant = iface.getServantName();
                                                                    String iname = iface.getName();
                                                                    
                                                                    if (classDef.getName().equals(iname)) {
                                                                        
                                                                        JavaClass jcl = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(servant);
                                                                        Method beanMethod = null;
                                                                        if (!(jcl instanceof UnresolvedClass)) {
                                                                            beanMethod = jcl.getMethod(methodName, Utility.getTypedParams(method.getParameters()), false); //NOI18N
                                                                            err.log("beanmethod: " + beanMethod); //NOI18N
                                                                        }
                                                                        
                                                                        RenameRefactoring renameBeanMethod = new RenameRefactoring(beanMethod);
                                                                        Problem prob = renameBeanMethod.preCheck();
                                                                        problem = Utility.addProblemsToEnd(problem, prob);
                                                                        otherRefactors.add(renameBeanMethod);
                                                                        
                                                                    } else if (classDef.getName().equals(servant)) {
                                                                        
                                                                        JavaClass jcl = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(iname);
                                                                        Method iMethod = null;
                                                                        if (!(jcl instanceof UnresolvedClass)) {
                                                                            iMethod = jcl.getMethod(methodName, Utility.getTypedParams(method.getParameters()), false); //NOI18N
                                                                            err.log("ifacemethod: " + iMethod); //NOI18N
                                                                        }
                                                                        
                                                                        RenameRefactoring renameIfaceMethod = new RenameRefactoring(iMethod);
                                                                        Problem prob = renameIfaceMethod.preCheck();
                                                                        problem = Utility.addProblemsToEnd(problem, prob);
                                                                        otherRefactors.add(renameIfaceMethod);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    } else {
                                                        Problem newProblem = new Problem(false, NbBundle.getMessage(WebservicesXmlRenameRefactoring.class, "TXT_WebservicesConfigXmlRenameInvalidProblem")); //NOI18N
                                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } //while
            }
        } // method
        
        err.log("other refactors: " + otherRefactors);   //NOI18N
        return problem;
    }
    
    public Problem fastCheckParameters(RefObject refObject, String newName) {
        Problem problem = null;
        if (refObject instanceof Method) {
            for (int i=0; i < otherRefactors.size(); i++) {
                RenameRefactoring rr = (RenameRefactoring)otherRefactors.get(i);
                rr.setNewName(newName);
                Problem p = rr.fastCheckParameters();
                problem = Utility.addProblemsToEnd(problem, p);
            }
        }
        return problem;
    }
    
    public Problem checkParameters(RefObject refObject, String newName) {
        return fastCheckParameters(refObject, newName);
    }
    
    /** Find usages in web deployment descriptor: web.xml
     */
    public Problem prepare(AbstractRefactoring refactor, RefObject refObject, String newName, RefactoringElementsBag refactoringElements) {
        
        RefactoringSession session = refactoringElements.getSession();
        Problem problem = null;
        if (refObject instanceof JavaClass) {
            
            JavaClass jClass = (JavaClass)refObject;
            
            String name = jClass.getName();
            err.log("name: " + name); //NOI18N
            
            String newSimpleName = newName;
            err.log("newSimpleName: " + newSimpleName); //NOI18N
            
            newName = name.substring(0, name.lastIndexOf('.') + 1) + newName;
            err.log("newName: " + newName); //NOI18N
            
            Resource res = jClass.getResource();
            FileObject fo = JavaModel.getFileObject(res);
            
            WebServicesSupport wsm = WebServicesSupport.getWebServicesSupport(fo);
            if (wsm != null) {              // the class is in a module with web services support
                
                FileObject webservicesXmlFO = wsm.getWebservicesDD();
                Webservices webservicesXmlDD = null;
                try {
                    webservicesXmlDD = org.netbeans.modules.j2ee.dd.api.webservices.DDProvider.getDefault().getDDRoot(webservicesXmlFO);
                } catch (IOException ioe) {
                    //ignore
                }
                
                if ((webservicesXmlDD != null) && (webservicesXmlDD.getStatus()!=Webservices.STATE_INVALID_UNPARSABLE)) {
                    WebserviceDescription[] wservices = webservicesXmlDD.getWebserviceDescription();
                    err.log("Web Services: " + wservices); //NOI18N
                    if ((wservices != null) && (wservices.length > 0)) {
                        for (int w=0; w < wservices.length; w++) {
                            WebserviceDescription webService = (WebserviceDescription)wservices[w];
                            err.log("Web Service: " + webService); //NOI18N
                            
                            /* And update the actual web service reference direct in webservices.xml */
                            PortComponent[] ports = webService.getPortComponent();
                            err.log("Ports: " + ports);
                            if ((ports != null) && (ports.length > 0)) {
                                for (int p=0; p < ports.length; p++) {
                                    
                                    /* First check for presence in webservices.xml port */
                                    PortComponent portComponent = (PortComponent)ports[p];
                                    err.log("Port Component: " + portComponent); //NOI18N
                                    
                                    // check message handlers
                                    PortComponentHandler[] handlers = portComponent.getHandler();
                                    for (int k = 0; k < handlers.length; k++) {
                                        if (name.equals(handlers[k].getHandlerClass())){
                                            RefactoringElementImplementation elem = new WebservicesHandlerRenameRefactoringElement(webservicesXmlDD, name, newName, handlers[k], webservicesXmlFO);
                                            refactoringElements.add(refactor, elem);
                                        }
                                    }
                                    
                                    // wsdl-port is generated from sei class name as well
                                    QName wsdlPort = portComponent.getWsdlPort();
                                    err.log("WSDL Port: " + wsdlPort); //NOI18N
                                    if (wsdlPort != null) {
                                        String localPart = wsdlPort.getLocalPart();
                                        if (jClass.getSimpleName().concat("Port").equals(localPart)) { //NOI18N
                                            String newLocalPart = newSimpleName.concat("Port"); //NOI18N
                                            QName newPort = new QName(wsdlPort.getNamespaceURI(), newLocalPart, wsdlPort.getPrefix());
                                            RefactoringElementImplementation elem =
                                                    new WebservicesWsdlPortRenameRefactoringElement(
                                                    webservicesXmlDD, wsdlPort, newPort, portComponent, webservicesXmlFO); //NOI18N
                                            refactoringElements.add(refactor, elem);
                                        }
                                    }
                                    
                                    String serviceEndpointInterface = portComponent.getServiceEndpointInterface();
                                    err.log("serviceEndpointInterface: " + serviceEndpointInterface); //NOI18N
                                    if ((serviceEndpointInterface != null) && (serviceEndpointInterface.equals(name))) {
                                        RefactoringElementImplementation elem = new WebservicesSEIRenameRefactoringElement(webservicesXmlDD, name, newName, portComponent, webservicesXmlFO);
                                        refactoringElements.add(refactor, elem);
                                    }
                                    /* try to locate the local wscompile config file:
                                     *   get project for webservices.xml, get name of the webservice and try to find properties of the type
                                     *   $propertyname-config.name - if found, get the property valu and the path and locate the descriptor,
                                     *   then get the dd api descriptor object
                                     */
                                    String portName = portComponent.getPortComponentName();
                                    Project project = FileOwnerQuery.getOwner(webservicesXmlFO);
                                    Map properties = wsm.getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                                    String propertyName = portName + WebServicesConstants.CONFIG_PROP_SUFFIX;
                                    String propertyValue = (String)properties.get(propertyName);
                                    if (propertyValue != null) { // there's such property in the project
                                        FileObject wsConfigXmlFO = null;
                                        
                                        File f = new File(propertyValue);
                                        if (f.isAbsolute()) {
                                            wsConfigXmlFO = FileUtil.toFileObject(f);
                                        } else {
                                            wsConfigXmlFO = project.getProjectDirectory().getFileObject(propertyValue);
                                        }
                                        if (wsConfigXmlFO != null) {
                                            Configuration wsConfigXmlDD = null;
                                            try {
                                                wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api.DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                                            } catch (IOException ioe) {
                                                //ignore
                                            }
                                            if (wsConfigXmlDD != null) {
                                                org.netbeans.modules.websvc.wsdl.config.api.Service service = wsConfigXmlDD.getService();
                                                if (service != null) {
                                                    org.netbeans.modules.websvc.wsdl.config.api.Interface[] interfaces = service.getInterface();
                                                    if ((interfaces != null) && (interfaces.length > 0)) {
                                                        for (int ii=0; ii < interfaces.length; ii++) {
                                                            org.netbeans.modules.websvc.wsdl.config.api.Interface iface = interfaces[ii];
                                                            String servant = iface.getServantName();
                                                            String iname = iface.getName();
                                                            if ((servant != null) && (servant.equals(name))) {
                                                                RefactoringElementImplementation elem = new WebservicesConfigXmlServantRenameRefactoringElement(wsConfigXmlDD, name, newName, iface, wsConfigXmlFO);
                                                                refactoringElements.add(refactor, elem);
                                                            }
                                                            if ((iname != null) && (iname.equals(name))) {
                                                                RefactoringElementImplementation elem = new WebservicesConfigXmlInterfaceRenameRefactoringElement(wsConfigXmlDD, name, newName, iface, wsConfigXmlFO);
                                                                refactoringElements.add(refactor, elem);
                                                            }
                                                        }
                                                    }
                                                }
                                            } else {
                                                Problem newProblem = new Problem(false, NbBundle.getMessage(WebservicesXmlRenameRefactoring.class, "TXT_WebservicesConfigXmlRenameInvalidProblem")); //NOI18N
                                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (webservicesXmlDD != null) {
                    Problem newProblem = new Problem(false, NbBundle.getMessage(WebservicesXmlRenameRefactoring.class, "TXT_WebservicesXmlRenameInvalidProblem")); //NOI18N
                    if (problem == null) {
                        problem = newProblem;
                    } else {
                        if (newProblem != null) problem.setNext(newProblem);
                    }
                }
            } //refactor webservices.xml
        } // javaclass
        
        if (refObject instanceof Method) {
            for (int i=0; i < otherRefactors.size(); i++) {
                RenameRefactoring rr = (RenameRefactoring)otherRefactors.get(i);
                Problem p = rr.prepare(session);
                problem = Utility.addProblemsToEnd(problem, p);
            }
            return problem;
        }
        
        return problem;
    }
    
    public final class WebservicesSEIRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected Webservices webservicesXmlDD;
        private PortComponent portComponent;
        
        /** Creates a new instance of WebservicesSEIRenameRefactoringElement */
        public WebservicesSEIRenameRefactoringElement(Webservices webservicesXmlDD, String oldName, String newName, PortComponent portComponent, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.portComponent = portComponent;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlRenameRefactoring.class, "TXT_WebservicesXmlSEIRename"), args); //NOI18N
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            portComponent.setServiceEndpointInterface(newName);
            try {
                webservicesXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            portComponent.setServiceEndpointInterface(oldName);
            try {
                webservicesXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    /**
     * Rename refactoring element for message handlers.
     */
    public final class WebservicesHandlerRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected Webservices webservicesXmlDD;
        private PortComponentHandler handler;
        
        public WebservicesHandlerRenameRefactoringElement(Webservices webservicesXmlDD, String oldName, String newName, PortComponentHandler handler, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.handler = handler;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlRenameRefactoring.class, "TXT_WebservicesXmlHandlerRename"), args); //NOI18N
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            handler.setHandlerClass(newName);
            write();
        }
        
        public void undoExternalChange() {
            handler.setHandlerClass(oldName);
            write();
        }
        
        private void write(){
            try {
                webservicesXmlDD.write(parentFile);
            } catch (IOException ioe) {
                ErrorManager.getDefault().notify(ioe);
            }
        }
    }
    public final class WebservicesWsdlPortRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected Webservices webservicesXmlDD;
        private PortComponent portComponent;
        
        private QName oldPort;
        private QName newPort;
        
        /** Creates a new instance of WebservicesWsdlPortRenameRefactoringElement */
        public WebservicesWsdlPortRenameRefactoringElement(Webservices webservicesXmlDD, QName oldPort, QName newPort, PortComponent portComponent, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.oldPort = oldPort;
            this.newPort = newPort;
            this.portComponent = portComponent;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            String oldStr = oldPort.getPrefix() + ":" + oldPort.getLocalPart(); //NOI18N
            String newStr = newPort.getPrefix() + ":" + newPort.getLocalPart(); //NOI18N
            
            Object[] args = new Object [] {parentFile.getNameExt(), oldStr, newStr};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlRenameRefactoring.class, "TXT_WebservicesXmlWsdlPortRename"), args); //NOI18N
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            portComponent.setWsdlPort(newPort);
            try {
                webservicesXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            portComponent.setWsdlPort(oldPort);
            try {
                webservicesXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class WebservicesConfigXmlServantRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected Configuration wsConfigXmlDD;
        private org.netbeans.modules.websvc.wsdl.config.api.Interface iface;
        
        /** Creates a new instance of WebservicesConfigXmlServantRenameRefactoringElement */
        public WebservicesConfigXmlServantRenameRefactoringElement(Configuration wsConfigXmlDD, String oldName, String newName, org.netbeans.modules.websvc.wsdl.config.api.Interface iface, FileObject parentFile) {
            this.wsConfigXmlDD = wsConfigXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.iface = iface;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlRenameRefactoring.class, "TXT_WebservicesConfigXmlServantRename"), args); //NOI18N
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            iface.setServantName(newName);
            try {
                wsConfigXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            iface.setServantName(oldName);
            try {
                wsConfigXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class WebservicesConfigXmlInterfaceRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected Configuration wsConfigXmlDD;
        private org.netbeans.modules.websvc.wsdl.config.api.Interface iface;
        
        /** Creates a new instance of WebservicesConfigXmlInterfaceRenameRefactoringElement */
        public WebservicesConfigXmlInterfaceRenameRefactoringElement(Configuration wsConfigXmlDD, String oldName, String newName, org.netbeans.modules.websvc.wsdl.config.api.Interface iface, FileObject parentFile) {
            this.wsConfigXmlDD = wsConfigXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.iface = iface;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlRenameRefactoring.class, "TXT_WebservicesConfigXmlInterfaceRename"), args); //NOI18N
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            iface.setName(newName);
            try {
                wsConfigXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            iface.setName(oldName);
            try {
                wsConfigXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
}
