/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.rename;

import java.text.MessageFormat;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringSupport;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.SunJaxWsXmlElementSupport;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class handles renaming of a webservice endpoint imlementation class
 * in sun-jaxws.xml (handles only webservices from WSDL file, other types
 * of web services are supported through other means).
 *
 * @author Erno Mononen
 */
public class SunJaxWsXmlRenameRefactoring extends JaxWsXmlRefactoringSupport {
    
    /**
     * Creates a new instance of SunJaxWsXmlRenameRefactoring
     */
    public SunJaxWsXmlRenameRefactoring() {
    }
    
    /**
     * Find usages in jax-ws.xml.
     */
    public Problem prepare(AbstractRefactoring refactor, RefObject refObject,
            String newName, RefactoringElementsBag refactoringElements) {
        
        if (!(refObject instanceof JavaClass) || !isWebSvcFromWsdl((JavaClass) refObject)){
            return null;
        }
        
        JavaClass javaClass = (JavaClass) refObject;
        Endpoints model = getEndpointsModel(javaClass);
        if (model == null){
            return null;
        }
        
        FileObject sunjaxwsfile = getSunJaxWsXmlFile(javaClass);
        for (Endpoint each : getEndpoints(javaClass)) {
            RefactoringElementImplementation refactoringElem =
                    new SunJaxWsXmlRenameRefactoringElement(javaClass.getName(), Utility.renameClass(javaClass.getName(), newName), model, each, sunjaxwsfile);
            refactoringElements.add(refactor, refactoringElem);
            
        }
        
        return null;
    }
    
    /**
     * Rename refactoring element for jax-ws.xml
     */
    private static class SunJaxWsXmlRenameRefactoringElement extends SunJaxWsXmlElementSupport {
        
        public SunJaxWsXmlRenameRefactoringElement(String oldName,  String newName,
                Endpoints model, Endpoint endpoint,  FileObject parentFile) {
            super(oldName, newName, model, endpoint, parentFile);
        }
        
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(SunJaxWsXmlRenameRefactoring.class, "TXT_SunJaxWsXmlRename"), args);
        }

    }
    
}
