/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.rename;

import java.text.MessageFormat;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class handles renaming of managed classes listed in persistence.xml.
 *
 * @author Erno Mononen
 */
public class PersistenceXmlRenameRefactoring {
    
    /** Creates a new instance of PersistenceXmlRenameRefactoring */
    public PersistenceXmlRenameRefactoring() {
    }
    
    /**
     * Finds usages in persistence.xml.
     */
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject,
            String newName, RefactoringElementsBag refactoringElements) {
        
        Problem problem = null;
        if (!(refObject instanceof JavaClass)) {
            return null;
        }
        
        JavaClass jClass = (JavaClass)refObject;
        newName = Utility.renameClass(jClass.getName(), newName);
        
        for (FileObject ddFile : PersistenceRefactoringUtil.getPersistence(jClass)) {
            
            PUDataObject dataObject = ProviderUtil.getPUDataObject(ddFile);
            
            if (!ProviderUtil.isValid(dataObject)){
                Problem newProblem = 
                        new Problem(false, NbBundle.getMessage(PersistenceXmlRenameRefactoring.class, "TXT_PersistenceXmlInvalidProblem", ddFile.getPath()));
                problem = Utility.addProblemsToEnd(problem, newProblem);
                continue;
            }

            PersistenceUnit[] persistenceUnits = ProviderUtil.getPersistenceUnits(dataObject);
            
            
            for (int i = 0; i < persistenceUnits.length; i++) {
                PersistenceUnit unit = persistenceUnits[i];
                
                for (int j = 0; j < unit.getClass2().length; j++) {
                    
                    if (unit.getClass2()[j].equals(jClass.getName())){
                        
                        RefactoringElementImplementation refactoringElem =
                                new PersistenceXmlClassRenameRefactoringElement(unit, jClass.getName(), newName, dataObject, ddFile);
                        
                        refactoringElements.add(refactoring, refactoringElem);
                    }
                    
                }
            }
        }
        
        return problem;
    }
    
    /**
     * Rename element for persistence.xml
     */
    private static class PersistenceXmlClassRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        private PersistenceUnit persistenceUnit;
        private PUDataObject puDataObject;
        
        /** Creates a new instance of WebXmlServletRenameRefactoringElement */
        public PersistenceXmlClassRenameRefactoringElement(PersistenceUnit persistenceUnit,
                String oldName,  String newName, PUDataObject puDataObject, FileObject parentFile) {
            this.oldName = oldName;
            this.newName = newName;
            this.persistenceUnit = persistenceUnit;
            this.puDataObject = puDataObject;
            this.parentFile = parentFile;
        }
        
        /**
         * Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(PersistenceXmlRenameRefactoring.class, "TXT_PersistenceXmlRename"), args);
        }
        
        public void performExternalChange() {
            ProviderUtil.renameManagedClass(persistenceUnit, newName, oldName, puDataObject);
        }
        
        public void undoExternalChange() {
            ProviderUtil.renameManagedClass(persistenceUnit, oldName, newName, puDataObject);
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

    }
}
