/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.rename;

import java.io.IOException;
import java.text.MessageFormat;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringElementSupport;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringSupport;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModelProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class handles renaming of a webservice imlementation class
 * in jax-ws.xml (handles only webservices from WSDL file, other types
 * of webservices are supported through other means).
 *
 * @author Erno Mononen
 */
public class JaxWsXmlRenameRefactoring extends JaxWsXmlRefactoringSupport {
    
    /**
     * Creates a new instance of JaxWsXmlRenameRefactoring
     */
    public JaxWsXmlRenameRefactoring() {
    }
    
    /**
     * Find usages in jax-ws.xml.
     */
    public Problem prepare(AbstractRefactoring refactor, RefObject refObject,
            String newName, RefactoringElementsBag refactoringElements) {
        
        if (!(refObject instanceof JavaClass) || !isWebSvcFromWsdl((JavaClass) refObject)){
            return null;
        }
        
        JavaClass javaClass = (JavaClass) refObject;
        
        JaxWsModel model = getModel(javaClass);
        if (model == null){
            return null;
        }
        newName = Utility.renameClass(javaClass.getName(), newName);
        
        Service service = model.findServiceByImplementationClass(javaClass.getName());
        if (service != null){
            RefactoringElementImplementation refactoringElem =
                    new JaxWsXmlRenameRefactoringElement(javaClass.getName(), newName, model, service, model.getJaxWsFile());
            
            refactoringElements.add(refactor, refactoringElem);
        }
        
        return null;
    }
    
    /**
     * Rename refactoring element for jax-ws.xml
     */
    private static class JaxWsXmlRenameRefactoringElement extends JaxWsXmlRefactoringElementSupport {
        
        /**
         * Creates a new instance of JaxWsXmlRenameRefactoringElement
         * @param oldName the fully qualified old name of the implementation class
         * @param newName the fully qualified new name of the implementation class
         * @service the service whose implementation class is to be renamed
         * @parentFile the file object representing jax-ws.xml
         */
        public JaxWsXmlRenameRefactoringElement(String oldName,  String newName,
                JaxWsModel model, Service service, FileObject parentFile) {
            super(oldName, newName, model, service, parentFile);
        }
        
        /**
         * Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(JaxWsXmlRenameRefactoring.class, "TXT_JaxWsXmlRename"), args);
        }
    }
    
}
