/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.rename;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.ExcludeList;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodPermission;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.dd.api.ejb.QueryMethod;
import org.netbeans.modules.j2ee.dd.api.ejb.RelationshipRoleSource;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public final class EjbJarRenameRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");   // NOI18N
 
    /** Whether there is an attempt to rename finder method that is defined in home and in ejb jar.xml*/
    private boolean isCmpHomeFinder = false;

    /** Whether there is an attempt to rename finder method that is defined in local home and in ejb jar.xml*/
    private boolean isCmpLocalHomeFinder = false;

    /** Whether there is an attempt to rename select method in implementation class */
    private boolean isSelectInImpl = false;

    /** Whether there is an attempt to rename finder method in implementation class */
    private boolean isFinderInImpl = false;

    /** Whether there is an attempt to rename finder method in home interface */
    private boolean isFinderInHome = false;

    /** Whether there is an attempt to rename finder method in local home interface */
    private boolean isFinderInLocalHome = false;

    /** Whether there is an attempt to rename create method in implementation class */
    private boolean isCreateInImpl = false;
    
    /** Whether there is an attempt to rename create method in home interface */
    private boolean isCreateInHome = false;

    /** Whether there is an attempt to rename create method in local home interface */
    private boolean isCreateInLocalHome = false;

    /** Whether there is an attempt to rename postCreate method in implementation class */
    private boolean isPostCreateInImpl = false;

    /** Whether there is an attempt to rename home method in implementation class */
    private boolean isHomeInImpl = false;

    /** Whether there is an attempt to rename home method in home interface */
    private boolean isHomeInHome = false;

    /** Whether there is an attempt to rename home method in local home interface */
    private boolean isHomeInLocalHome = false;

    /** Whether there is an attempt to rename getter method in business interface */
    private boolean isGetterInBusiness = false;

    /** Whether there is an attempt to rename setter method in business interface */
    private boolean isSetterInBusiness = false;

    /** Whether there is an attempt to rename getter method in bean impl class */
    private boolean isGetterInImpl = false;

    /** Whether there is an attempt to rename setter method in bean impl class */
    private boolean isSetterInImpl = false;

    /** Whether there is an attempt to rename setter or getter method for cmp field */
    private boolean isCmpField = false;

    /** Whether there is an attempt to rename setter or getter method for cmr field */
    private boolean isCmrField = false;

    /* stores collection of interface refactorings to be invoked */
    ArrayList ifaceRefactors = new ArrayList();
    
    /* stores collection of implementation class refactorings to be invoked */
    ArrayList implRefactors = new ArrayList();

    /** Stores cmp entity bean class that implements business interface that is to be changed*/
    private JavaClass busImpltorClass = null;

    /** Stores resolved class - filled in preCheck */
    private JavaClass javaClass = null;
    
    /** Stores resolved entity impl class - filled in preCheck, this one doesn't change */
    private JavaClass entityClass = null;

    /** Stores collection of potentialy affected modules by proposed change - value filled in preCheck*/
    private Collection emodules = null;
    
    public EjbJarRenameRefactoring() { }
    
    public Problem preCheck(RefObject refObject) {
        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarRenameRefactoring.preCheck( " + refObject + ")");
        ifaceRefactors.clear(); 
        Problem problem = null;
        if (refObject instanceof JavaClass) {
            JavaClass jclass = (JavaClass)refObject;
            Resource res = jclass.getResource();
            FileObject fo = JavaModel.getFileObject(res);
            emodules = Utility.getRelevantEjbModules(fo);
        }
        
        if (refObject instanceof Method) {
            Method method = (Method)refObject;
            Resource res = method.getResource();
            FileObject fo = JavaModel.getFileObject(res);
            emodules = Utility.getRelevantEjbModules(fo);
            if ((emodules != null) && (emodules.size() > 0)) { // there are ejb modules that can be affected by the change
                ClassDefinition jc = method.getDeclaringClass();
                if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("classdefinition jc: " + jc);
                if (jc instanceof JavaClass) {

                    // SESSION BEAN IMPL CLASS
                    javaClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.SESSION_BEAN);
                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("javaclass: " + javaClass);
                    if (!(javaClass instanceof UnresolvedClass)) {
                        if (jc.isSubTypeOf(javaClass)) {

                            // first check if we are trying to rename a method from javax.ejb.SessionBean interface, and do not allow this
                            if (Utility.isSignatureFromSessionBeanInterface(method)) {
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarMethodInJavaxInterfaceProblemRename"), 
                                                new String[] {Utility.SESSION_BEAN}
                                             );
                                Problem newProblem = new Problem(true, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                return problem;
                            }

                            String methodName = method.getName();
                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("methodName: " + methodName);
                            
                            // next check create methods
                            if (methodName.startsWith("ejbCreate")) {
                                // next check if we are trying to rename an ejbCreate method - this change is not allowed
                                if (methodName.equals("ejbCreate")) { //NOI18N
                                    String msg = MessageFormat.format(
                                                    NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarCreateMethodProblemRename"), 
                                                    new String[] {Utility.SESSION_BEAN}
                                                 );
                                    Problem newProblem = new Problem(true, msg);
                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                    return problem;
                                } else { // other create methods can be renamed, too
                                    Method createInHome = Utility.getHomeCreateMethodForSessionImplCreateMethod(method, fo, jc.getName(), false /*not local*/);
                                    Method createInLocalHome = Utility.getHomeCreateMethodForSessionImplCreateMethod(method, fo, jc.getName(), true /*local*/);
                                    if (createInHome != null) {
                                        isCreateInImpl = true;
                                        RenameRefactoring renameCreateInHome = new RenameRefactoring(createInHome);
                                        Problem p = renameCreateInHome.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = MessageFormat.format(
                                                        NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                        new String[] {"home"}
                                                     );
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        ifaceRefactors.add(renameCreateInHome);
                                    }
                                    if (createInLocalHome != null) {
                                        isCreateInImpl = true;
                                        RenameRefactoring renameCreateInLocalHome = new RenameRefactoring(createInLocalHome);
                                        Problem p = renameCreateInLocalHome.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = MessageFormat.format(
                                                        NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                        new String[] {"local home"}
                                                     );
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        ifaceRefactors.add(renameCreateInLocalHome);
                                        return problem;
                                    }
                                }                                
                            }
                            
                            // next check if we are trying to rename some home method - this is allowed with some restrictions and homes in home/localhome need to be renamed, too
                            Method homeInHome = Utility.getHomeHomeMethodForSessionImplHomeMethod(method, fo, jc.getName(), false /*not local*/);
                            Method homeInLocalHome = Utility.getHomeHomeMethodForSessionImplHomeMethod(method, fo, jc.getName(), true /*local*/);
                            if (homeInHome != null) {
                                isHomeInImpl = true;
                                RenameRefactoring renameHomeInHome = new RenameRefactoring(homeInHome);
                                Problem p = renameHomeInHome.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                new String[] {"home"}
                                             );
                                Problem newProblem = new Problem(false, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                ifaceRefactors.add(renameHomeInHome);
                            }
                            if (homeInLocalHome != null) {
                                isHomeInImpl = true;
                                RenameRefactoring renameHomeInLocalHome = new RenameRefactoring(homeInLocalHome);
                                Problem p = renameHomeInLocalHome.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                new String[] {"local home"}
                                             );
                                Problem newProblem = new Problem(false, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                ifaceRefactors.add(renameHomeInLocalHome);
                                return problem;
                            }
                            
                            return problem;
                        }
                    }

                    // ENTITY BEANS IMPL CLASS
                    if (entityClass == null) {
                        entityClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.ENTITY_BEAN);
                    }
                    javaClass = entityClass;
                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("javaclass: " + javaClass);
                    if (!(javaClass instanceof UnresolvedClass)) {
                        // first check if we are trying to rename a method from javax.ejb.EntityBean interface, and do not allow this
                        if (jc.isSubTypeOf(javaClass)) {
                            
                            // first check if we are trying to rename a method from javax.ejb.EntityBean interface, and do not allow this
                            if (Utility.isSignatureFromEntityBeanInterface(method)) {
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarMethodInJavaxInterfaceProblemRename"), 
                                                new String[] {Utility.ENTITY_BEAN}
                                             );
                                Problem newProblem = new Problem(true, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                return problem;
                            }

                            // next check if we are trying to rename an ejbCreate method - this change is not allowed, too
                            String methodName = method.getName();
                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("methodname: " + methodName);
                            
                            // next check create methods
                            if (methodName.startsWith("ejbCreate")) {
                                // next check if we are trying to rename an ejbCreate method - this change is not allowed
                                if (methodName.equals("ejbCreate")) { //NOI18N
                                    String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarCreateMethodProblemRename");
                                    Problem newProblem = new Problem(true, msg);
                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                    return problem;
                                } else { // other create methods can be renamed
                                    Method createInHome = Utility.getHomeCreateMethodForEntityImplCreateMethod(method, fo, jc.getName(), false /*not local*/);
                                    Method createInLocalHome = Utility.getHomeCreateMethodForEntityImplCreateMethod(method, fo, jc.getName(), true /*local*/);
                                    Method postCreateInImpl = Utility.getImplPostCreateMethodForEntityImplCreateMethod(method);
                                    isCreateInImpl = true;
                                    if (createInHome != null) {
                                        RenameRefactoring renameCreateInHome = new RenameRefactoring(createInHome);
                                        Problem p = renameCreateInHome.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = MessageFormat.format(
                                                        NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                        new String[] {"home"}
                                                     );
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        ifaceRefactors.add(renameCreateInHome);
                                    }
                                    if (createInLocalHome != null) {
                                        RenameRefactoring renameCreateInLocalHome = new RenameRefactoring(createInLocalHome);
                                        Problem p = renameCreateInLocalHome.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = MessageFormat.format(
                                                        NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                        new String[] {"local home"}
                                                     );
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        ifaceRefactors.add(renameCreateInLocalHome);
                                    }
                                    if (postCreateInImpl != null) {
                                        RenameRefactoring renamePostCreateInImpl = new RenameRefactoring(postCreateInImpl);
                                        Problem p = renamePostCreateInImpl.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarPostCreateMethodWarningRename");
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        implRefactors.add(renamePostCreateInImpl);
                                        return problem;
                                    }
                                }
                            }

                            // next check postCreate methods
                            if (methodName.startsWith("ejbPostCreate")) {
                                // next check if we are trying to rename an ejbPostCreate method - this change is not allowed
                                if (methodName.equals("ejbPostCreate")) { //NOI18N
                                    String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarPostCreateMethodProblemRename");
                                    Problem newProblem = new Problem(true, msg);
                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                    return problem;
                                } else { // other postCreate methods can be renamed
                                    Method createInHome = Utility.getHomeCreateMethodForEntityImplPostCreateMethod(method, fo, jc.getName(), false /*not local*/);
                                    Method createInLocalHome = Utility.getHomeCreateMethodForEntityImplPostCreateMethod(method, fo, jc.getName(), true /*local*/);
                                    Method createInImpl = Utility.getImplCreateMethodForEntityImplPostCreateMethod(method);
                                    isPostCreateInImpl = true;
                                    if (createInHome != null) {
                                        RenameRefactoring renameCreateInHome = new RenameRefactoring(createInHome);
                                        Problem p = renameCreateInHome.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = MessageFormat.format(
                                                        NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                        new String[] {"home"}
                                                     );
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        ifaceRefactors.add(renameCreateInHome);
                                    }
                                    if (createInLocalHome != null) {
                                        RenameRefactoring renameCreateInLocalHome = new RenameRefactoring(createInLocalHome);
                                        Problem p = renameCreateInLocalHome.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = MessageFormat.format(
                                                        NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                        new String[] {"local home"}
                                                     );
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        ifaceRefactors.add(renameCreateInLocalHome);
                                    }
                                    if (createInImpl != null) {
                                        RenameRefactoring renamePostCreateInImpl = new RenameRefactoring(createInImpl);
                                        Problem p = renamePostCreateInImpl.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarCreateMethodWarningRename");
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        implRefactors.add(renamePostCreateInImpl);
                                        return problem;
                                    }                                     
                                }                                
                            }

                            // next check if we are trying to rename a findByPrimaryKey method - this shouldn't be allowed
                            if (methodName.equals("findByPrimaryKey")) { //NOI18N
                                isFinderInImpl = true;
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarFindByPrimaryKeyMethodProblemRename"), 
                                                new String[] {Utility.ENTITY_BEAN}
                                             );
                                Problem newProblem = new Problem(true, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                return problem;
                            }

                            if (methodName.startsWith("set") && (method.getParameters().size() == 1)) {
                                List typedParams = new ArrayList();
                                Method getMethod = method.getDeclaringClass().getMethod("get" + methodName.substring(3), typedParams,false);
                                if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("getMethod: " + getMethod);
                                if (getMethod != null) {
                                    isSetterInImpl = true;
                                    String fieldName = methodName.substring(3,4).toLowerCase() + methodName.substring(4);
                                    isCmpField = Utility.isCmpField((JavaClass)jc, fieldName);
                                    if (!isCmpField) {
                                        isCmrField = Utility.isCmrField((JavaClass)jc, fieldName);
                                    }
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("fieldName: " + fieldName);
                                    RenameRefactoring renameGetterSetter = new RenameRefactoring(getMethod);
                                    Problem p = renameGetterSetter.preCheck();
//                                    problem = Utility.addProblemsToEnd(problem, p);
                                    Problem newProblem = new Problem(false, NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarSetterMethodWarningRename"));
                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                    ifaceRefactors.add(renameGetterSetter);
                                }
                            }

                            if (methodName.startsWith("get") || method.getParameters().size() == 0) {
                                List typedParams = new ArrayList();
                                typedParams.add(method.getType());
                                Method setMethod = method.getDeclaringClass().getMethod("set" + methodName.substring(3), typedParams,false);
                                if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("setMethod: " + setMethod);
                                if (setMethod != null) {
                                    isGetterInImpl = true;
                                    String fieldName = methodName.substring(3,4).toLowerCase() + methodName.substring(4);
                                    isCmpField = Utility.isCmpField((JavaClass)jc, fieldName);
                                    if (!isCmpField) {
                                        isCmrField = Utility.isCmrField((JavaClass)jc, fieldName);
                                    }
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("fieldName: " + fieldName);
                                    RenameRefactoring renameGetterSetter = new RenameRefactoring(setMethod);
                                    Problem p = renameGetterSetter.preCheck();
//                                    problem = Utility.addProblemsToEnd(problem, p);
                                    Problem newProblem = new Problem(false, NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarGetterMethodWarningRename"));
                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                    ifaceRefactors.add(renameGetterSetter);                                    
                                }
                            }
                            
                            // next check if we are trying to rename some finder method - this is allowed with some restrictions and finders in home/localhome need to be renamed, too
                            Method finderInHome = Utility.getHomeFinderMethodForImplFinderMethod(method, fo, jc.getName(), false /*not local*/);
                            Method finderInLocalHome = Utility.getHomeFinderMethodForImplFinderMethod(method, fo, jc.getName(), true /*local*/);
                            if (finderInHome != null) {
                                isFinderInImpl = true;
                                RenameRefactoring renameFinderInHome = new RenameRefactoring(finderInHome);
                                Problem p = renameFinderInHome.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                new String[] {"home"}
                                             );
                                Problem newProblem = new Problem(false, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                ifaceRefactors.add(renameFinderInHome);
                            }
                            if (finderInLocalHome != null) {
                                isFinderInImpl = true;
                                RenameRefactoring renameFinderInLocalHome = new RenameRefactoring(finderInLocalHome);
                                Problem p = renameFinderInLocalHome.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                new String[] {"local home"}
                                             );
                                Problem newProblem = new Problem(false, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                ifaceRefactors.add(renameFinderInLocalHome);
                                return problem;
                            }

                            // next check if we are trying to rename some home method - this is allowed with some restrictions and homes in home/localhome need to be renamed, too
                            Method homeInHome = Utility.getHomeHomeMethodForEntityImplHomeMethod(method, fo, jc.getName(), false /*not local*/);
                            Method homeInLocalHome = Utility.getHomeHomeMethodForEntityImplHomeMethod(method, fo, jc.getName(), true /*local*/);
                            if (homeInHome != null) {
                                isHomeInImpl = true;
                                RenameRefactoring renameHomeInHome = new RenameRefactoring(homeInHome);
                                Problem p = renameHomeInHome.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                new String[] {"home"}
                                             );
                                Problem newProblem = new Problem(false, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                ifaceRefactors.add(renameHomeInHome);
                            }
                            if (homeInLocalHome != null) {
                                isHomeInImpl = true;
                                RenameRefactoring renameHomeInLocalHome = new RenameRefactoring(homeInLocalHome);
                                Problem p = renameHomeInLocalHome.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                new String[] {"local home"}
                                             );
                                Problem newProblem = new Problem(false, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                ifaceRefactors.add(renameHomeInLocalHome);
                                return problem;
                            }
                            
                            if (methodName.startsWith("ejbSelect")) {
                                isSelectInImpl = true;
                            }
                            
                            return problem;
                        }
                    }

                    // business interface check for CMP setters/getters/field update
                    Collection implementors = ((JavaClass)jc).getImplementors();
                    if ((implementors != null) && (implementors.size() > 0)) {
                        
                        boolean isBusiness = false;
                        Iterator impltors = implementors.iterator();
                        while (impltors.hasNext()) {
                            busImpltorClass = (JavaClass)impltors.next();
                            if (busImpltorClass.isSubTypeOf(entityClass)) {
                                isBusiness = true;
                                break;
                            }
                        }
                        
                        if (isBusiness) {
                            
                            String methodName = method.getName();
                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("methodName: " + methodName);
                            String fieldName = methodName.substring(3,4).toLowerCase() + methodName.substring(4);
                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("fieldName: " + fieldName);

                            isCmpField = Utility.isCmpField(busImpltorClass, fieldName);
                            if (!isCmpField) {
                                isCmrField = Utility.isCmrField(busImpltorClass, fieldName);
                            }
                            if (isCmpField || isCmrField) {                            
                                if (methodName.startsWith("set") && (method.getParameters().size() == 1)) {
                                    List typedParams = new ArrayList();
                                    Method getMethod = method.getDeclaringClass().getMethod("get" + methodName.substring(3), typedParams,false);
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("getMethod: " + getMethod);
                                    if (getMethod != null) {
                                        isSetterInBusiness = true;
                                        RenameRefactoring renameGetterSetter = new RenameRefactoring(getMethod);
                                        Problem p = renameGetterSetter.preCheck();
    //                                    problem = Utility.addProblemsToEnd(problem, p);
                                        Problem newProblem = new Problem(false, NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarSetterMethodWarningRename"));
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        ifaceRefactors.add(renameGetterSetter);
                                    }
                                }
                                if (methodName.startsWith("get") || method.getParameters().size() == 0) {
                                    List typedParams = new ArrayList();
                                    typedParams.add(method.getType());
                                    Method setMethod = method.getDeclaringClass().getMethod("set" + methodName.substring(3), typedParams,false);
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("setMethod: " + setMethod);
                                    if (setMethod != null) {
                                        isGetterInBusiness = true;
                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("fieldName: " + fieldName);
                                        RenameRefactoring renameGetterSetter = new RenameRefactoring(setMethod);
                                        Problem p = renameGetterSetter.preCheck();
    //                                    problem = Utility.addProblemsToEnd(problem, p);
                                        Problem newProblem = new Problem(false, NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarGetterMethodWarningRename"));
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        ifaceRefactors.add(renameGetterSetter);                                    
                                    }
                                }
                            }
                        }
                    }

                    // MESSAGE DRIVEN BEANS IMPL CLASS
                    javaClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.MESSAGE_DRIVEN_BEAN);
                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("javaclass: " + javaClass);
                    if (!(javaClass instanceof UnresolvedClass)) {
                        if (jc.isSubTypeOf(javaClass)) {

                            // first check if we are trying to rename a method from javax.ejb.MessageDrivenBean interface, and do not allow this
                            if (Utility.isSignatureFromMessageDrivenBeanInterface(method)) {
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarMethodInJavaxInterfaceProblemRename"), 
                                                new String[] {Utility.MESSAGE_DRIVEN_BEAN}
                                             );
                                Problem newProblem = new Problem(true, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                return problem;
                            }

                            JavaClass listenClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.MESSAGE_LISTENER);
                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("listenclass: " + listenClass);
                            if (!(listenClass instanceof UnresolvedClass)) {
                                if (jc.isSubTypeOf(listenClass)) {
                                    if (Utility.isSignatureFromMessageListenerInterface(method)) {
                                        String msg = MessageFormat.format(
                                                        NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarMethodInJavaxInterfaceProblemRename"), 
                                                        new String[] {Utility.MESSAGE_LISTENER}
                                                     );
                                        Problem newProblem = new Problem(true, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        return problem;
                                    }
                                }
                            }

                            // next check if we are trying to rename an ejbCreate method - this change is not allowed, too
                            String methodName = method.getName();
                            if (methodName.equals("ejbCreate")) { //NOI18N
                                isCreateInImpl = true;
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarCreateMethodProblemRename"), 
                                                new String[] {Utility.MESSAGE_DRIVEN_BEAN}
                                             );
                                Problem newProblem = new Problem(true, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                return problem;
                            }
                        }
                    }
                    
                    // HOME INTERFACE CLASS
                    javaClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.EJB_HOME);
                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("javaclass: " + javaClass);
                    if (!(javaClass instanceof UnresolvedClass)) {
                        if (jc.isSubTypeOf(javaClass)) {

                            String methodName = method.getName();

                            // next check create methods
                            if (methodName.startsWith("create")) {
                                // next check if we are trying to rename an ejbCreate method - this change is not allowed
                                if (methodName.equals("create")) { //NOI18N
                                    String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarCreateMethodProblemRename");
                                    Problem newProblem = new Problem(true, msg);
                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                    return problem;
                                } else { // other create methods can be renamed
                                    Method createInLocalHome = Utility.getHomeCreateMethodForHomeCreateMethod(method, fo, jc.getName(), true /*local*/);
                                    Method createInImpl = Utility.getImplCreateMethodForHomeCreateMethod(method, fo, jc.getName(), false /*not local*/);
                                    Method postCreateInImpl = Utility.getImplPostCreateMethodForHomeCreateMethod(method, fo, jc.getName(), false /*not local*/);
                                    isCreateInHome = true;
                                    if (createInImpl != null) {
                                        RenameRefactoring renameCreateInHome = new RenameRefactoring(createInImpl);
                                        Problem p = renameCreateInHome.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        implRefactors.add(renameCreateInHome);
                                    }
                                    if (createInLocalHome != null) {
                                        RenameRefactoring renameCreateInLocalHome = new RenameRefactoring(createInLocalHome);
                                        Problem p = renameCreateInLocalHome.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = MessageFormat.format(
                                                        NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                        new String[] {"local home"}
                                                     );
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        ifaceRefactors.add(renameCreateInLocalHome);
                                    }
                                    if (postCreateInImpl != null) {
                                        RenameRefactoring renamePostCreateInImpl = new RenameRefactoring(postCreateInImpl);
                                        Problem p = renamePostCreateInImpl.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarPostCreateMethodWarningRename");
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        implRefactors.add(renamePostCreateInImpl);
                                        return problem;
                                    }
                                }
                            }

                            // next check if we are trying to rename a findByPrimaryKey method - this shouldn't be allowed
                            if (methodName.equals("findByPrimaryKey")) { //NOI18N
                                isFinderInImpl = true;
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarFindByPrimaryKeyMethodProblemRename"), 
                                                new String[] {Utility.ENTITY_BEAN}
                                             );
                                Problem newProblem = new Problem(true, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                return problem;
                            }
                            
                            // next check if we are trying to rename some finder method - this is allowed with some restrictions and finders in implclass/localhome need to be renamed, too
                            Method finderInImpl = Utility.getImplFinderMethodForHomeFinderMethod(method, fo, jc.getName(), false /*not local*/);
                            Method finderInLocalHome = Utility.getHomeFinderMethodForHomeFinderMethod(method, fo, jc.getName(), true /*local*/);
                            if (methodName.startsWith("find")) {
                                isFinderInHome = true;
                                isCmpHomeFinder = true;
                            }
                            if (finderInImpl != null) {
                                RenameRefactoring renameFinderInImpl = new RenameRefactoring(finderInImpl);
                                Problem p = renameFinderInImpl.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                implRefactors.add(renameFinderInImpl);
                            }
                            if (finderInLocalHome != null) {
                                RenameRefactoring renameFinderInLocalHome = new RenameRefactoring(finderInLocalHome);
                                Problem p = renameFinderInLocalHome.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                ifaceRefactors.add(renameFinderInLocalHome);
                            }

                            // next check if we are trying to rename some home method - this is allowed with some restrictions and homes in implclass/localhome need to be renamed, too
                            Method homeInImpl = Utility.getImplHomeMethodForHomeHomeMethod(method, fo, jc.getName(), false /*not local*/);
                            Method homeInLocalHome = Utility.getHomeHomeMethodForHomeHomeMethod(method, fo, jc.getName(), true /*local*/);
                            if (homeInImpl != null) {
                                isHomeInHome = true;
                                RenameRefactoring renameHomeInImpl = new RenameRefactoring(homeInImpl);
                                Problem p = renameHomeInImpl.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                implRefactors.add(renameHomeInImpl);
                            }
                            if (homeInLocalHome != null) {
                                isHomeInHome = true;
                                RenameRefactoring renameHomeInLocalHome = new RenameRefactoring(homeInLocalHome);
                                Problem p = renameHomeInLocalHome.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                ifaceRefactors.add(renameHomeInLocalHome);
                            }
                        }
                    }

                    // LOCAL HOME INTERFACE CLASS
                    javaClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.EJB_LOCAL_HOME);
                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("javaclass: " + javaClass);
                    if (!(javaClass instanceof UnresolvedClass)) {
                        if (jc.isSubTypeOf(javaClass)) {

                            String methodName = method.getName();
                            
                            // next check create methods
                            if (methodName.startsWith("create")) {
                                // next check if we are trying to rename an ejbCreate method - this change is not allowed
                                if (methodName.equals("create")) { //NOI18N
                                    String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarCreateMethodProblemRename");
                                    Problem newProblem = new Problem(true, msg);
                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                    return problem;
                                } else { // other create methods can be renamed
                                    Method createInHome = Utility.getHomeCreateMethodForHomeCreateMethod(method, fo, jc.getName(), false /*local*/);
                                    Method createInImpl = Utility.getImplCreateMethodForHomeCreateMethod(method, fo, jc.getName(), true /*not local*/);
                                    Method postCreateInImpl = Utility.getImplPostCreateMethodForHomeCreateMethod(method, fo, jc.getName(), true /*not local*/);
                                    isCreateInLocalHome = true;
                                    if (createInImpl != null) {
                                        RenameRefactoring renameCreateInHome = new RenameRefactoring(createInImpl);
                                        Problem p = renameCreateInHome.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        implRefactors.add(renameCreateInHome);
                                    }
                                    if (createInHome != null) {
                                        RenameRefactoring renameCreateInHome = new RenameRefactoring(createInHome);
                                        Problem p = renameCreateInHome.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = MessageFormat.format(
                                                        NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarIfaceMethodWarningRename"), 
                                                        new String[] {"home"}
                                                     );
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        ifaceRefactors.add(renameCreateInHome);
                                    }
                                    if (postCreateInImpl != null) {
                                        RenameRefactoring renamePostCreateInImpl = new RenameRefactoring(postCreateInImpl);
                                        Problem p = renamePostCreateInImpl.preCheck();
                                        problem = Utility.addProblemsToEnd(problem, p);
                                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarPostCreateMethodWarningRename");
                                        Problem newProblem = new Problem(false, msg);
                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                        implRefactors.add(renamePostCreateInImpl);
                                        return problem;
                                    }
                                }
                            }

                            // next check if we are trying to rename a findByPrimaryKey method - this shouldn't be allowed
                            if (methodName.equals("findByPrimaryKey")) { //NOI18N
                                isFinderInImpl = true;
                                String msg = MessageFormat.format(
                                                NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarFindByPrimaryKeyMethodProblemRename"), 
                                                new String[] {Utility.ENTITY_BEAN}
                                             );
                                Problem newProblem = new Problem(true, msg);
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                return problem;
                            }

                            // next check if we are trying to rename some finder method - this is allowed with some restrictions and finders in implclass/home need to be renamed, too
                            Method finderInImpl = Utility.getImplFinderMethodForHomeFinderMethod(method, fo, jc.getName(), true /*local*/);
                            Method finderInHome = Utility.getHomeFinderMethodForHomeFinderMethod(method, fo, jc.getName(), false /*not local*/);
                            if (methodName.startsWith("find")) {
                                isFinderInLocalHome = true;
                                isCmpLocalHomeFinder = true;
                            }
                            if (finderInImpl != null) {
                                isFinderInLocalHome = true;
                                RenameRefactoring renameFinderInImpl = new RenameRefactoring(finderInImpl);
                                Problem p = renameFinderInImpl.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                implRefactors.add(renameFinderInImpl);
                            }
                            if (finderInHome != null) {
                                isFinderInLocalHome = true;
                                RenameRefactoring renameFinderInHome = new RenameRefactoring(finderInHome);
                                Problem p = renameFinderInHome.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                ifaceRefactors.add(renameFinderInHome);
                                return problem;
                            }

                            // next check if we are trying to rename some home method - this is allowed with some restrictions and homes in implclass/home need to be renamed, too
                            Method homeInImpl = Utility.getImplHomeMethodForHomeHomeMethod(method, fo, jc.getName(), true /*not local*/);
                            Method homeInHome = Utility.getHomeHomeMethodForHomeHomeMethod(method, fo, jc.getName(), false /*local*/);
                            if (homeInImpl != null) {
                                isHomeInLocalHome = true;
                                RenameRefactoring renameHomeInImpl = new RenameRefactoring(homeInImpl);
                                Problem p = renameHomeInImpl.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                implRefactors.add(renameHomeInImpl);
                            }
                            if (homeInHome != null) {
                                isHomeInLocalHome = true;
                                RenameRefactoring renameHomeInHome = new RenameRefactoring(homeInHome);
                                Problem p = renameHomeInHome.preCheck();
                                problem = Utility.addProblemsToEnd(problem, p);
                                ifaceRefactors.add(renameHomeInHome);
                                return problem;
                            }
                            return problem;
                        }
                    }
                }
            }
        }
        return problem;
    }

    public Problem fastCheckParameters(RefObject refObject, String newName) {
        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarRenameRefactoring.fastCheckParameters( " + refObject + "," + newName + " )");
        Problem problem = null;
        if (refObject instanceof Method) {
            if (isFinderInImpl) {
                // rename of finder method in imlementation class was invoked
                for (int i=0; i < ifaceRefactors.size(); i++) {
                    RenameRefactoring rr = (RenameRefactoring)ifaceRefactors.get(i);
                    String name = "find" + newName.substring(7); // remove 'ejbFind' from start NOI18N
                    rr.setNewName(name);
                    Problem p = rr.fastCheckParameters();
                    problem = Utility.addProblemsToEnd(problem, p);
                }
                if ((javaClass != null) && !(javaClass instanceof UnresolvedClass)) {
                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("resolved class: " + javaClass);
                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("finder method in impl class");
                    if (!newName.startsWith("ejbFind")) { //NOI18N
                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarFinderMethodFastCheckProblemRename");
                        Problem newProblem = new Problem(true, msg);
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                    }
                }
            }
            if (isSelectInImpl) {
                if (!newName.startsWith("ejbSelect")) {
                    if ((javaClass != null) && !(javaClass instanceof UnresolvedClass)) {
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("resolved class: " + javaClass);
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("select method in impl class");
                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarSelectMethodFastCheckProblemRename");
                        Problem newProblem = new Problem(true, msg);
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                    }
                }
            }
            if (isCreateInImpl) {
                if ((newName.length() >= 9) && (newName.startsWith("ejbCreate"))) {
                    // rename of create method in imlementation class was invoked
                    for (int i=0; i < ifaceRefactors.size(); i++) {
                        RenameRefactoring rr = (RenameRefactoring)ifaceRefactors.get(i);
                        String name = "create" + newName.substring(9); // NOI18N remove 'ejbCreate' from start 
                        rr.setNewName(name);
                        Problem p = rr.fastCheckParameters();
                        problem = Utility.addProblemsToEnd(problem, p);
                    }
                    for (int l=0; l < implRefactors.size(); l++) {
                        RenameRefactoring rr = (RenameRefactoring)implRefactors.get(l);
                        String name = "ejbPostCreate" + newName.substring(9); // NOI18N remove 'ejbCreate' from start 
                        rr.setNewName(name);
                        Problem p = rr.fastCheckParameters();
                        problem = Utility.addProblemsToEnd(problem, p);
                    }
                } else {
                    if ((javaClass != null) && !(javaClass instanceof UnresolvedClass)) {
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("resolved class: " + javaClass);
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("create method in impl class");
                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarCreateMethodFastCheckProblemRename");
                        Problem newProblem = new Problem(true, msg);
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                    }
                }
            }
            if ((isCreateInHome) || (isCreateInLocalHome)) {
                // rename of create method in home or local home interface was invoked
                if ((newName.length() >= 6) && (newName.startsWith("create"))) {
                    String name = "ejb" + newName.substring(0,1).toUpperCase() + newName.substring(1); //NOI18N
                    for (int i=0; i < ifaceRefactors.size(); i++) {
                        RenameRefactoring rr = (RenameRefactoring)ifaceRefactors.get(i);
                        rr.setNewName(newName);
                        Problem p = rr.fastCheckParameters();
                        problem = Utility.addProblemsToEnd(problem, p);
                    }
                    for (int l=0; l < implRefactors.size(); l++) {
                        RenameRefactoring rr = (RenameRefactoring)implRefactors.get(l);
                        if (((Method)rr.getRefactoredObject()).getName().startsWith("ejbPostCreate")) {
                            String n = "ejbPost" + newName.substring(0,1).toUpperCase() + newName.substring(1); //NOI18N
                            rr.setNewName(n);
                        } else {
                            rr.setNewName(name);
                        }
                        Problem p = rr.fastCheckParameters();
                        problem = Utility.addProblemsToEnd(problem, p);
                    }
                } else {
                    if ((javaClass != null) && !(javaClass instanceof UnresolvedClass)) {
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("resolved class: " + javaClass);
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("create method in home/localhome");
                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarHomeCreateMethodFastCheckProblemRename");
                        Problem newProblem = new Problem(true, msg);
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                    }
                }
            }
            if (isPostCreateInImpl) {
                if ((newName.length() >= 13) && (newName.startsWith("ejbPostCreate"))) {
                    // rename of postCreate method in imlementation class was invoked
                    for (int i=0; i < ifaceRefactors.size(); i++) {
                        RenameRefactoring rr = (RenameRefactoring)ifaceRefactors.get(i);
                        String name = "create" + newName.substring(13); // NOI18N remove 'ejbPostCreate' from start 
                        rr.setNewName(name);
                        Problem p = rr.fastCheckParameters();
                        problem = Utility.addProblemsToEnd(problem, p);
                    }
                    for (int l=0; l < implRefactors.size(); l++) {
                        RenameRefactoring rr = (RenameRefactoring)implRefactors.get(l);
                        String name = "ejbCreate" + newName.substring(13); // NOI18N remove 'ejbPostCreate' from start 
                        rr.setNewName(name);
                        Problem p = rr.fastCheckParameters();
                        problem = Utility.addProblemsToEnd(problem, p);
                    }
                } else {
                    if ((javaClass != null) && !(javaClass instanceof UnresolvedClass)) {
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("resolved class: " + javaClass);
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("postCreate method in impl class");
                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarPostCreateMethodFastCheckProblemRename");
                        Problem newProblem = new Problem(true, msg);
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                    }
                }
            }
            if ((isFinderInHome) || (isFinderInLocalHome)) {
                // rename of finder method in home or local home interface was invoked
                if ((newName.length() > 4) && (newName.startsWith("find"))) {
                    String name = "ejb" + newName.substring(0,1).toUpperCase() + newName.substring(1); //NOI18N
                    for (int i=0; i < ifaceRefactors.size(); i++) {
                        RenameRefactoring rr = (RenameRefactoring)ifaceRefactors.get(i);
                        rr.setNewName(newName);
                        Problem p = rr.fastCheckParameters();
                        problem = Utility.addProblemsToEnd(problem, p);
                    }
                    for (int l=0; l < implRefactors.size(); l++) {
                        RenameRefactoring rr = (RenameRefactoring)implRefactors.get(l);
                        rr.setNewName(name);
                        Problem p = rr.fastCheckParameters();
                        problem = Utility.addProblemsToEnd(problem, p);
                    }
                } else {
                    if ((javaClass != null) && !(javaClass instanceof UnresolvedClass)) {
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("resolved class: " + javaClass);
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("finder method in home/localhome");
                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarHomeFinderMethodFastCheckProblemRename");
                        Problem newProblem = new Problem(true, msg);
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                    }
                }
            }
            if ((isHomeInHome) || (isHomeInLocalHome)) {
                // rename of home method in home or local home interface was invoked
                String name = "ejbHome" + newName.substring(0,1).toUpperCase() + newName.substring(1); //NOI18N
                for (int i=0; i < ifaceRefactors.size(); i++) {
                    RenameRefactoring rr = (RenameRefactoring)ifaceRefactors.get(i);
                    rr.setNewName(newName);
                    Problem p = rr.fastCheckParameters();
                    problem = Utility.addProblemsToEnd(problem, p);
                }
                for (int l=0; l < implRefactors.size(); l++) {
                    RenameRefactoring rr = (RenameRefactoring)implRefactors.get(l);
                    rr.setNewName(name);
                    String oldName = ((Method)rr.getRefactoredObject()).getName();
                    if (!(name.equals(oldName))) {
                        Problem p = rr.fastCheckParameters();
                        problem = Utility.addProblemsToEnd(problem, p);
                    }
                }
            }
            if (isHomeInImpl) {
                // rename of home method in imlementation class was invoked
                if ((newName.length() > 7) && (newName.startsWith("ejbHome"))) {
                    String name = newName.substring(7,8).toLowerCase() + newName.substring(8); // remove ejbHome from the string
                    for (int i=0; i < ifaceRefactors.size(); i++) {
                        RenameRefactoring rr = (RenameRefactoring)ifaceRefactors.get(i);
                        rr.setNewName(name);
                        Problem p = rr.fastCheckParameters();
                        problem = Utility.addProblemsToEnd(problem, p);
                    }
                }  else {
                    if ((javaClass != null) && !(javaClass instanceof UnresolvedClass)) {
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("resolved class: " + javaClass);
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("home method in impl class");
                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarHomeMethodFastCheckProblemRename");
                        Problem newProblem = new Problem(true, msg);
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                    }
                }
            }
            if (isGetterInBusiness || isGetterInImpl) {
                if (newName.length() > 3) {
                    if (!newName.startsWith("get")) {
                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarGetterMethodFastCheckProblemRename");
                        Problem newProblem = new Problem(true, msg);
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                    }
                } else {
                    String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarGetterMethodFastCheckProblemRename");
                    Problem newProblem = new Problem(true, msg);
                    problem = Utility.addProblemsToEnd(problem, newProblem);
                }
            }
            if (isSetterInBusiness || isSetterInImpl) {
                if (newName.length() > 3) {
                    if (!newName.startsWith("set")) { // NOI18N
                        String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarSetterMethodFastCheckProblemRename");
                        Problem newProblem = new Problem(true, msg);
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                    }
                } else {
                    String msg = NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarSetterMethodFastCheckProblemRename");
                    Problem newProblem = new Problem(true, msg);
                    problem = Utility.addProblemsToEnd(problem, newProblem);
                }
            }
        }
        return problem;
    }

    public Problem checkParameters(RefObject refObject, String newName) {
        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarRenameRefactoring.checkParameters( " + refObject + "," + newName + " )");
        return fastCheckParameters(refObject, newName);
    }
    
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, String newName, RefactoringElementsBag refactoringElements) {
        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarRenameRefactoring.prepare( " + refactoring + ", " + refObject + "," + newName + ", " + refactoringElements + " )");
        RefactoringSession session = refactoringElements.getSession();
        Problem problem = null;
                
        if (refObject instanceof JavaClass) {
            
            JavaClass jClass = (JavaClass)refObject;
            
            String name = jClass.getName();
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("name: " + name);

            newName = name.substring(0, name.lastIndexOf('.') + 1) + newName;
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("newName: " + newName);
            
            Iterator emIter = null;

            if (emodules != null) {
                emIter = emodules.iterator();
            }
            if (emIter != null) {
                while (emIter.hasNext()) {
                    org.netbeans.modules.j2ee.api.ejbjar.EjbJar em = (org.netbeans.modules.j2ee.api.ejbjar.EjbJar)emIter.next();
                    if (em != null) {              // the class is in an ejb module
                        FileObject ejbJarFO = em.getDeploymentDescriptor();
                        EjbJar ejbJarDD = null;
                        try {
                            ejbJarDD = org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getMergedDDRoot(em.getMetadataUnit());
                        } catch (IOException ioe) {
                            //ignore
                        }
                        if ((ejbJarDD != null) && (ejbJarDD.getStatus()!=EjbJar.STATE_INVALID_UNPARSABLE) && ejbJarFO != null) {
                            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();

                            /* First check Session beans */
                            Session [] sessionBeans = (eBeans == null ? null : eBeans.getSession());
                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("Session Beans: " + sessionBeans);
                            if ((sessionBeans != null) && (sessionBeans.length > 0)) {
                                for (int b=0; b < sessionBeans.length; b++) {
                                    Session sBean = (Session)sessionBeans[b];
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("Session Bean: " + sBean);
                                    String ejbClass = sBean.getEjbClass();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB Class: " + ejbClass);
                                    if ((ejbClass != null) && (ejbClass.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarBeanClassRenameRefactoringElement(ejbJarDD, name, newName, (EntityAndSession)sBean, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbLocal = sBean.getLocal();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB Local: " + ejbLocal);
                                    if ((ejbLocal != null) && (ejbLocal.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarLocalRenameRefactoringElement(ejbJarDD, name, newName, (EntityAndSession)sBean, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbLocalHome = sBean.getLocalHome();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB LocalHome: " + ejbLocalHome);
                                    if ((ejbLocalHome != null) && (ejbLocalHome.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarLocalHomeRenameRefactoringElement(ejbJarDD, name, newName, (EntityAndSession)sBean, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbHome = sBean.getHome();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB Home: " + ejbHome);
                                    if ((ejbHome != null) && (ejbHome.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarHomeRenameRefactoringElement(ejbJarDD, name, newName, (EntityAndSession)sBean, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbRemote = sBean.getRemote();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB Remote: " + ejbRemote);
                                    if ((ejbRemote != null) && (ejbRemote.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarRemoteRenameRefactoringElement(ejbJarDD, name, newName, (EntityAndSession)sBean, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    // service endpoint is related to ejb based web services
                                    String serviceEndpoint = null;
                                    try {
                                        serviceEndpoint = sBean.getServiceEndpoint();
                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB Service Endpoint: " + serviceEndpoint);
                                        if ((serviceEndpoint != null) && (serviceEndpoint.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarServiceEndpointRenameRefactoringElement(ejbJarDD, name, newName, (Session)sBean, ejbJarFO);
                                            refactoringElements.add(refactoring, elem);
                                        }
                                    } catch (VersionNotSupportedException versionex) {
                                        // No problem, just ignore
                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("Service endpoint not supported in this version of dd.");
                                    }
                                    // refs
                                    org.netbeans.modules.j2ee.dd.api.common.EjbRef[] refs = sBean.getEjbRef();
                                    if ((refs != null) && (refs.length > 0)) {
                                        for (int l=0; l < refs.length; l++) {
                                            org.netbeans.modules.j2ee.dd.api.common.EjbRef ref = (org.netbeans.modules.j2ee.dd.api.common.EjbRef)refs[l];
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB ref: " + ref);
                                            String refHome = ref.getHome();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("home ref: " + refHome);
                                            if ((refHome != null) && (refHome.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefHomeRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbRef)ref, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refRemote = ref.getRemote();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("remote ref: " + refRemote);
                                            if ((refRemote != null) && (refRemote.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefRemoteRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbRef)ref, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }
                                    // local refs
                                    org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef[] localRefs = sBean.getEjbLocalRef();
                                    if ((localRefs != null) && (localRefs.length > 0)) {
                                        for (int l=0; l < localRefs.length; l++) {
                                            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef localRef = (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRefs[l];
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB local ref: " + localRef);
                                            String refLocal = localRef.getLocal();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("local ref: " + refLocal);
                                            if ((refLocal != null) && (refLocal.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefLocalRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRef, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refLocalHome = localRef.getLocalHome();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("localHome ref: " + refLocalHome);
                                            if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefLocalHomeRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRef, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }
                                }
                            }

                            /* Then entity beans */
                            Entity [] entityBeans = (eBeans == null ? null : eBeans.getEntity());
                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("Entity Beans: " + entityBeans);
                            if ((entityBeans != null) && (entityBeans.length > 0)) {
                                for (int b=0; b < entityBeans.length; b++) {
                                    Entity entBean = (Entity)entityBeans[b];
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("Entity Bean: " + entBean);
                                    String ejbClass = entBean.getEjbClass();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB Class: " + ejbClass);
                                    if ((ejbClass != null) && (ejbClass.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarBeanClassRenameRefactoringElement(ejbJarDD, name, newName, (EntityAndSession)entBean, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbLocal = entBean.getLocal();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB Local: " + ejbLocal);
                                    if ((ejbLocal != null) && (ejbLocal.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarLocalRenameRefactoringElement(ejbJarDD, name, newName, (EntityAndSession)entBean, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbLocalHome = entBean.getLocalHome();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB LocalHome: " + ejbLocalHome);
                                    if ((ejbLocalHome != null) && (ejbLocalHome.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarLocalHomeRenameRefactoringElement(ejbJarDD, name, newName, (EntityAndSession)entBean, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbHome = entBean.getHome();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB Home: " + ejbHome);
                                    if ((ejbHome != null) && (ejbHome.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarHomeRenameRefactoringElement(ejbJarDD, name, newName, (EntityAndSession)entBean, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbRemote = entBean.getRemote();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB Remote: " + ejbRemote);
                                    if ((ejbRemote != null) && (ejbRemote.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarRemoteRenameRefactoringElement(ejbJarDD, name, newName, (EntityAndSession)entBean, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    // refs
                                    org.netbeans.modules.j2ee.dd.api.common.EjbRef[] refs = entBean.getEjbRef();
                                    if ((refs != null) && (refs.length > 0)) {
                                        for (int l=0; l < refs.length; l++) {
                                            org.netbeans.modules.j2ee.dd.api.common.EjbRef ref = (org.netbeans.modules.j2ee.dd.api.common.EjbRef)refs[l];
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB ref: " + ref);
                                            String refHome = ref.getHome();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("home ref: " + refHome);
                                            if ((refHome != null) && (refHome.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefHomeRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbRef)ref, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refRemote = ref.getRemote();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("remote ref: " + refRemote);
                                            if ((refRemote != null) && (refRemote.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefRemoteRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbRef)ref, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }
                                    // local refs
                                    org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef[] localRefs = entBean.getEjbLocalRef();
                                    if ((localRefs != null) && (localRefs.length > 0)) {
                                        for (int l=0; l < localRefs.length; l++) {
                                            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef localRef = (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRefs[l];
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB local ref: " + localRef);
                                            String refLocal = localRef.getLocal();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("local ref: " + refLocal);
                                            if ((refLocal != null) && (refLocal.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefLocalRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRef, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refLocalHome = localRef.getLocalHome();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("localHome ref: " + refLocalHome);
                                            if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefLocalHomeRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRef, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }
                                }
                            }

                            /* And finally message driven beans */
                            MessageDriven [] messageBeans = (eBeans == null ? null : eBeans.getMessageDriven());
                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("MessageDriven Beans: " + messageBeans);
                            if ((messageBeans != null) && (messageBeans.length > 0)) {
                                for (int b=0; b < messageBeans.length; b++) {
                                    MessageDriven msgBean = (MessageDriven)messageBeans[b];
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("MessageDriven Bean: " + msgBean);
                                    String ejbClass = msgBean.getEjbClass();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB Class: " + ejbClass);
                                    if ((ejbClass != null) && (ejbClass.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarBeanClassRenameRefactoringElement(ejbJarDD, name, newName, (Ejb)msgBean, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    // refs
                                    org.netbeans.modules.j2ee.dd.api.common.EjbRef[] refs = msgBean.getEjbRef();
                                    if ((refs != null) && (refs.length > 0)) {
                                        for (int l=0; l < refs.length; l++) {
                                            org.netbeans.modules.j2ee.dd.api.common.EjbRef ref = (org.netbeans.modules.j2ee.dd.api.common.EjbRef)refs[l];
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB ref: " + ref);
                                            String refHome = ref.getHome();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("home ref: " + refHome);
                                            if ((refHome != null) && (refHome.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefHomeRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbRef)ref, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refRemote = ref.getRemote();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("remote ref: " + refRemote);
                                            if ((refRemote != null) && (refRemote.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefRemoteRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbRef)ref, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }
                                    // local refs
                                    org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef[] localRefs = msgBean.getEjbLocalRef();
                                    if ((localRefs != null) && (localRefs.length > 0)) {
                                        for (int l=0; l < localRefs.length; l++) {
                                            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef localRef = (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRefs[l];
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("EJB local ref: " + localRef);
                                            String refLocal = localRef.getLocal();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("local ref: " + refLocal);
                                            if ((refLocal != null) && (refLocal.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefLocalRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRef, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refLocalHome = localRef.getLocalHome();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("localHome ref: " + refLocalHome);
                                            if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarRefLocalHomeRenameRefactoringElement(ejbJarDD, name, newName, 
                                                            (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRef, 
                                                            ejbJarFO
                                                        );
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }
                                }
                            }

                        } else if (ejbJarFO != null){
                            Problem newProblem = new Problem(false, NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarRenameInvalidProblem"));
                            problem = Utility.addProblemsToEnd(problem, newProblem);
                        }
                    } // ejb-jar
                } // while
            }
            
        } // javaclass
        
        if (refObject instanceof Method) {
            
            // update Assembly descriptor part
            Method method = (Method)refObject;
            String oldName = method.getName();
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("old method name: " + oldName);
            
            Resource res = method.getResource();
            FileObject fo = JavaModel.getFileObject(res);
            Collection emodules = Utility.getRelevantEjbModules(fo);
            if ((emodules != null) && (emodules.size() > 0)) { // there are ejb modules that can be affected by the change
                ClassDefinition jc = method.getDeclaringClass();
                if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("classdefinition jc: " + jc);
                if (jc instanceof JavaClass) {
                    Iterator emIter = emodules.iterator();
                    while (emIter.hasNext()) {
                        org.netbeans.modules.j2ee.api.ejbjar.EjbJar em = (org.netbeans.modules.j2ee.api.ejbjar.EjbJar)emIter.next();
                        if (em != null) {              // the class is in an ejb module
                            FileObject ejbJarFO = em.getDeploymentDescriptor();
                            EjbJar ejbJarDD = null;
                            try {
                                ejbJarDD = org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getMergedDDRoot(em.getMetadataUnit());
                            } catch (IOException ioe) {
                                // ignore
                            }
                            if ((ejbJarDD != null) && (ejbJarDD.getStatus()!=EjbJar.STATE_INVALID_UNPARSABLE) && ejbJarFO != null) {
                                AssemblyDescriptor asmDesc = ejbJarDD.getSingleAssemblyDescriptor();
                                if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("asm desc: " + asmDesc);
                                if (asmDesc != null) {
                                    // container transaction part under assembly descriptor
                                    ContainerTransaction[] contTx = asmDesc.getContainerTransaction();
                                    if ((contTx != null) && (contTx.length > 0)) {
                                        for (int c=0; c<contTx.length; c++) {
                                            ContainerTransaction cTx = contTx[c];
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("ctx: " + cTx);
                                            if (cTx != null) {
                                                org.netbeans.modules.j2ee.dd.api.ejb.Method[] mtds = cTx.getMethod();
                                                if ((mtds != null) && (mtds.length > 0)) {
                                                    for (int m=0; m < mtds.length; m++) {
                                                        org.netbeans.modules.j2ee.dd.api.ejb.Method mtd = mtds[m];
                                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("mtd: " + mtd);
                                                        String mtdName = mtd.getMethodName();
                                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("mtdName: " + mtdName);
                                                        if (mtdName.equals(method.getName())) {
                                                            String invokedEjbName = mtd.getEjbName();
                                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("invokedejb: " + invokedEjbName);
                                                            String ejbName = Utility.getEjbNameForClass(ejbJarDD, jc);
                                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("ejbname: " + ejbName);
                                                            if (invokedEjbName.equals(ejbName)) {
                                                                RefactoringElementImplementation elem = new EjbJarContainerTxRenameRefactoringElement(
                                                                                                ejbJarDD, 
                                                                                                oldName, 
                                                                                                newName, 
                                                                                                ejbName,
                                                                                                mtd,
                                                                                                em.getDeploymentDescriptor());                                                                    
                                                                refactoringElements.add(refactoring, elem);
                                                            }
                                                        }

                                                    }
                                                }
                                            }
                                        }
                                    }

                                    // method permissions part under assembly descriptor
                                    MethodPermission[] mtdPerms = asmDesc.getMethodPermission();
                                    if ((mtdPerms != null) && (mtdPerms.length > 0)) {
                                        for (int c=0; c<mtdPerms.length; c++) {
                                            MethodPermission mtdPerm = mtdPerms[c];
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("mtdPerm: " + mtdPerm);
                                            if (mtdPerm != null) {
                                                org.netbeans.modules.j2ee.dd.api.ejb.Method[] mtds = mtdPerm.getMethod();
                                                if ((mtds != null) && (mtds.length > 0)) {
                                                    for (int m=0; m < mtds.length; m++) {
                                                        org.netbeans.modules.j2ee.dd.api.ejb.Method mtd = mtds[m];
                                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("mtd: " + mtd);
                                                        String mtdName = mtd.getMethodName();
                                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("mtdName: " + mtdName);
                                                        if (mtdName.equals(method.getName())) {
                                                            String invokedEjbName = mtd.getEjbName();
                                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("invokedejb: " + invokedEjbName);
                                                            String ejbName = Utility.getEjbNameForClass(ejbJarDD, jc);
                                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("ejbname: " + ejbName);
                                                            if (invokedEjbName.equals(ejbName)) {
                                                                RefactoringElementImplementation elem = new EjbJarMethodPermissionRenameRefactoringElement(
                                                                                                ejbJarDD, 
                                                                                                oldName, 
                                                                                                newName, 
                                                                                                ejbName,
                                                                                                mtd,
                                                                                                em.getDeploymentDescriptor());
                                                                refactoringElements.add(refactoring, elem);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }

                                    // exclude list part under assembly descriptor
                                    ExcludeList excList = asmDesc.getExcludeList();
                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("excList: " + excList);
                                    if (excList != null) {
                                        org.netbeans.modules.j2ee.dd.api.ejb.Method[] mtds = excList.getMethod();
                                        if ((mtds != null) && (mtds.length > 0)) {
                                            for (int m=0; m < mtds.length; m++) {
                                                org.netbeans.modules.j2ee.dd.api.ejb.Method mtd = mtds[m];
                                                if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("mtd: " + mtd);
                                                String mtdName = mtd.getMethodName();
                                                if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("mtdName: " + mtdName);
                                                if (mtdName.equals(method.getName())) {
                                                    String invokedEjbName = mtd.getEjbName();
                                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("invokedejb: " + invokedEjbName);
                                                    String ejbName = Utility.getEjbNameForClass(ejbJarDD, jc);
                                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("ejbname: " + ejbName);
                                                    if (invokedEjbName.equals(ejbName)) {
                                                        RefactoringElementImplementation elem = new EjbJarExcludeListRenameRefactoringElement(
                                                                                        ejbJarDD, 
                                                                                        oldName, 
                                                                                        newName, 
                                                                                        ejbName, 
                                                                                        mtd, 
                                                                                        em.getDeploymentDescriptor());
                                                        refactoringElements.add(refactoring, elem);
                                                    }
                                                }

                                            }
                                        }
                                    }
                                }
                            
                            } else {
                                Problem newProblem = new Problem(false, NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarRenameInvalidProblem"));
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                            }
                        }
                    }
                }
            }            
            
            if ((isHomeInImpl) || (isFinderInImpl)) {
                for (int i=0; i < ifaceRefactors.size(); i++) {
                    RenameRefactoring rr = (RenameRefactoring)ifaceRefactors.get(i);
                    Problem p = rr.prepare(session);
                    problem = Utility.addProblemsToEnd(problem, p);
                }
                return problem;
            }
            if ((isCmpHomeFinder) || (isCmpLocalHomeFinder)) {
                if (fo != null) {
                    Project prj = FileOwnerQuery.getOwner(fo);
                    if (prj != null) {
                        org.netbeans.modules.j2ee.api.ejbjar.EjbJar emod = 
                                org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar(prj.getProjectDirectory());
                        ClassDefinition jc = method.getDeclaringClass();
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("classdefinition jc: " + jc);
                        if (jc instanceof JavaClass) {
                            String className = jc.getName();
                            Entity[] eBeans = Utility.getEntityBeans(emod);
                            EjbJar ejbJarDD = Utility.getEjbJar(emod);
                            if ((eBeans != null) && (ejbJarDD != null)) {
                                for (int e=0; e < eBeans.length; e++) {
                                    Entity entity = (Entity)(eBeans[e]);
                                    String ejbClass = isCmpHomeFinder ? entity.getHome() : entity.getLocalHome();
                                    if (jc.getName().equals(ejbClass)) {
                                        Query[] queries = entity.getQuery();
                                        for (int q=0; q<queries.length; q++) {
                                            Query query = (Query)(queries[q]);
                                            QueryMethod qm = query.getQueryMethod();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("query method: " + qm);
                                            if (oldName.equals(qm.getMethodName())) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarFinderMethodRenameRefactoringElement(ejbJarDD, oldName, newName, entity, emod.getDeploymentDescriptor());
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (isSelectInImpl) {
                oldName = oldName.substring(9,10).toLowerCase() + oldName.substring(10);                
                if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("old method name: " + oldName);
                
                newName = newName.substring(9,10).toLowerCase() + newName.substring(10);
                if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("new method name: " + newName);
                
                if (fo != null) {
                    Project prj = FileOwnerQuery.getOwner(fo);
                    if (prj != null) {
                        org.netbeans.modules.j2ee.api.ejbjar.EjbJar emod = 
                                org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar(prj.getProjectDirectory());
                        ClassDefinition jc = method.getDeclaringClass();
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("classdefinition jc: " + jc);
                        if (jc instanceof JavaClass) {
                            String className = jc.getName();
                            Entity[] eBeans = Utility.getEntityBeans(emod);
                            EjbJar ejbJarDD = Utility.getEjbJar(emod);
                            if ((eBeans != null) && (ejbJarDD != null)) {
                                for (int e=0; e < eBeans.length; e++) {
                                    Entity entity = (Entity)(eBeans[e]);
                                    String ejbClass = entity.getEjbClass();
                                    if (jc.getName().equals(ejbClass)) {
                                        Query[] queries = entity.getQuery();
                                        for (int q=0; q<queries.length; q++) {
                                            Query query = (Query)(queries[q]);
                                            QueryMethod qm = query.getQueryMethod();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("query method: " + qm);
                                            if (oldName.equals(qm.getMethodName())) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarSelectMethodRenameRefactoringElement(ejbJarDD, oldName, newName, entity, emod.getDeploymentDescriptor());
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if (isSetterInBusiness || isGetterInBusiness) {
                if (fo != null) {
                    Project prj = FileOwnerQuery.getOwner(fo);
                    if (prj != null) {
                        org.netbeans.modules.j2ee.api.ejbjar.EjbJar emod = 
                                org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar(prj.getProjectDirectory());
                        if (isCmpField) {
                            Entity[] eBeans = Utility.getEntityBeans(emod);
                            EjbJar ejbJarDD = Utility.getEjbJar(emod);
                            if ((eBeans != null) && (ejbJarDD != null)) {
                                for (int e=0; e < eBeans.length; e++) {
                                    Entity entity = (Entity)(eBeans[e]);
                                    String ejbClass = entity.getEjbClass();
                                    if ((busImpltorClass != null) && (busImpltorClass.getName().equals(ejbClass))) {
                                        String oldFieldName = method.getName().substring(3,4).toLowerCase() + method.getName().substring(4);
                                        String newFieldName = newName.substring(3,4).toLowerCase() + newName.substring(4);
                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("old field name: " + oldFieldName);
                                        CmpField[] cmpFields = entity.getCmpField();
                                        for (int cm=0; cm<cmpFields.length; cm++) {
                                            CmpField cmpField = (CmpField)(cmpFields[cm]);
                                            String fieldName = cmpField.getFieldName();
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("field name: " + fieldName);
                                            // TODO: provided oldFieldName is wrong if first letter of field is upper-case, fix it and use equals() instead equalsIgnoreCase
                                            if (oldFieldName.equalsIgnoreCase(fieldName)) {
                                                RefactoringElementImplementation elem = 
                                                        new EjbJarCmpFieldRenameRefactoringElement(ejbJarDD, oldFieldName, newFieldName, entity, emod.getDeploymentDescriptor());
                                                refactoringElements.add(refactoring, elem);
                                                break;
                                            }
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        if (isCmrField) {
                            EjbRelation[] ejbRels = Utility.getRelationships(emod);
                            EjbJar ejbJarDD = Utility.getEjbJar(emod);
                            if ((ejbRels != null) && (ejbJarDD != null)) {
                                for (int e=0; e < ejbRels.length; e++) {
                                    EjbRelation ejbRel = (EjbRelation)(ejbRels[e]);
                                    String ejbName = Utility.getEntityEjbNameForClass((JavaClass)busImpltorClass);
                                    if (ejbName != null) {
                                        EjbRelationshipRole role = ejbRel.getEjbRelationshipRole();
                                        if (role != null) {
                                            RelationshipRoleSource roleSource = role.getRelationshipRoleSource();
                                            if (roleSource != null) {
                                                String roleEjbName = roleSource.getEjbName();
                                                if (ejbName.equals(roleEjbName)) {                                                        
                                                    String oldFieldName = method.getName().substring(3,4).toLowerCase() + method.getName().substring(4);
                                                    String newFieldName = newName.substring(3,4).toLowerCase() + newName.substring(4);
                                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("old field name: " + oldFieldName);
                                                    CmrField cmrField = role.getCmrField();
                                                    if (cmrField != null) {
                                                        String fieldName = cmrField.getCmrFieldName();
                                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("field name: " + fieldName);
                                                        // TODO: provided oldFieldName is wrong if first letter of field is upper-case, fix it and use equals() instead equalsIgnoreCase
                                                        if (oldFieldName.equalsIgnoreCase(fieldName)) {
                                                            RefactoringElementImplementation elem = 
                                                                    new EjbJarCmrFieldRenameRefactoringElement(ejbJarDD, oldFieldName, newFieldName, role, emod.getDeploymentDescriptor());
                                                            refactoringElements.add(refactoring, elem);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        EjbRelationshipRole role2 = ejbRel.getEjbRelationshipRole2();
                                        if (role2 != null) {
                                            RelationshipRoleSource roleSource = role2.getRelationshipRoleSource();
                                            if (roleSource != null) {
                                                String roleEjbName = roleSource.getEjbName();
                                                if (ejbName.equals(roleEjbName)) {                                                        
                                                    String oldFieldName = method.getName().substring(3,4).toLowerCase() + method.getName().substring(4);
                                                    String newFieldName = newName.substring(3,4).toLowerCase() + newName.substring(4);
                                                    if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("old field name: " + oldFieldName);
                                                    CmrField cmrField = role2.getCmrField();
                                                    if (cmrField != null) {
                                                        String fieldName = cmrField.getCmrFieldName();
                                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("field name: " + fieldName);
                                                        // TODO: provided oldFieldName is wrong if first letter of field is upper-case, fix it and use equals() instead equalsIgnoreCase
                                                        if (oldFieldName.equalsIgnoreCase(fieldName)) {
                                                            RefactoringElementImplementation elem = 
                                                                    new EjbJarCmrFieldRenameRefactoringElement(ejbJarDD, oldFieldName, newFieldName, role2, emod.getDeploymentDescriptor());
                                                            refactoringElements.add(refactoring, elem);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if (isSetterInImpl || isGetterInImpl) {
                if (fo != null) {
                    Project prj = FileOwnerQuery.getOwner(fo);
                    if (prj != null) {
                        org.netbeans.modules.j2ee.api.ejbjar.EjbJar emod = 
                                org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar(prj.getProjectDirectory());
                        ClassDefinition jc = method.getDeclaringClass();
                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("classdefinition jc: " + jc);
                        if (jc instanceof JavaClass) {
                            String className = jc.getName();
                            if (isCmpField) {
                                Entity[] eBeans = Utility.getEntityBeans(emod);
                                EjbJar ejbJarDD = Utility.getEjbJar(emod);
                                if ((eBeans != null) && (ejbJarDD != null)) {
                                    for (int e=0; e < eBeans.length; e++) {
                                        Entity entity = (Entity)(eBeans[e]);
                                        String ejbClass = entity.getEjbClass();
                                        if ((jc != null) && (className.equals(ejbClass))) {
                                            String oldFieldName = method.getName().substring(3,4).toLowerCase() + method.getName().substring(4);
                                            String newFieldName = newName.substring(3,4).toLowerCase() + newName.substring(4);
                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("old field name: " + oldFieldName);
                                            CmpField[] cmpFields = entity.getCmpField();
                                            for (int cm=0; cm<cmpFields.length; cm++) {
                                                CmpField cmpField = (CmpField)(cmpFields[cm]);
                                                String fieldName = cmpField.getFieldName();
                                                if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("field name: " + fieldName);
                                                if (oldFieldName.equals(fieldName)) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarCmpFieldRenameRefactoringElement(ejbJarDD, oldFieldName, newFieldName, entity, emod.getDeploymentDescriptor());
                                                    refactoringElements.add(refactoring, elem);
                                                    break;
                                                }
                                            }
                                            break;
                                        }
                                    }
                                }
                            }
                            if (isCmrField) {
                                EjbRelation[] ejbRels = Utility.getRelationships(emod);
                                EjbJar ejbJarDD = Utility.getEjbJar(emod);
                                if ((ejbRels != null) && (ejbJarDD != null)) {
                                    for (int e=0; e < ejbRels.length; e++) {
                                        EjbRelation ejbRel = (EjbRelation)(ejbRels[e]);
                                        String ejbName = Utility.getEntityEjbNameForClass((JavaClass)jc);
                                        if (ejbName != null) {
                                            EjbRelationshipRole role = ejbRel.getEjbRelationshipRole();
                                            if (role != null) {
                                                RelationshipRoleSource roleSource = role.getRelationshipRoleSource();
                                                if (roleSource != null) {
                                                    String roleEjbName = roleSource.getEjbName();
                                                    if (ejbName.equals(roleEjbName)) {                                                        
                                                        String oldFieldName = method.getName().substring(3,4).toLowerCase() + method.getName().substring(4);
                                                        String newFieldName = newName.substring(3,4).toLowerCase() + newName.substring(4);
                                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("old field name: " + oldFieldName);
                                                        CmrField cmrField = role.getCmrField();
                                                        if (cmrField != null) {
                                                            String fieldName = cmrField.getCmrFieldName();
                                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("field name: " + fieldName);
                                                            if (oldFieldName.equals(fieldName)) {
                                                                RefactoringElementImplementation elem = 
                                                                        new EjbJarCmrFieldRenameRefactoringElement(ejbJarDD, oldFieldName, newFieldName, role, emod.getDeploymentDescriptor());
                                                                refactoringElements.add(refactoring, elem);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            EjbRelationshipRole role2 = ejbRel.getEjbRelationshipRole2();
                                            if (role2 != null) {
                                                RelationshipRoleSource roleSource = role2.getRelationshipRoleSource();
                                                if (roleSource != null) {
                                                    String roleEjbName = roleSource.getEjbName();
                                                    if (ejbName.equals(roleEjbName)) {                                                        
                                                        String oldFieldName = method.getName().substring(3,4).toLowerCase() + method.getName().substring(4);
                                                        String newFieldName = newName.substring(3,4).toLowerCase() + newName.substring(4);
                                                        if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("old field name: " + oldFieldName);
                                                        CmrField cmrField = role2.getCmrField();
                                                        if (cmrField != null) {
                                                            String fieldName = cmrField.getCmrFieldName();
                                                            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("field name: " + fieldName);
                                                            if (oldFieldName.equals(fieldName)) {
                                                                RefactoringElementImplementation elem = 
                                                                        new EjbJarCmrFieldRenameRefactoringElement(ejbJarDD, oldFieldName, newFieldName, role2, emod.getDeploymentDescriptor());
                                                                refactoringElements.add(refactoring, elem);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            
            for (int i=0; i < ifaceRefactors.size(); i++) {
                RenameRefactoring rr = (RenameRefactoring)ifaceRefactors.get(i);
                if (isGetterInBusiness || isSetterInBusiness || isSetterInImpl || isGetterInImpl) {
                    String newPart = newName.substring(1);
                    rr.setNewName(newName.startsWith("g") ? "s" + newPart : "g" + newPart);
                }
                Problem p = rr.prepare(session);
                problem = Utility.addProblemsToEnd(problem, p);
            }
            for (int i=0; i < implRefactors.size(); i++) {
                RenameRefactoring rr = (RenameRefactoring)implRefactors.get(i);
                String nName = rr.getNewName();
                String oName = ((Method)rr.getRefactoredObject()).getName();
                if (!(nName.equals(oName))) {
                    Problem p = rr.prepare(session);
                    problem = Utility.addProblemsToEnd(problem, p);
                } else { // this doesn't make sense = the name didn't change
                    implRefactors.remove(rr);
                }
            }
        }
        
        return problem;
    }

    public final class EjbJarBeanClassRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private Ejb ejb;

        /** Creates a new instance of EjbJarBeanClassRenameRefactoringElement */
        public EjbJarBeanClassRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, Ejb ejb, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ejb = ejb;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarBeanClassRename"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarBeanClassRenameRefactoringElement.performExternalChange: " + ejb);
            ejb.setEjbClass(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarBeanClassRenameRefactoringElement.undoExternalChange: " + ejb);
            ejb.setEjbClass(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class EjbJarLocalRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private EntityAndSession ejb;

        /** Creates a new instance of EjbJarLocalRenameRefactoringElement */
        public EjbJarLocalRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, EntityAndSession ejb, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ejb = ejb;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarLocalRename"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            err.log("> EjbJarLocalRenameRefactoringElement.performExternalChange: " + ejb);
            ejb.setLocal(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            ejb.setLocal(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class EjbJarLocalHomeRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private EntityAndSession ejb;

        /** Creates a new instance of EjbJarLocalHomeRenameRefactoringElement */
        public EjbJarLocalHomeRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, EntityAndSession ejb, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ejb = ejb;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarLocalHomeRename"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarLocalHomeRenameRefactoringElement.performExternalChange: " + ejb);
            ejb.setLocalHome(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            ejb.setLocalHome(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class EjbJarHomeRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private EntityAndSession ejb;

        /** Creates a new instance of EjbJarHomeRenameRefactoringElement */
        public EjbJarHomeRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, EntityAndSession ejb, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ejb = ejb;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarHomeRename"), args);  //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarHomeRenameRefactoringElement.performExternalChange: " + ejb);
            ejb.setHome(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            ejb.setHome(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class EjbJarRemoteRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private EntityAndSession ejb;

        /** Creates a new instance of EjbJarRemoteRenameRefactoringElement */
        public EjbJarRemoteRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, EntityAndSession ejb, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ejb = ejb;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarRemoteRename"), args);    //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarRemoteRenameRefactoringElement.performExternalChange: " + ejb);
            ejb.setRemote(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            ejb.setRemote(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }

    public final class EjbJarServiceEndpointRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private Session ejb;

        /** Creates a new instance of EjbJarServiceEndpointRenameRefactoringElement */
        public EjbJarServiceEndpointRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, Session ejb, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ejb = ejb;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarServiceEndpointRename"), args);   //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarServiceEndpointRenameRefactoringElement.performExternalChange: " + ejb);
            try {
                ejb.setServiceEndpoint(newName);
            } catch (VersionNotSupportedException ve) {
                // no problem, just ignore
            }
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            try {
                ejb.setServiceEndpoint(oldName);
            } catch (VersionNotSupportedException ve) {
                // no problem, just ignore
            }
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class EjbJarRefLocalRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef localRef;

        /** Creates a new instance of EjbJarRefLocalRenameRefactoringElement */
        public EjbJarRefLocalRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef localRef, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.localRef = localRef;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarRefLocalRename"), args);  //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarRefLocalRenameRefactoringElement.performExternalChange: " + localRef);
            localRef.setLocal(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            localRef.setLocal(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class EjbJarRefLocalHomeRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef localRef;

        /** Creates a new instance of EjbJarRefLocalHomeRenameRefactoringElement */
        public EjbJarRefLocalHomeRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef localRef, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.localRef = localRef;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarRefLocalHomeRename"), args);  //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarRefLocalHomeRenameRefactoringElement.performExternalChange: " + localRef);
            localRef.setLocalHome(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            localRef.setLocalHome(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }

    public final class EjbJarRefHomeRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private org.netbeans.modules.j2ee.dd.api.common.EjbRef ref;

        /** Creates a new instance of EjbJarRefHomeRenameRefactoringElement */
        public EjbJarRefHomeRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, org.netbeans.modules.j2ee.dd.api.common.EjbRef ref, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ref = ref;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarRefHomeRename"), args);   //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarRefHomeRenameRefactoringElement.performExternalChange: " + ref);
            ref.setHome(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            ref.setHome(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }    

    public final class EjbJarRefRemoteRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private org.netbeans.modules.j2ee.dd.api.common.EjbRef ref;

        /** Creates a new instance of EjbJarRefRemoteRenameRefactoringElement */
        public EjbJarRefRemoteRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, org.netbeans.modules.j2ee.dd.api.common.EjbRef ref, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ref = ref;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarRefRemoteRename"), args); //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarRefRemoteRenameRefactoringElement.performExternalChange: " + ref);
            ref.setRemote(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            ref.setRemote(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }

    public final class EjbJarFinderMethodRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private Entity entity;

        /** Creates a new instance of EjbJarRefRemoteRenameRefactoringElement */
        public EjbJarFinderMethodRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, Entity entity, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.entity = entity;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarFinderMethodRename"), args);  //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarFinderMethodRenameRefactoringElement.performExternalChange: " + entity);
            Query[] queries = entity.getQuery();
            for (int q = 0; q < queries.length; q++) {
                Query query = queries[q];
                QueryMethod qm = query.getQueryMethod();
                if (oldName.equals(qm.getMethodName())) {
                    qm.setMethodName(newName);
                    try {
                        ejbJarDD.write(parentFile);
                    } catch (IOException ioe) {
                        //TODO
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            Query[] queries = entity.getQuery();
            for (int q = 0; q < queries.length; q++) {
                Query query = queries[q];
                QueryMethod qm = query.getQueryMethod();
                if (newName.equals(qm.getMethodName())) {
                    qm.setMethodName(oldName);
                    try {
                        ejbJarDD.write(parentFile);
                    } catch (IOException ioe) {
                        //TODO
                    }
                }
            }
        }
    }

    public final class EjbJarSelectMethodRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private Entity entity;

        /** Creates a new instance of EjbJarSelectMethodRenameRefactoringElement */
        public EjbJarSelectMethodRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, Entity entity, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.entity = entity;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), "ejbSelect" + oldName, "ejbSelect" + newName}; //NOI18N
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarSelectMethodRename"), args);  //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarSelectMethodRenameRefactoringElement.performExternalChange: " + entity);
            Query[] queries = entity.getQuery();
            for (int q = 0; q < queries.length; q++) {
                Query query = queries[q];
                QueryMethod qm = query.getQueryMethod();
                if (oldName.equals(qm.getMethodName())) {
                    qm.setMethodName(newName);
                    try {
                        ejbJarDD.write(parentFile);
                    } catch (IOException ioe) {
                        //TODO
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            Query[] queries = entity.getQuery();
            for (int q = 0; q < queries.length; q++) {
                Query query = queries[q];
                QueryMethod qm = query.getQueryMethod();
                if (newName.equals(qm.getMethodName())) {
                    qm.setMethodName(oldName);
                    try {
                        ejbJarDD.write(parentFile);
                    } catch (IOException ioe) {
                        //TODO
                    }
                }
            }
        }
    }

    public final class EjbJarCmpFieldRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private Entity entity;

        /** Creates a new instance of EjbJarCmpFieldRenameRefactoringElement */
        public EjbJarCmpFieldRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, Entity entity, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.entity = entity;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarCmpFieldRename"), args);  //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarCmpFieldRenameRefactoringElement.performExternalChange: " + entity);
            boolean dirty = false;
            // TODO: provided oldName is wrong if first letter of field is upper-case, fix it and use equals() instead equalsIgnoreCase
            if (oldName.equalsIgnoreCase(entity.getPrimkeyField())) {
                entity.setPrimkeyField(newName);
                dirty = true;
            }
            CmpField[] cmpFields = entity.getCmpField();
            for (int q = 0; q < cmpFields.length; q++) {
                CmpField cmpField = cmpFields[q];
                // TODO: provided oldName is wrong if first letter of field is upper-case, fix it and use equals() instead equalsIgnoreCase
                if (oldName.equalsIgnoreCase(cmpField.getFieldName())) {
                    cmpField.setFieldName(newName);
                    dirty = true;
                }
            }
            if (dirty) {
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            CmpField[] cmpFields = entity.getCmpField();
            for (int q = 0; q < cmpFields.length; q++) {
                CmpField cmpField = cmpFields[q];
                // TODO: provided newName is wrong if first letter of field is upper-case, fix it and use equals() instead equalsIgnoreCase
                if (newName.equalsIgnoreCase(cmpField.getFieldName())) {
                    cmpField.setFieldName(oldName);
                    try {
                        ejbJarDD.write(parentFile);
                    } catch (IOException ioe) {
                        //TODO
                    }
                }
            }
        }
    }

    public final class EjbJarCmrFieldRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private EjbRelationshipRole role;

        /** Creates a new instance of EjbJarCmrFieldRenameRefactoringElement */
        public EjbJarCmrFieldRenameRefactoringElement(EjbJar ejbJarDD, String oldName, String newName, EjbRelationshipRole role, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldName;
            this.newName = newName;
            this.role = role;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {role.getEjbRelationshipRoleName(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarCmrFieldRename"), args);  //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarCmrFieldRenameRefactoringElement.performExternalChange: " + role);
            CmrField cmrField = role.getCmrField();
            // TODO: provided oldName is wrong if first letter of field is upper-case, fix it and use equals() instead equalsIgnoreCase
            if (oldName.equalsIgnoreCase(cmrField.getCmrFieldName())) {
                cmrField.setCmrFieldName(newName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            CmrField cmrField = role.getCmrField();
            // TODO: provided newName is wrong if first letter of field is upper-case, fix it and use equals() instead equalsIgnoreCase
            if (newName.equalsIgnoreCase(cmrField.getCmrFieldName())) {
                cmrField.setCmrFieldName(oldName);
                try {
                    ejbJarDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
    }
    
    public final class EjbJarExcludeListRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private org.netbeans.modules.j2ee.dd.api.ejb.Method mtd;
        private String ejbName;
            
        /** Creates a new instance of EjbJarExcludeListRenameRefactoringElement */
        public EjbJarExcludeListRenameRefactoringElement(   EjbJar ejbJarDD, 
                                                            String oldMtdName, 
                                                            String newMtdName, 
                                                            String ejbName, 
                                                            org.netbeans.modules.j2ee.dd.api.ejb.Method mtd, 
                                                            FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldMtdName;
            this.newName = newMtdName;
            this.ejbName = ejbName;
            this.mtd = mtd;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName, ejbName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarExcludeListMethodRename"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarExcludeListRenameRefactoringElement.performExternalChange: " + mtd);
            mtd.setMethodName(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            mtd.setMethodName(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }

    public final class EjbJarMethodPermissionRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private org.netbeans.modules.j2ee.dd.api.ejb.Method mtd;
        private String ejbName;
            
        /** Creates a new instance of EjbJarMethodPermissionRenameRefactoringElement */
        public EjbJarMethodPermissionRenameRefactoringElement(   EjbJar ejbJarDD, 
                                                            String oldMtdName, 
                                                            String newMtdName, 
                                                            String ejbName, 
                                                            org.netbeans.modules.j2ee.dd.api.ejb.Method mtd, 
                                                            FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldMtdName;
            this.newName = newMtdName;
            this.ejbName = ejbName;
            this.mtd = mtd;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName, ejbName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarMethodPermissionMethodRename"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarMethodPermissionRenameRefactoringElement.performExternalChange: " + mtd);
            mtd.setMethodName(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            mtd.setMethodName(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }

    public final class EjbJarContainerTxRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected EjbJar ejbJarDD;
        private org.netbeans.modules.j2ee.dd.api.ejb.Method mtd;
        private String ejbName;
            
        /** Creates a new instance of EjbJarContainerTxRenameRefactoringElement */
        public EjbJarContainerTxRenameRefactoringElement(   EjbJar ejbJarDD, 
                                                            String oldMtdName, 
                                                            String newMtdName, 
                                                            String ejbName, 
                                                            org.netbeans.modules.j2ee.dd.api.ejb.Method mtd, 
                                                            FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.oldName = oldMtdName;
            this.newName = newMtdName;
            this.ejbName = ejbName;
            this.mtd = mtd;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName, ejbName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarRenameRefactoring.class, "TXT_EjbJarContainerTxMethodRename"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (ErrorManager.getDefault().isLoggable(ErrorManager.INFORMATIONAL)) err.log("> EjbJarContainerTxRenameRefactoringElement.performExternalChange: " + mtd);
            mtd.setMethodName(newName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            mtd.setMethodName(oldName);
            try {
                ejbJarDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
}
