/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public final class WebXmlMoveClassRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");   // NOI18N

    public WebXmlMoveClassRefactoring() { }

    /** Find usages in web deployment descriptor: web.xml 
     */
    public Problem prepare(MoveClassRefactoring moveClassRefactor, Collection resources, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
            
        for (Iterator i = resources.iterator(); i.hasNext();) {
            Resource resource = (Resource) i.next();
            FileObject fo = JavaModel.getFileObject(resource);
            
            err.log("resource package name:  " + resource.getPackageName());
            err.log("resource: name " + resource.getName());

            Collection wmodules = Utility.getRelevantWebModules(fo);
            Iterator wmIter = null;

            if (wmodules != null) {
                wmIter = wmodules.iterator();
            }
            if (wmIter != null) {
                while (wmIter.hasNext()) {
                    
                    WebModule wm = (WebModule)wmIter.next();
                    WebModule wmNew = null;

                    if (wm != null) {              // resource is in a web module

                        Project prj1 = FileOwnerQuery.getOwner(wm.getDeploymentDescriptor());
                        Project prj2 = null;
                        
                        FileObject target = moveClassRefactor.getTargetClassPathRoot();
                        if (target != null) {
                            prj2 = FileOwnerQuery.getOwner(target);
                        }
                        
                        boolean moveToAnotherProject = false;
                        if (prj2 != null) {
                            moveToAnotherProject = !prj1.equals(prj2);
                        }
                        
                        if (moveToAnotherProject) {
                            wmNew = WebModule.getWebModule(target);
                        }                        
                        
                        if (moveToAnotherProject && wmNew == null) {
                            continue;
                        }
                        
                        FileObject webXmlFO = wm.getDeploymentDescriptor();
                        FileObject newWebXmlFO = null;
                        
                        WebApp webXmlDD = null;
                        WebApp newWebXmlDD = null;
                        
                        try {
                            webXmlDD = DDProvider.getDefault().getDDRoot(webXmlFO);
                            if (moveToAnotherProject) {
                                newWebXmlFO = wmNew.getDeploymentDescriptor();
                                newWebXmlDD = DDProvider.getDefault().getDDRoot(newWebXmlFO);
                            }
                        } catch (IOException ioe) {
                            // ignore
                        }
                        if ((webXmlDD != null) && (webXmlDD.getStatus() != WebApp.STATE_INVALID_UNPARSABLE)) {
                            if (moveToAnotherProject && newWebXmlDD == null) {
                                Problem newProblem = new Problem(false, NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlMoveClassInvalidProblem"));
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                continue;
                            }
                            List classes = resource.getClassifiers();
                            err.log("Classes in resource: " + classes);

                            for (int j=0; j < classes.size(); j++ ) {
                                JavaClass jClass = (JavaClass)classes.get(j);
                                err.log("javaclass: "+ jClass);

                                String name = jClass.getName();
                                err.log("name: " + name);

                                String targetPackage = moveClassRefactor.getTargetPackageName(resource);
                                err.log("targetPackage: " + targetPackage);

                                String newName = targetPackage + "." + jClass.getSimpleName();
                                err.log("newname: " + newName);
                                                                
                                //servlets
                                Servlet[] servlets = webXmlDD.getServlet();
                                if ((servlets!=null) && (servlets.length > 0)) {
                                    for (int s=0; s < servlets.length; s++) {
                                        Servlet servlet = servlets[s];
                                        err.log("Servlet: " + servlet);
                                        String servletClass = servlet.getServletClass();
                                        err.log("Servlet class: " + servletClass);
                                        if ((servletClass != null) && (servletClass.equals(name))) {
                                            if (!moveToAnotherProject) {
                                                RefactoringElementImplementation elem = 
                                                        new WebXmlServletMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                                refactoringElements.add(moveClassRefactor, elem);
                                            } else {
                                                RefactoringElementImplementation elem = 
                                                        new WebXmlServletReferenceMoveClassOtherProjectRefactoringElement(webXmlDD, newWebXmlDD, name, newName, webXmlFO, newWebXmlFO);
                                                refactoringElements.add(moveClassRefactor, elem);
                                            }
                                        }
                                    }
                                }

                                //listeners
                                Listener[] listeners = webXmlDD.getListener();
                                if ((listeners!=null) && (listeners.length > 0)) {
                                    for (int s=0; s < listeners.length; s++) {
                                        Listener listener = listeners[s];
                                        err.log("Listener: " + listener);
                                        String listenerClass = listener.getListenerClass();
                                        err.log("Listener class: " + listenerClass);
                                        if ((listenerClass != null) && (listenerClass.equals(name))) {
                                            if (!moveToAnotherProject) {
                                                RefactoringElementImplementation elem = 
                                                        new WebXmlListenerMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                                refactoringElements.add(moveClassRefactor, elem);
                                            } else {
                                                RefactoringElementImplementation elem = 
                                                        new WebXmlListenerReferenceMoveClassOtherProjectRefactoringElement(webXmlDD, newWebXmlDD, name, newName, webXmlFO, newWebXmlFO);
                                                refactoringElements.add(moveClassRefactor, elem);
                                            }
                                        }
                                    }
                                }

                                //filters
                                Filter[] filters = webXmlDD.getFilter();
                                if ((filters!=null) && (filters.length > 0)) {
                                    for (int s=0; s < filters.length; s++) {
                                        Filter filter = filters[s];
                                        err.log("Filter: " + filter);
                                        String filterClass = filter.getFilterClass();
                                        err.log("Filter class: " + filterClass);
                                        if ((filterClass != null) && (filterClass.equals(name))) {
                                            if (!moveToAnotherProject) {
                                                RefactoringElementImplementation elem = 
                                                        new WebXmlFilterMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                                refactoringElements.add(moveClassRefactor, elem);
                                            } else {
                                                RefactoringElementImplementation elem = 
                                                        new WebXmlFilterReferenceMoveClassOtherProjectRefactoringElement(webXmlDD, newWebXmlDD, name, newName, webXmlFO, newWebXmlFO);
                                                refactoringElements.add(moveClassRefactor, elem);                                                
                                            }
                                        }
                                    }
                                }
                            
                                // refs
                                org.netbeans.modules.j2ee.dd.api.common.EjbRef[] refs = webXmlDD.getEjbRef();
                                if ((refs != null) && (refs.length > 0)) {
                                    for (int l=0; l < refs.length; l++) {
                                        org.netbeans.modules.j2ee.dd.api.common.EjbRef ref = refs[l];
                                        err.log("EJB ref: " + ref);
                                        String refHome = ref.getHome();
                                        err.log("home ref: " + refHome);
                                        if ((refHome != null) && (refHome.equals(name))) {
                                            RefactoringElementImplementation elem = 
                                                    new WebXmlRefHomeMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        String refRemote = ref.getRemote();
                                        err.log("localHome ref: " + refRemote);
                                        if ((refRemote != null) && (refRemote.equals(name))) {
                                            RefactoringElementImplementation elem = 
                                                    new WebXmlRefRemoteMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                    }
                                }

                                // local refs
                                org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef[] localRefs = webXmlDD.getEjbLocalRef();
                                if ((localRefs != null) && (localRefs.length > 0)) {
                                    for (int l=0; l < localRefs.length; l++) {
                                        org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef localRef = localRefs[l];
                                        err.log("EJB local ref: " + localRef);
                                        String refLocal = localRef.getLocal();
                                        err.log("local ref: " + refLocal);
                                        if ((refLocal != null) && (refLocal.equals(name))) {
                                            RefactoringElementImplementation elem = 
                                                    new WebXmlRefLocalMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        String refLocalHome = localRef.getLocalHome();
                                        err.log("localHome ref: " + refLocalHome);
                                        if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                            RefactoringElementImplementation elem = 
                                                    new WebXmlRefLocalHomeMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                    }
                                }   
                            }
                        } else {
                            Problem newProblem = new Problem(false, NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlMoveClassInvalidProblem"));
                            problem = Utility.addProblemsToEnd(problem, newProblem);
                        }
                    }
                } //while
            }
        } //for
        return problem;
    }
    
    public final class WebXmlServletMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlServletMoveClassRefactoringElement */
        public WebXmlServletMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlServletMoveClass"), args);
        }

        public void performExternalChange() {
            Servlet servlet = (Servlet)webXmlDD.findBeanByName("Servlet","ServletClass",oldName); //NOI18N
            if (servlet != null) {
                servlet.setServletClass(newName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
        
        public void undoExternalChange() {
            Servlet servlet = (Servlet)webXmlDD.findBeanByName("Servlet","ServletClass",newName); //NOI18N
            if (servlet != null) {
                servlet.setServletClass(oldName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

    }

    public final class WebXmlServletReferenceMoveClassOtherProjectRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected WebApp webXmlDD;
        protected WebApp newWebXmlDD;

        protected FileObject newXmlFO;

        private Servlet servlet = null;
        private List servletMappings = null;
        
        /** Creates a new instance of WebXmlServletReferenceMoveClassOtherProjectRefactoringElement */
        public WebXmlServletReferenceMoveClassOtherProjectRefactoringElement(WebApp webXmlDD, WebApp newWebXmlDD, String oldName, String newName, FileObject parentFile, FileObject newXmlFO) { 
            this.webXmlDD = webXmlDD;
            this.newWebXmlDD = newWebXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
            this.newXmlFO = newXmlFO;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), parentFile.getPath(), newXmlFO.getPath()};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlServletReferenceMoveClassOtherProject"), args);
        }

        public void performExternalChange() {
            servlet = (Servlet)webXmlDD.findBeanByName("Servlet","ServletClass",oldName); //NOI18N
            
            List mappingsToMove = getServletMappings(webXmlDD, servlet.getServletName());
            for (int i=0; i<mappingsToMove.size(); i++) {
                webXmlDD.removeServletMapping((ServletMapping)mappingsToMove.get(i));
                newWebXmlDD.addServletMapping((ServletMapping)mappingsToMove.get(i));
            }

            servlet.setServletClass(newName);
            webXmlDD.removeServlet(servlet);
            newWebXmlDD.addServlet(servlet);
            
            try {
                webXmlDD.write(parentFile);
                newWebXmlDD.write(newXmlFO);
            } catch (IOException ioe) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
            }
        }
        
        public void undoExternalChange() {
            if (servletMappings != null) {
                for (int i=0; i<servletMappings.size(); i++) {
                    newWebXmlDD.removeServletMapping((ServletMapping)servletMappings.get(i));
                    webXmlDD.addServletMapping((ServletMapping)servletMappings.get(i));
                }
            }

            servlet.setServletClass(oldName);
            newWebXmlDD.removeServlet(servlet);
            webXmlDD.addServlet(servlet);
            
            try {
                webXmlDD.write(parentFile);
                newWebXmlDD.write(newXmlFO);
            } catch (IOException ioe) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
            }
        }
        
        private List getServletMappings(WebApp webApp, String servletName) {
            if (servletName==null) return null;
            ServletMapping[] oldMaps = webApp.getServletMapping();
            List toMove = new ArrayList();
            for (int i=0;i<oldMaps.length;i++) {
                if (servletName.equals(oldMaps[i].getServletName())) {
                    toMove.add(oldMaps[i]);
                }
            }
            return toMove;
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

    }
    
    public final class WebXmlListenerMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlListenerMoveClassRefactoringElement */
        public WebXmlListenerMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlListenerMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            Listener listener = (Listener)webXmlDD.findBeanByName("Listener","ListenerClass",oldName); //NOI18N
            if (listener != null) {
                listener.setListenerClass(newName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
        
        public void undoExternalChange() {
            Listener listener = (Listener)webXmlDD.findBeanByName("Listener","ListenerClass",newName); //NOI18N
            if (listener != null) {
                listener.setListenerClass(oldName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
    }

    public final class WebXmlListenerReferenceMoveClassOtherProjectRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected WebApp webXmlDD;
        protected WebApp newWebXmlDD;

        protected FileObject newXmlFO;

        private Listener listener = null;

        /** Creates a new instance of WebXmlListenerReferenceMoveClassOtherProjectRefactoringElement */
        public WebXmlListenerReferenceMoveClassOtherProjectRefactoringElement(WebApp webXmlDD, WebApp newWebXmlDD, String oldName, String newName, FileObject parentFile, FileObject newXmlFO) {
            this.webXmlDD = webXmlDD;
            this.newWebXmlDD = newWebXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
            this.newXmlFO = newXmlFO;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), parentFile.getPath(), newXmlFO.getPath()};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlListenerReferenceMoveClassOtherProject"), args);
        }

        public void performExternalChange() {
            listener = (Listener)webXmlDD.findBeanByName("Listener","ListenerClass",oldName); //NOI18N
            
            listener.setListenerClass(newName);
            webXmlDD.removeListener(listener);
            newWebXmlDD.addListener(listener);
            
            try {
                webXmlDD.write(parentFile);
                newWebXmlDD.write(newXmlFO);
            } catch (IOException ioe) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
            }
        }
        
        public void undoExternalChange() {
            listener.setListenerClass(oldName);
            newWebXmlDD.removeListener(listener);
            webXmlDD.addListener(listener);
            
            try {
                webXmlDD.write(parentFile);
                newWebXmlDD.write(newXmlFO);
            } catch (IOException ioe) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
            }
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

    }
    
    
    public final class WebXmlFilterMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlFilterMoveClassRefactoringElement */
        public WebXmlFilterMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlFilterMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            Filter filter = (Filter)webXmlDD.findBeanByName("Filter","FilterClass",oldName); //NOI18N
            if (filter!=null) {
                filter.setFilterClass(newName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
        
        public void undoExternalChange() {
            Filter filter = (Filter)webXmlDD.findBeanByName("Filter","FilterClass",newName); //NOI18N
            if (filter!=null) {
                filter.setFilterClass(oldName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
    }
    
    public final class WebXmlFilterReferenceMoveClassOtherProjectRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected WebApp webXmlDD;
        protected WebApp newWebXmlDD;

        protected FileObject newXmlFO;

        private Filter filter = null;
        private List filterMappings = null;
        
        /** Creates a new instance of WebXmlFilterReferenceMoveClassOtherProjectRefactoringElement */
        public WebXmlFilterReferenceMoveClassOtherProjectRefactoringElement(WebApp webXmlDD, WebApp newWebXmlDD, String oldName, String newName, FileObject parentFile, FileObject newXmlFO) { 
            this.webXmlDD = webXmlDD;
            this.newWebXmlDD = newWebXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
            this.newXmlFO = newXmlFO;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), parentFile.getPath(), newXmlFO.getPath()};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlFilterReferenceMoveClassOtherProject"), args);
        }

        public void performExternalChange() {
            filter = (Filter)webXmlDD.findBeanByName("Filter","FilterClass",oldName); //NOI18N
            
            List mappingsToMove = getFilterMappings(webXmlDD, filter.getFilterName());
            for (int i=0; i<mappingsToMove.size(); i++) {
                FilterMapping mapping = (FilterMapping) mappingsToMove.get(i);
                webXmlDD.removeFilterMapping(mapping);
                newWebXmlDD.addFilterMapping(mapping);
            }

            filter.setFilterClass(newName);
            webXmlDD.removeFilter(filter);
            newWebXmlDD.addFilter(filter);
            
            try {
                webXmlDD.write(parentFile);
                newWebXmlDD.write(newXmlFO);
            } catch (IOException ioe) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
            }
        }
        
        public void undoExternalChange() {
            if (filterMappings != null) {
                for (int i=0; i<filterMappings.size(); i++) {
                    newWebXmlDD.removeFilterMapping((FilterMapping)filterMappings.get(i));
                    webXmlDD.addFilterMapping((FilterMapping)filterMappings.get(i));
                }
            }

            filter.setFilterClass(oldName);
            newWebXmlDD.removeFilter(filter);
            webXmlDD.addFilter(filter);
            
            try {
                webXmlDD.write(parentFile);
                newWebXmlDD.write(newXmlFO);
            } catch (IOException ioe) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
            }
        }
        
        private List getFilterMappings(WebApp webApp, String filterName) {
            if (filterName==null) return null;
            FilterMapping[] oldMaps = webApp.getFilterMapping();
            List toMove = new ArrayList();
            for (int i=0;i<oldMaps.length;i++) {
                if (filterName.equals(oldMaps[i].getFilterName())) {
                    toMove.add(oldMaps[i]);
                }
            }
            return toMove;
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

    }    

    public final class WebXmlRefHomeMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlRefHomeMoveClassRefactoringElement */
        public WebXmlRefHomeMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlRefHomeMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            org.netbeans.modules.j2ee.dd.api.common.EjbRef[] refs = webXmlDD.getEjbRef();
            org.netbeans.modules.j2ee.dd.api.common.EjbRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String refStr = refs[i].getHome();
                if (oldName.equals(refStr)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setHome(newName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
        
        public void undoExternalChange() {
            org.netbeans.modules.j2ee.dd.api.common.EjbRef[] refs = webXmlDD.getEjbRef();
            org.netbeans.modules.j2ee.dd.api.common.EjbRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String refStr = refs[i].getHome();
                if (newName.equals(refStr)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setHome(oldName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
    }

    public final class WebXmlRefRemoteMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlRefRemoteMoveClassRefactoringElement */
        public WebXmlRefRemoteMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlRefRemoteMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            org.netbeans.modules.j2ee.dd.api.common.EjbRef[] refs = webXmlDD.getEjbRef();
            org.netbeans.modules.j2ee.dd.api.common.EjbRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String refStr = refs[i].getRemote();
                if (oldName.equals(refStr)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setRemote(newName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
        
        public void undoExternalChange() {
            org.netbeans.modules.j2ee.dd.api.common.EjbRef[] refs = webXmlDD.getEjbRef();
            org.netbeans.modules.j2ee.dd.api.common.EjbRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String refStr = refs[i].getRemote();
                if (newName.equals(refStr)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setRemote(oldName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
    }
    
    public final class WebXmlRefLocalMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlRefLocalMoveClassRefactoringElement */
        public WebXmlRefLocalMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlRefLocalMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef[] refs = webXmlDD.getEjbLocalRef();
            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String refStr = refs[i].getLocal();
                if (oldName.equals(refStr)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setLocal(newName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
        
        public void undoExternalChange() {
            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef[] refs = webXmlDD.getEjbLocalRef();
            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String refStr = refs[i].getLocal();
                if (newName.equals(refStr)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setLocal(oldName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
    }
    
    public final class WebXmlRefLocalHomeMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlRefLocalHomeMoveClassRefactoringElement */
        public WebXmlRefLocalHomeMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, "TXT_WebXmlRefLocalHomeMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef[] refs = webXmlDD.getEjbLocalRef();
            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String refStr = refs[i].getLocalHome();
                if (oldName.equals(refStr)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setLocalHome(newName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
        
        public void undoExternalChange() {
            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef[] refs = webXmlDD.getEjbLocalRef();
            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef ref = null;
            for (int i=0; i < refs.length; i++) {
                String refStr = refs[i].getLocalHome();
                if (newName.equals(refStr)) {
                    ref = refs[i];
                    break;
                }
            }
            if (ref!=null) {
                ref.setLocalHome(oldName);
                try {
                    webXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                }
            }
        }
    }
    
}