/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.refactoring.moveclass.EjbJarMoveClassRefactoring;
import org.netbeans.modules.j2ee.refactoring.moveclass.JaxWsXmlMoveClassRefactoring;
import org.netbeans.modules.j2ee.refactoring.moveclass.PersistenceXmlMoveClassRefactoring;
import org.netbeans.modules.j2ee.refactoring.moveclass.SunJaxWsXmlMoveClassRefactoring;
import org.netbeans.modules.j2ee.refactoring.moveclass.TldMoveClassRefactoring;
import org.netbeans.modules.j2ee.refactoring.moveclass.WebXmlMoveClassRefactoring;
import org.netbeans.modules.j2ee.refactoring.moveclass.WebservicesXmlMoveClassRefactoring;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.FunctionType;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.ValidatorType;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.wsdl.config.api.Configuration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public class J2EEMoveClassRefactoringPlugin implements RefactoringPlugin {
    
    /** This one is important creature - makes sure that cycles between plugins won't appear */
    private static ThreadLocal semafor = new ThreadLocal();
    
    private EjbJarMoveClassRefactoring ejbJarMoveClassRefactor;
    private WebXmlMoveClassRefactoring webXmlMoveClassRefactor;
    private TldMoveClassRefactoring tldMoveClassRefactor;
    private WebservicesXmlMoveClassRefactoring webservicesXmlMoveClassRefactor;
    private PersistenceXmlMoveClassRefactoring persistenceXmlMoveClassRefactor;
    private JaxWsXmlMoveClassRefactoring jaxWsXmlMoveClassRefactor;
    private SunJaxWsXmlMoveClassRefactoring sunJaxWsXmlMoveClassRefactor;
    
    private AbstractRefactoring refactoring;
    
    public void cancelRequest() {
        
    }
    
    private static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.moveclass");   // NOI18N
    
    /** Creates a new instance of J2EEMoveClassRefactoringPlugin */
    public J2EEMoveClassRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
    }
    
    /** Checks pre-conditions of the refactoring and returns problems.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem preCheck() {
        return null;
    }
    
    public Problem fastCheckParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            MoveClassRefactoring moveRefactor = ((MoveClassRefactoring)refactoring);
            
            Collection resources = moveRefactor.getResources();
            err.log("resources: " + resources);
            
            FileObject target = moveRefactor.getTargetClassPathRoot();
            err.log("target: " + target);
            
            if (!isEjb30()){
                Problem ejbJarProblem = getEjbJarMoveClassRefactor().fastCheckParameters(resources, target);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            } else if (hasEjbJar()){
                Problem ejbJarProblem = new Problem(false, NbBundle.getMessage(J2EEMoveClassRefactoringPlugin.class, "TXT_EjbJarMoveClassWarning"));  //NOI18N
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            
            semafor.set(null);
        }
        return problem;
    }
   
    private boolean hasEjbJar(){
        MoveClassRefactoring moveRefactor = ((MoveClassRefactoring)refactoring);
        for (Object elem : moveRefactor.getResources()) {
            Resource res = (Resource) elem;
            for (Object elem2 : res.getClassifiers()) {
                JavaClass javaClass = (JavaClass) elem2;
                if (Utility.hasEjbJar(Utility.getRelevantEjbModules(javaClass))){
                    return true;
                }
            }
        }
        return false;
    }
    
    private boolean isEjb30(){
        MoveClassRefactoring moveRefactor = ((MoveClassRefactoring)refactoring);
        for (Object elem : moveRefactor.getResources()) {
            Resource res = (Resource) elem;
            for (Object elem2 : res.getClassifiers()) {
                JavaClass javaClass = (JavaClass) elem2;
                if (Utility.isEjb30(javaClass)){
                    return true;
                }
            }
        }
        return false;
    }
    
    /** Checks parameters of the refactoring.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem checkParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            MoveClassRefactoring moveRefactor = ((MoveClassRefactoring)refactoring);
            
            Collection resources = moveRefactor.getResources();
            err.log("resources: " + resources);
            
            FileObject target = moveRefactor.getTargetClassPathRoot();
            err.log("target: " + target);
            
            if (!isEjb30()){
                Problem ejbJarProblem = getEjbJarMoveClassRefactor().checkParameters(resources, target);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            semafor.set(null);
        }
        return problem;
    }
    
    /** Collects refactoring elements for a given refactoring.
     * @param refactoringElements Collection of refactoring elements - the implementation of this method
     * should add refactoring elements to this collections. It should make no assumptions about the collection
     * content.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        
        // FYI - Rename Package is a set of Move Class refactorings
        Problem problem = null;
        
        if (semafor.get() == null) {
            semafor.set(new Object());
            
            MoveClassRefactoring moveClassRefactor = ((MoveClassRefactoring)refactoring);
            Collection resources = moveClassRefactor.getResources();
            err.log("resources: " + resources);
            
            
            Problem webXmlProblem = getWebXmlMoveClassRefactor().prepare(moveClassRefactor, resources, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, webXmlProblem);
            
            Problem tldProblem = getTldMoveClassRefactor().prepare(moveClassRefactor, resources, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, tldProblem);
            
            if (!isEjb30()){
                Problem ejbJarProblem = getEjbJarMoveClassRefactor().prepare(moveClassRefactor, resources, refactoringElements);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            
            Problem webservicesProblem = getWebservicesXmlMoveClassRefactor().prepare(moveClassRefactor, resources, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, webservicesProblem);
            
            Problem persistenceXmlMoveClassRefactoring = getPersistenceXmlMoveClassRefactoring().prepare(moveClassRefactor, resources, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, persistenceXmlMoveClassRefactoring);
            
            Problem jaxWsXmlMoveClassRefactoring = getJaxWsXmlMoveClassRefactoring().prepare(moveClassRefactor, resources, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, jaxWsXmlMoveClassRefactoring);
            
            Problem sunJaxWsXmlMoveClassRefactoring = getSunJaxWsXmlMoveClassRefactoring().prepare(moveClassRefactor, resources, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, sunJaxWsXmlMoveClassRefactoring);
            
            semafor.set(null);
        }
        
        err.log("Gonna return problem: " + problem);
        return problem;
    }
    
    private EjbJarMoveClassRefactoring getEjbJarMoveClassRefactor() {
        if (ejbJarMoveClassRefactor == null) {
            ejbJarMoveClassRefactor = new EjbJarMoveClassRefactoring();
        }
        return ejbJarMoveClassRefactor;
    }
    
    private WebXmlMoveClassRefactoring getWebXmlMoveClassRefactor() {
        if (webXmlMoveClassRefactor == null) {
            webXmlMoveClassRefactor = new WebXmlMoveClassRefactoring();
        }
        return webXmlMoveClassRefactor;
    }
    
    private TldMoveClassRefactoring getTldMoveClassRefactor() {
        if (tldMoveClassRefactor == null) {
            tldMoveClassRefactor = new TldMoveClassRefactoring();
        }
        return tldMoveClassRefactor;
    }
    
    private WebservicesXmlMoveClassRefactoring getWebservicesXmlMoveClassRefactor() {
        if (webservicesXmlMoveClassRefactor == null) {
            webservicesXmlMoveClassRefactor = new WebservicesXmlMoveClassRefactoring();
        }
        return webservicesXmlMoveClassRefactor;
    }
    
    private PersistenceXmlMoveClassRefactoring getPersistenceXmlMoveClassRefactoring(){
        if (persistenceXmlMoveClassRefactor == null){
            persistenceXmlMoveClassRefactor  = new PersistenceXmlMoveClassRefactoring();
        }
        return persistenceXmlMoveClassRefactor;
    }
    
    private JaxWsXmlMoveClassRefactoring getJaxWsXmlMoveClassRefactoring(){
        if (jaxWsXmlMoveClassRefactor == null){
            jaxWsXmlMoveClassRefactor = new JaxWsXmlMoveClassRefactoring();
        }
        return jaxWsXmlMoveClassRefactor;
    }
    
    private SunJaxWsXmlMoveClassRefactoring getSunJaxWsXmlMoveClassRefactoring(){
        if (sunJaxWsXmlMoveClassRefactor == null){
            sunJaxWsXmlMoveClassRefactor= new SunJaxWsXmlMoveClassRefactoring();
        }
        return sunJaxWsXmlMoveClassRefactor;
    }
    
}
