/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring;

import java.util.Collection;
import javax.jmi.reflect.RefObject;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring.ParameterInfo;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.ErrorManager;

import org.netbeans.modules.j2ee.refactoring.changeparam.*;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public class J2EEChangeParamRefactoringPlugin implements RefactoringPlugin {
    
    /** This one is important creature - makes sure that cycles between plugins won't appear */
    private static ThreadLocal semafor = new ThreadLocal();
    
    private EjbJarChangeParamRefactoring ejbJarChangeParamRefactor;
//    private WebXmlChangeParamRefactoring webXmlChangeParamRefactor;
//    private TldChangeParamRefactoring tldChangeParamRefactor;
    private WebservicesXmlChangeParamRefactoring webservicesXmlChangeParamRefactor;
    
    private AbstractRefactoring refactoring;
    
    private static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.changeparam");   // NOI18N
    
    /** Creates a new instance of J2EEChangeParamRefactoringPlugin */
    public J2EEChangeParamRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
    }
    
    /** Checks pre-conditions of the refactoring and returns problems.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem preCheck() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            ChangeParametersRefactoring changeParamRefactor = ((ChangeParametersRefactoring)refactoring);
            
            RefObject refO = (RefObject) changeParamRefactor.getRefactoredObject();
            err.log("refO: " + refO);
            if (!Utility.isEjb30(refO)){
                Problem ejbJarProblem = getEjbJarChangeParamRefactor().preCheck(refO);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            } else if (Utility.hasEjbJar(refO)){
                Problem ejbJarProblem = new Problem(false, NbBundle.getMessage(J2EEChangeParamRefactoringPlugin.class, "TXT_EjbJarChangeParamsWarning"));  //NOI18N
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            
            Problem websvcProblem = getWebservicesXmlChangeParamRefactor().preCheck(refO);
            problem = Utility.addProblemsToEnd(problem, websvcProblem);
            
            semafor.set(null);
        }
        
        return problem;
    }
    
    public Problem fastCheckParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            ChangeParametersRefactoring changeParamRefactor = ((ChangeParametersRefactoring)refactoring);
            
            RefObject refO = (RefObject) changeParamRefactor.getRefactoredObject();
            err.log("refO: " + refO);
            
            if (!Utility.isEjb30(refO)){
                Problem ejbJarProblem = getEjbJarChangeParamRefactor().fastCheckParameters(refO);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            
            Problem websvcProblem = getWebservicesXmlChangeParamRefactor().fastCheckParameters(refO);
            problem = Utility.addProblemsToEnd(problem, websvcProblem);
            
            semafor.set(null);
        }
        return problem;
    }
    
    /** Checks parameters of the refactoring.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem checkParameters() {
        return fastCheckParameters();
    }
    
    /** Collects refactoring elements for a given refactoring.
     * @param refactoringElements Collection of refactoring elements - the implementation of this method
     * should add refactoring elements to this collections. It should make no assumptions about the collection
     * content.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            ChangeParametersRefactoring changeParamRefactor = ((ChangeParametersRefactoring)refactoring);
            
            RefObject refO = (RefObject) changeParamRefactor.getRefactoredObject();
            ParameterInfo[] paramInfo = changeParamRefactor.getParameterInfo();
            int modifiers = changeParamRefactor.getModifiers();
            
            err.log("refO: " + refO);
            
            //        Problem webXmlProblem = getWebXmlChangeParamRefactor().prepare(refO, newName, refactoringElements);
            //        problem = Utility.addProblemsToEnd(problem, webXmlProblem);
            //
            //        Problem tldProblem = getTldChangeParamRefactor().prepare(refO, newName, refactoringElements);
            //        problem = Utility.addProblemsToEnd(problem, tldProblem);
            
            if (!Utility.isEjb30(refO)){
                Problem ejbJarProblem = getEjbJarChangeParamRefactor().prepare(refactoring, refO, paramInfo, modifiers, refactoringElements);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            
            Problem webservicesProblem = getWebservicesXmlChangeParamRefactor().prepare(refactoring, refO, paramInfo, modifiers, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, webservicesProblem);
            
            semafor.set(null);
        }
        err.log("Gonna return problem: " + problem);
        return problem;
    }
    
    public void cancelRequest() { }
    
    private EjbJarChangeParamRefactoring getEjbJarChangeParamRefactor() {
        if (ejbJarChangeParamRefactor == null) {
            ejbJarChangeParamRefactor = new EjbJarChangeParamRefactoring();
        }
        return ejbJarChangeParamRefactor;
    }
    
//    private WebXmlChangeParamRefactoring getWebXmlChangeParamRefactor() {
//        if (webXmlChangeParamRefactor == null) {
//            webXmlChangeParamRefactor = new WebXmlChangeParamRefactoring();
//        }
//        return webXmlChangeParamRefactor;
//    }
//
//    private TldChangeParamRefactoring getTldChangeParamRefactor() {
//        if (tldChangeParamRefactor == null) {
//            tldChangeParamRefactor = new TldChangeParamRefactoring();
//        }
//        return tldChangeParamRefactor;
//    }
//
    private WebservicesXmlChangeParamRefactoring getWebservicesXmlChangeParamRefactor() {
        if (webservicesXmlChangeParamRefactor == null) {
            webservicesXmlChangeParamRefactor = new WebservicesXmlChangeParamRefactoring();
        }
        return webservicesXmlChangeParamRefactor;
    }
    
}
