/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring;

import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.ClassDefinition;

import java.util.Iterator;

/**
 * @author pfiala
 */
public abstract class EjbInterfaceType {

    public static final EjbInterfaceType BEAN_IMPL = new EjbInterfaceType() {
        public String getClassName(Ejb bean) {
            return bean == null ? null : bean.getEjbClass();
        }

        public void setNewClassName(Ejb bean, String newName) {
            if (bean != null) {
                bean.setEjbClass(newName);
            }
        }

        protected String getSuperClassName(Class beanType) {
            if (MessageDriven.class.isAssignableFrom(beanType)) {
                return Utility.MESSAGE_DRIVEN_BEAN;
            } else if (Entity.class.isAssignableFrom(beanType)) {
                return Utility.ENTITY_BEAN;
            } else if (Session.class.isAssignableFrom(beanType)) {
                return Utility.SESSION_BEAN;
            } else {
                return null;
            }
        }

        public String getSuffix() {
            return "Bean"; //NOI18N
        }

        public String toString() {
            return "implementation class"; //NOI18N
        }
    };

    public static final EjbInterfaceType LOCAL_HOME = new EjbInterfaceType() {
        public String getClassName(Ejb bean) {
            if (bean instanceof EntityAndSession) {
                return ((EntityAndSession) bean).getLocalHome();
            } else {
                return null;
            }
        }

        public void setNewClassName(Ejb bean, String newName) {
            if (bean instanceof EntityAndSession) {
                ((EntityAndSession) bean).setLocalHome(newName);
            }
        }

        protected String getSuperClassName(Class beanType) {
            return Utility.EJB_LOCAL_HOME;
        }

        public String getSuffix() {
            return "LocalHome";  //NOI18N
        }

        public String toString() {
            return "local home interface"; //NOI18N
        }

        public CommonDDBean[] getReferences(Ejb bean) {
            return bean.getEjbLocalRef();
        }

        public String getReferenceValue(CommonDDBean ref) {
            return ((EjbLocalRef)ref).getLocalHome();
        }

        public void setRefValue(CommonDDBean ref, String value) {
            ((EjbLocalRef) ref).setLocalHome(value);
        }
    };

    public static final EjbInterfaceType LOCAL = new EjbInterfaceType() {
        public String getClassName(Ejb bean) {
            if (bean instanceof EntityAndSession) {
                return ((EntityAndSession) bean).getLocal();
            } else {
                return null;
            }
        }

        public void setNewClassName(Ejb bean, String newName) {
            if (bean instanceof EntityAndSession) {
                ((EntityAndSession) bean).setLocal(newName);
            }
        }

        protected String getSuperClassName(Class beanType) {
            return Utility.EJB_LOCAL_OBJECT;
        }

        public String getSuffix() {
            return "Local"; //NOI18N
        }

        public String toString() {
            return "local interface"; //NOI18N
        }

        public CommonDDBean[] getReferences(Ejb bean) {
            return bean.getEjbLocalRef();
        }

        public String getReferenceValue(CommonDDBean ref) {
            return ((EjbLocalRef)ref).getLocal();
        }

        public void setRefValue(CommonDDBean ref, String value) {
            ((EjbLocalRef) ref).setLocal(value);
        }
    };

    public static final EjbInterfaceType REMOTE = new EjbInterfaceType() {
        public String getClassName(Ejb bean) {
            if (bean instanceof EntityAndSession) {
                return ((EntityAndSession) bean).getRemote();
            } else {
                return null;
            }
        }

        public void setNewClassName(Ejb bean, String newName) {
            if (bean instanceof EntityAndSession) {
                ((EntityAndSession) bean).setRemote(newName);
            }
        }

        protected String getSuperClassName(Class beanType) {
            return Utility.EJB_OBJECT;
        }

        public String getSuffix() {
            return "Remote";  //NOI18N
        }

        public String toString() {
            return "remote interface"; //NOI18N
        }

        public CommonDDBean[] getReferences(Ejb bean) {
            return bean.getEjbRef();
        }

        public String getReferenceValue(CommonDDBean ref) {
            return ((EjbRef)ref).getRemote();
        }

        public void setRefValue(CommonDDBean ref, String value) {
            ((EjbRef) ref).setRemote(value);
        }
    };

    public static final EjbInterfaceType HOME = new EjbInterfaceType() {
        public String getClassName(Ejb bean) {
            if (bean instanceof EntityAndSession) {
                return ((EntityAndSession) bean).getHome();
            } else {
                return null;
            }
        }

        public void setNewClassName(Ejb bean, String newName) {
            if (bean instanceof EntityAndSession) {
                ((EntityAndSession) bean).setHome(newName);
            }
        }

        protected String getSuperClassName(Class beanType) {
            return Utility.EJB_HOME;
        }

        public String getSuffix() {
            return "RemoteHome";  //NOI18N
        }

        public String toString() {
            return "home interface"; //NOI18N
        }

        public CommonDDBean[] getReferences(Ejb bean) {
            return bean.getEjbRef();
        }

        public String getReferenceValue(CommonDDBean ref) {
            return ((EjbRef)ref).getHome();
        }

        public void setRefValue(CommonDDBean ref, String value) {
            ((EjbRef) ref).setHome(value);
        }
    };

    public static final EjbInterfaceType LOCAL_BUSINESS = new EjbInterfaceType() {
        public String getClassName(Ejb bean) {
            return getClassNameForBeanBaseName(LOCAL.getBeanBaseName(LOCAL.getClassName(bean)));
        }

        public void setNewClassName(Ejb bean, String newName) {

        }

        protected String getSuperClassName(Class beanType) {
            return null;
        }

        public String getSuffix() {
            return "LocalBusiness"; //NOI18N
        }

        public String toString() {
            return "local business interface"; //NOI18N
        }
    };

    public static final EjbInterfaceType REMOTE_BUSINESS = new EjbInterfaceType() {
        public String getClassName(Ejb bean) {
            return getClassNameForBeanBaseName(REMOTE.getBeanBaseName(REMOTE.getClassName(bean)));
        }

        public void setNewClassName(Ejb bean, String newName) {

        }

        protected String getSuperClassName(Class beanType) {
            return null;
        }

        public String getSuffix() {
            return "RemoteBusiness"; //NOI18N
        }

        public String toString() {
            return "remote business interface"; //NOI18N
        }
    };

    public abstract String getClassName(Ejb bean);

    public abstract void setNewClassName(Ejb bean, String newName);
    protected abstract String getSuperClassName(Class beanType);
    public abstract String getSuffix();

    public JavaClass resolveClass(Ejb bean) {
        JavaClass javaClass = Utility.resolveRealClass(getClassName(bean));
        if (javaClass != null) {
            String superClassName = getSuperClassName(bean.getClass());
            if (superClassName == null || Utility.isSubTypeOf(javaClass, superClassName)) {
                return javaClass;
            }
        }
        return null;
    }

    public String getClassNameForBeanBaseName(String beanBaseName) {
        return beanBaseName + getSuffix();
    }

    public String getBeanBaseName(String className) {
        return stripSuffix(className, getSuffix());
    }

    private static String stripSuffix(String s, String suffix) {
        return s != null && s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : s;
    }

    public Ejb getBean(EnterpriseBeans eBeans, Class beanType, String className) {
        if (eBeans != null) {
            Ejb[] ejbs = eBeans.getEjbs();
            if (ejbs != null) {
                for (int i = 0; i < ejbs.length; i++) {
                    Ejb ejb = ejbs[i];
                    if (ejb != null && beanType.isAssignableFrom(ejb.getClass())) {
                        Ejb bean = ejbs[i];
                        if (className.equals(getClassName(bean))) {
                            return bean;
                        }
                    }
                }
            }
        }
        return null;
    }

    public Ejb getBean(EnterpriseBeans eBeans, Class beanType, ClassDefinition jc) {
        if (eBeans != null) {
            Ejb[] ejbs = eBeans.getEjbs();
            if (ejbs != null) {
                for (int i = 0; i < ejbs.length; i++) {
                    Ejb ejb = ejbs[i];
                    if (ejb != null && beanType.isAssignableFrom(ejb.getClass())) {
                        Ejb bean = ejbs[i];
                        JavaClass javaClass = resolveClass(bean);
                        if (javaClass != null && (javaClass.isSubTypeOf(jc) ||jc.isSubTypeOf(javaClass))) {
                            return bean;
                        }
                    }
                }
            }
        }
        return null;
    }

    public CommonDDBean[] getReferences(Ejb bean) {
        return null;
    }

    public String getReferenceValue(CommonDDBean ref) {
        return null;
    }

    public void setRefValue(CommonDDBean ref, String value) {
    }



    public static EjbInterfaceType getEjbInterfaceType(ClassDefinition javaClass, boolean resolveBusiness) {
        if (Utility.isSubTypeOf(javaClass, Utility.EJB_LOCAL_OBJECT)) {
            return LOCAL;
        } else if (Utility.isSubTypeOf(javaClass, Utility.EJB_OBJECT)) {
            return REMOTE;
        } else if (Utility.isSubTypeOf(javaClass, Utility.EJB_HOME)) {
            return HOME;
        } else if (Utility.isSubTypeOf(javaClass, Utility.EJB_LOCAL_HOME)) {
            return LOCAL_HOME;
        } else if (Utility.isSubTypeOf(javaClass, Utility.SESSION_BEAN) ||
                Utility.isSubTypeOf(javaClass, Utility.ENTITY_BEAN) ||
                Utility.isSubTypeOf(javaClass, Utility.MESSAGE_DRIVEN_BEAN)) {
            return BEAN_IMPL;
        } else {
            for (Iterator it = ((JavaClass) javaClass).getImplementors().iterator(); it.hasNext();) {
                ClassDefinition implementor = (ClassDefinition) it.next();
                EjbInterfaceType ejbInterfaceType = getEjbInterfaceType(implementor, false);
                if (ejbInterfaceType != null) {
                    if (resolveBusiness) {
                        String beanBaseName = ejbInterfaceType.getBeanBaseName(implementor.getName());
                        if (ejbInterfaceType == LOCAL) {
                            if (beanBaseName.equals(LOCAL_BUSINESS.getBeanBaseName(javaClass.getName()))) {
                                return LOCAL_BUSINESS;
                            }
                        } else if (ejbInterfaceType == REMOTE) {
                            if (beanBaseName.equals(REMOTE_BUSINESS.getBeanBaseName(javaClass.getName()))) {
                                return REMOTE_BUSINESS;
                            }
                        }
                    } else {
                        return ejbInterfaceType;
                    }
                }
            }
            return null;
        }
    }
}
