/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.persistence.dd;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.junit.NbTestCase;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/**
 *
 * @author Andrei Badea
 */
public class WeakMetadataUnitTest extends NbTestCase {

    private FileObject dataDir;
    private FileObject workDir;

    public WeakMetadataUnitTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        clearWorkDir();
        dataDir = FileUtil.toFileObject(getDataDir());
        workDir = FileUtil.toFileObject(getWorkDir());
    }

    private static FileObject copyFile(FileObject source, FileObject destFolder) throws IOException {
        return FileUtil.copyFile(source, destFolder, source.getName());
    }

    public void testWeakMetadataUnit() throws Exception {
        FileObject cpRoot = workDir.createFolder("root");
        assertNotNull(cpRoot);
        FileObject dd = copyFile(dataDir.getFileObject("orm.xml"), workDir);
        assertNotNull(dd);

        ClassPath classPath = ClassPathSupport.createClassPath(new FileObject[] { cpRoot });
        WeakMetadataUnit metadataUnit = new WeakMetadataUnit(dd, classPath);

        assertSame(classPath, metadataUnit.getClassPath());
        assertSame(dd, metadataUnit.getDeploymentDescriptor());

        Reference<ClassPath> classPathRef = new WeakReference<ClassPath>(classPath);
        classPath = null;
        assertGC("Should be possible to GC classPath", classPathRef);

        // should return an empty classpath after the original one was GCd

        ClassPath newClassPath = metadataUnit.getClassPath();
        assertNotNull(newClassPath);
        assertEquals(0, newClassPath.entries().size());
    }

    public void testConstructorParametersCanBeNull() {
        WeakMetadataUnit metadataUnit = new WeakMetadataUnit(null, null);

        assertNull(metadataUnit.getDeploymentDescriptor());

        ClassPath classPath = metadataUnit.getClassPath();
        assertNotNull(classPath);
        assertEquals(0, classPath.entries().size());
    }
}
