/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.persistence.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.ErrorManager;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/**
 *
 * @author Martin Adamek
 */
public class EntityNode extends AbstractNode implements OpenCookie {
    
    private final PropertyChangeListener nameChangeListener;
    private Entity entity;
    private ClassPath srcPath;
    
    public EntityNode(Entity model, EntityMappings module, ClassPath srcPath) {
        this(new InstanceContent(), model, module, srcPath);
    }

    private EntityNode(InstanceContent content, Entity model, EntityMappings module, ClassPath srcPath) {
        super(new EntityChildren(model, srcPath, module), new AbstractLookup(content));
        setIconBaseWithExtension("org/netbeans/modules/j2ee/persistence/ui/resources/EntityNodeIcon.gif");
        setName(model.getName()+"");
        this.entity = model;
        this.srcPath = srcPath;
        setDisplayName();
        nameChangeListener = new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent pce) {
                setDisplayName();
            }
        };
        model.addPropertyChangeListener(
            WeakListeners.propertyChange(nameChangeListener,model));
        content.add(this);
        JavaClass jc = (JavaClass) JavaModel.getDefaultExtent().getType().resolve(entity.getClass2());
        if (jc != null) {
            content.add(jc);
        }
    }
    
    private void setDisplayName() {
        setDisplayName(entity.getName());
    }
    
    // Create the popup menu:
    public Action[] getActions(boolean context) {
        return new SystemAction[] {
            SystemAction.get(OpenAction.class)
        };
    }

    public void open() {
//	getEditorSupport().openORMEditor(true);
        DataObject ce = getBeanDo();
        if (ce != null) {
            OpenCookie cookie = (OpenCookie) ce.getCookie(OpenCookie.class);
            if(cookie != null){
                cookie.open();
            }
        }
    }
    
    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }
    
    // from EjbViewController ==================================================
     
    private FileObject findBeanFo() {
        return srcPath.findResource(entity.getClass2().replace('.','/')+".java"); // NOI18N
    }
    
    public DataObject getBeanDo() {
        FileObject src = findBeanFo();
        try {
            if (src != null) {
                return DataObject.find(src);
            }
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().log("Cannot find data object for " + entity.getClass2());
        }
        return null;
    } 

}
