/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.persistence.editor.completion;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class JMIUtils {
    
    private static MDRepository repository = JavaModel.getJavaRepository();

    private BaseDocument doc;
    private FileObject fileObject;

    public static synchronized JMIUtils get(BaseDocument doc) {
        JMIUtils utils = (JMIUtils)doc.getProperty(JMIUtils.class);
        if (utils == null) {
            utils = new JMIUtils(doc);
            doc.putProperty(JMIUtils.class, utils);
        }
        return utils;
    }
    
    private JMIUtils(BaseDocument doc){
        this.doc = doc;
        DataObject dob = NbEditorUtilities.getDataObject(doc);
        if (dob != null) {
            FileObject fo = dob.getPrimaryFile();
            ClassPath sourceCP = ClassPath.getClassPath(fo, ClassPath.SOURCE);
            if (sourceCP != null) {
                this.fileObject = sourceCP.findOwnerRoot(fo);
            }
        }
    }
    
    public void beginTrans(boolean write) {
        repository.beginTrans(write);
        if (fileObject != null) {
            try {
                // needs to be done in try..catch to make sure the transaction is closed
                // if this operation fails
                JavaModel.setClassPath(fileObject);
            } catch (RuntimeException e) {
                repository.endTrans(write); // fail if b==true (i.e. write transaction)
                throw e;
            } catch (Error e) {
                repository.endTrans(write); // fail if b==true (i.e. write transaction)
                throw e;
            }
        } // else -> global class path should be used
    }

    public void endTrans(boolean fail) {
        repository.endTrans(fail);
    }
}
