/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.metadata;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.BooleanLiteral;
import org.netbeans.jmi.javamodel.CharLiteral;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.ClassExpression;
import org.netbeans.jmi.javamodel.DoubleLiteral;
import org.netbeans.jmi.javamodel.FloatLiteral;
import org.netbeans.jmi.javamodel.IntLiteral;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Literal;
import org.netbeans.jmi.javamodel.LongLiteral;
import org.netbeans.jmi.javamodel.NullLiteral;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

/**
 *
 * @author Martin Adamek
 * @author Marek Fukala
 */
public class Utils {
    
    public static boolean isOfType(JavaClass javaClass, Type type) {
        String typeName = type.getName();
        
        if(javaClass.getName().equals(typeName)) return true;
        
        if (javaClass.getName().equals("java.lang.Object")) { //NOI18N // break recurssion
            return false;
        }
        
        for (JavaClass intf : (List<JavaClass>) javaClass.getInterfaces()) {
            if (intf.getName().equals(typeName)) {
                return true;
            }
            
            // recurssively see if any of the implemented interfaces is Serializable
            if (isOfType(intf, type)) return true;
        }
        // search all super classes recurssively
        return (isOfType(javaClass.getSuperClass(), type));
    }
    
    public static boolean containsClass(Library library, String className) {
        List roots = library.getContent("classpath"); //NOI18N
        for (Iterator it = roots.iterator(); it.hasNext();) {
            URL rootUrl = (URL) it.next();
            FileObject root = URLMapper.findFileObject(rootUrl);
            if (root != null && "jar".equals(rootUrl.getProtocol())) {  //NOI18N
                FileObject archiveRoot = FileUtil.getArchiveRoot(FileUtil.getArchiveFile(root));
                String classRelativePath = className.replace('.', '/') + ".class"; //NOI18N
                if (archiveRoot.getFileObject(classRelativePath) != null) {
                    return true;
                };
            }
        }
        return false;
    }
    
    public static Map getNNAttributes(Annotation annotation) {
        Map attributes = new HashMap();
        for (Iterator it = annotation.getAttributeValues().iterator(); it.hasNext();) {
            AttributeValue attributeValue = (AttributeValue) it.next();
            // TODO: check also non-string values? are there any? e.g. FetchType.LAZY?
            attributes.put(attributeValue.getDefinition().getName(), stringValue(attributeValue));
        }
        return attributes;
    }
    
    public static String stringValue(AttributeValue attrVal) {
        InitialValue value = attrVal.getValue();
        String result = valueToString(value);
        if (result == null) {
            result = value.getResource().getSourceText().substring(value.getStartOffset(), value.getEndOffset());
            if (result.startsWith("\"") && result.endsWith("\"")) {
                result = result.substring(1, result.length() - 1);
            }
        }
        return result;
    }

    private static String valueToString(InitialValue value) {
        if (value instanceof Literal) {
            if (value instanceof StringLiteral) {
                return ((StringLiteral)value).getValue();
            } else if (value instanceof IntLiteral) {
                return Integer.toString(((IntLiteral)value).getValue());
            } else if (value instanceof BooleanLiteral) {
                return Boolean.toString(((BooleanLiteral)value).isValue());
            } else if (value instanceof LongLiteral) {
                return Long.toString(((LongLiteral)value).getValue());
            } else if (value instanceof DoubleLiteral) {
                return Double.toString(((DoubleLiteral)value).getValue());
            } else if (value instanceof CharLiteral) {
                return ((CharLiteral)value).getValue();
            } else if (value instanceof FloatLiteral) {
                return Float.toString(((FloatLiteral)value).getValue());
            } else if (value instanceof NullLiteral) {
                return "null"; // NOI18N
            }
        } else if (value instanceof ClassExpression) {
            org.netbeans.jmi.javamodel.Type type = ((ClassExpression)value).getType();
            if (type!=null) {
                return type.getName();
            }
        }
        return null;
    }
    
    public static boolean containsService(Library library, String serviceName) {
        List roots = library.getContent("classpath"); //NOI18N
        for (Iterator it = roots.iterator(); it.hasNext();) {
            URL rootUrl = (URL) it.next();
            FileObject root = URLMapper.findFileObject(rootUrl);
            if (root != null && "jar".equals(rootUrl.getProtocol())) {  //NOI18N
                FileObject archiveRoot = FileUtil.getArchiveRoot(FileUtil.getArchiveFile(root));
                String serviceRelativePath = "META-INF/services/" + serviceName; //NOI18N
                if (archiveRoot.getFileObject(serviceRelativePath) != null) {
                    return true;
                };
            }
        }
        return false;
    }
    
    public static boolean containsClass(LibraryImplementation library, String className) {
        List roots = library.getContent("classpath"); //NOI18N
        for (Iterator it = roots.iterator(); it.hasNext();) {
            URL rootUrl = (URL) it.next();
            FileObject root = URLMapper.findFileObject(rootUrl);
            if (root != null && "jar".equals(rootUrl.getProtocol())) {  //NOI18N
                FileObject archiveRoot = FileUtil.getArchiveRoot(FileUtil.getArchiveFile(root));
                String classRelativePath = className.replace('.', '/') + ".class"; //NOI18N
                if (archiveRoot.getFileObject(classRelativePath) != null) {
                    return true;
                };
            }
        }
        return false;
    }
    
    public static boolean containsService(LibraryImplementation library, String serviceName) {
        List roots = library.getContent("classpath"); //NOI18N
        for (Iterator it = roots.iterator(); it.hasNext();) {
            URL rootUrl = (URL) it.next();
            FileObject root = URLMapper.findFileObject(rootUrl);
            if (root != null && "jar".equals(rootUrl.getProtocol())) {  //NOI18N
                FileObject archiveRoot = FileUtil.getArchiveRoot(FileUtil.getArchiveFile(root));
                String serviceRelativePath = "META-INF/services/" + serviceName; //NOI18N
                if (archiveRoot.getFileObject(serviceRelativePath) != null) {
                    return true;
                };
            }
        }
        return false;
    }
    
}
